/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice;

import com.moyettes.voice.packet.VoiceModSupportedPayload;
import com.moyettes.voice.packet.VoiceServerInfoPayload;
import com.moyettes.voice.server.VoiceServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.unmapped.C_3292284;
import net.ornithemc.osl.entrypoints.api.ModInitializer;
import net.ornithemc.osl.networking.api.CustomPayload;
import net.ornithemc.osl.networking.api.server.ServerConnectionEvents;
import net.ornithemc.osl.networking.api.server.ServerPlayNetworking;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Voice
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Voice Mod");
    private static VoiceServer voiceServer;
    private static final Map<Integer, String> playerAuthTokens;

    public void init() {
        LOGGER.info("Initializing voice mod!");
        try {
            voiceServer = new VoiceServer();
            voiceServer.start();
            LOGGER.info("Voice server started on port " + voiceServer.getPort() + " (from config)");
        }
        catch (IOException e) {
            LOGGER.error("Failed to start voice server: " + e.getMessage());
        }
        this.registerNetworkListeners();
    }

    private void registerNetworkListeners() {
        ServerPlayNetworking.registerListener((String)"voice|mod_supported", VoiceModSupportedPayload::new, (server, handler, player, payload) -> {
            LOGGER.info("Player " + player.f_4437619 + " supports voice mod with protocol " + payload.getProtocolVersion());
            String authToken = this.generateAuthToken(player.f_4437619);
            LOGGER.info("Generated auth token for player " + player.f_4437619 + " (network ID: " + player.f_5338989 + "): " + authToken);
            playerAuthTokens.put(player.f_5338989, authToken);
            String serverHost = this.getServerHost();
            VoiceServerInfoPayload serverInfo = new VoiceServerInfoPayload(voiceServer.getPort(), authToken, voiceServer.getProtocolVersion(), serverHost);
            ServerPlayNetworking.send((C_3292284)player, (String)"voice|server_info", (CustomPayload)serverInfo);
            LOGGER.info("Sent voice server info to " + player.f_4437619);
            return false;
        });
        ServerConnectionEvents.DISCONNECT.register((handler, player) -> {
            if (voiceServer != null) {
                voiceServer.disconnectPlayer(player.f_5338989);
            }
            playerAuthTokens.remove(player.f_5338989);
        });
    }

    private String generateAuthToken(String playerName) {
        return "token_" + playerName + "_" + System.currentTimeMillis();
    }

    private String getServerHost() {
        return voiceServer.getConfig().getServerHost();
    }

    public static VoiceServer getVoiceServer() {
        return voiceServer;
    }

    public static String getPlayerAuthToken(Integer playerNetworkId) {
        return playerAuthTokens.get(playerNetworkId);
    }

    static {
        playerAuthTokens = new HashMap<Integer, String>();
    }
}

