/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GroupLeavePacket
extends UdpPacket {
    private String groupName;

    public GroupLeavePacket() {
        super(UdpPacket.PacketType.GROUP_LEAVE);
    }

    public GroupLeavePacket(String groupName) {
        super(UdpPacket.PacketType.GROUP_LEAVE);
        this.groupName = groupName;
    }

    @Override
    protected void writeData(DataOutputStream dos) throws IOException {
        dos.writeBoolean(this.groupName != null);
        if (this.groupName != null) {
            dos.writeUTF(this.groupName);
        }
    }

    public static GroupLeavePacket read(DataInputStream dis) throws IOException {
        GroupLeavePacket packet = new GroupLeavePacket();
        boolean hasGroupName = dis.readBoolean();
        packet.groupName = hasGroupName ? dis.readUTF() : null;
        return packet;
    }

    public String getGroupName() {
        return this.groupName;
    }
}

