/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.client;

import com.moyettes.voice.audio.AdaptiveJitterBuffer;
import com.moyettes.voice.audio.AudioProcessor;
import com.moyettes.voice.audio.MicrophoneCapture;
import com.moyettes.voice.audio.OpenALAudioPlayback;
import com.moyettes.voice.audio.StereoAudioPlayback;
import com.moyettes.voice.client.init.Voice;
import com.moyettes.voice.config.ClientConfig;
import com.moyettes.voice.sound.Simple3DAudio;
import com.moyettes.voice.udp.GroupCreatePacket;
import com.moyettes.voice.udp.GroupDataPacket;
import com.moyettes.voice.udp.GroupJoinPacket;
import com.moyettes.voice.udp.GroupLeavePacket;
import com.moyettes.voice.udp.GroupListPacket;
import com.moyettes.voice.udp.GroupMemberUpdatePacket;
import com.moyettes.voice.udp.PingPacket;
import com.moyettes.voice.udp.PresenceBulkPacket;
import com.moyettes.voice.udp.PresenceUpdatePacket;
import com.moyettes.voice.udp.UdpPacket;
import com.moyettes.voice.udp.VoiceDataPacket;
import com.moyettes.voice.udp.VoiceDataRelayPacket;
import com.moyettes.voice.udp.VoiceHandshakeAckPacket;
import com.moyettes.voice.udp.VoiceHandshakePacket;
import com.moyettes.voice.utils.AudioUtils;
import com.moyettes.voice.utils.MinecraftAccessor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import net.minecraft.client.Minecraft;
import net.minecraft.unmapped.C_9590849;

public class VoiceClient {
    private DatagramSocket socket;
    private ExecutorService executor;
    private boolean connected = false;
    private String serverHost;
    private int serverPort;
    private Integer playerNetworkId;
    private boolean micEnabled;
    private volatile boolean micMuted = false;
    private volatile boolean userDeafened = false;
    private volatile boolean pushToTalk = false;
    private volatile boolean pttKeyPressed = false;
    private volatile double silenceThreshold = 0.0;
    private volatile float microphoneGain = 1.0f;
    private volatile float masterVolume = 1.0f;
    private volatile String inputDeviceName = null;
    private volatile String outputDeviceName = null;
    private volatile boolean isTalking = false;
    private volatile long lastDeviceChangeTime = 0L;
    private long lastTalkingTime = 0L;
    private Consumer<VoiceHandshakeAckPacket> handshakeCallback;
    private Consumer<GroupMemberUpdatePacket> groupCallback;
    private Consumer<GroupListPacket> groupListCallback;
    private Consumer<List<String>> groupMemberCallback;
    private MicrophoneCapture microphoneCapture;
    private AudioProcessor audioProcessor;
    private StereoAudioPlayback stereoAudioPlayback;
    private final Map<Integer, OpenALAudioPlayback> openALPlaybackBySender = new ConcurrentHashMap<Integer, OpenALAudioPlayback>();
    private final Map<Integer, StereoAudioPlayback> stereoPlaybackBySender = new ConcurrentHashMap<Integer, StereoAudioPlayback>();
    private final Map<Integer, PlaybackState> playbackStateMap = new ConcurrentHashMap<Integer, PlaybackState>();
    private final Map<Integer, AudioProcessor> decoderBySender = new ConcurrentHashMap<Integer, AudioProcessor>();
    private long sequenceNumber = 0L;
    private long lastAudioReceived = 0L;
    private final Map<Integer, Long> lastSeqBySender = new ConcurrentHashMap<Integer, Long>();
    private final Map<Integer, TreeMap<Long, BufferedPacket>> reorderBuffers = new ConcurrentHashMap<Integer, TreeMap<Long, BufferedPacket>>();
    private final Map<Integer, Integer> warmupRemainingBySender = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Long> lastTalkingByRemote = new ConcurrentHashMap<Integer, Long>();
    private final Set<Integer> activatedPlayers = ConcurrentHashMap.newKeySet();
    private final Set<Integer> presenceSupported = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Integer> presenceDeafened = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int REORDER_BUFFER_THRESHOLD = 10;
    private static final int WARMUP_PACKETS = 3;
    private final Map<Integer, Thread> senderThreads = new ConcurrentHashMap<Integer, Thread>();
    private final Map<Integer, BlockingQueue<AdaptiveJitterBuffer.BufferedPacket>> senderQueues = new ConcurrentHashMap<Integer, BlockingQueue<AdaptiveJitterBuffer.BufferedPacket>>();
    private final Map<Integer, Boolean> senderThreadRunning = new ConcurrentHashMap<Integer, Boolean>();
    private final Map<Integer, Set<Long>> enqueuedSeqBySender = new ConcurrentHashMap<Integer, Set<Long>>();
    private static final int SMALL_GAP_PLC_MAX = 4;
    private final Map<Integer, SourceType> activeSourceBySender = new ConcurrentHashMap<Integer, SourceType>();
    private final Map<Integer, ArrayDeque<Integer>> recentOpusCrcBySender = new ConcurrentHashMap<Integer, ArrayDeque<Integer>>();
    private static final int OPUS_CRC_WINDOW = 8;
    private long lastKeepAlive = 0L;
    private long lastSentKeepAlive = 0L;
    private boolean handshakeComplete = false;
    private Simple3DAudio simple3D;
    private MicrophoneCapture testMicrophoneCapture;
    private volatile boolean isMicrophoneTesting = false;
    private final Map<String, Float> playerVolumes = new ConcurrentHashMap<String, Float>();
    private volatile String currentGroupName = null;
    private final Set<Integer> groupMembers = ConcurrentHashMap.newKeySet();
    private ClientConfig config;
    private final byte[] audioGainBuffer = new byte[AudioProcessor.getFrameSize() * 2];
    private final Set<Long> sentSequenceNumbers = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final boolean DEBUG_LOG = false;
    private static long lastDebugLog = 0L;

    private boolean shouldProcessSource(Integer senderId, SourceType sourceType) {
        SourceType prev = this.activeSourceBySender.putIfAbsent(senderId, sourceType);
        return prev == null || prev == sourceType;
    }

    private void clearSourceState(Integer senderId) {
        StereoAudioPlayback stereoPlayback;
        this.senderThreadRunning.put(senderId, false);
        Thread thread = this.senderThreads.remove(senderId);
        if (thread != null) {
            thread.interrupt();
        }
        this.senderQueues.remove(senderId);
        this.enqueuedSeqBySender.remove(senderId);
        this.reorderBuffers.remove(senderId);
        this.activeSourceBySender.remove(senderId);
        OpenALAudioPlayback playback = this.openALPlaybackBySender.remove(senderId);
        if (playback != null) {
            playback.close();
        }
        if ((stereoPlayback = this.stereoPlaybackBySender.remove(senderId)) != null) {
            stereoPlayback.close();
        }
        this.playbackStateMap.remove(senderId);
        AudioProcessor decoder = this.decoderBySender.remove(senderId);
        if (decoder != null) {
            decoder.close();
        }
    }

    private boolean isDuplicateOpusPacket(Integer senderId, byte[] opusData) {
        if (senderId == null || opusData == null || opusData.length == 0) {
            return false;
        }
        CRC32 crc = new CRC32();
        crc.update(opusData, 0, opusData.length);
        int hash = (int)crc.getValue();
        ArrayDeque window = this.recentOpusCrcBySender.computeIfAbsent(senderId, k -> new ArrayDeque(8));
        if (window.contains(hash)) {
            return true;
        }
        if (window.size() >= 8) {
            window.pollFirst();
        }
        window.offerLast(hash);
        return false;
    }

    private void dbg(String msg) {
    }

    public VoiceClient(Integer playerNetworkId, boolean micEnabled) {
        this.playerNetworkId = playerNetworkId;
        this.micEnabled = micEnabled;
        this.executor = Executors.newCachedThreadPool();
        this.config = ClientConfig.load();
        this.loadConfigSettings();
        this.simple3D = new Simple3DAudio();
        if (!this.simple3D.initialize()) {
            Voice.LOGGER.warn("Warning: Simple 3D audio not initialized. 3D audio may not work.");
        }
        this.audioProcessor = new AudioProcessor();
        if (this.audioProcessor.isInitialized()) {
            this.audioProcessor.setMicrophoneGain(this.microphoneGain);
        }
        boolean useSpecificDevice = this.outputDeviceName != null && !this.outputDeviceName.equals("Default");
        this.stereoAudioPlayback = new StereoAudioPlayback(this.outputDeviceName);
        if (!this.stereoAudioPlayback.initialize()) {
            Voice.LOGGER.warn("Warning: Stereo audio playback not initialized. Microphone testing may not work.");
        }
        if (useSpecificDevice) {
            Voice.LOGGER.info("Using StereoAudioPlayback for output device: " + this.outputDeviceName);
        } else {
            Voice.LOGGER.info("OpenAL will be used for audio playback (sources created per sender), StereoAudioPlayback for testing");
            this.dbg("Playback backend: OpenAL (per-sender sources)");
        }
    }

    private void loadConfigSettings() {
        if (this.config == null) {
            return;
        }
        this.microphoneGain = this.config.getMicrophoneGain();
        this.masterVolume = this.config.getMasterVolume();
        this.silenceThreshold = this.config.getActivationThreshold();
        this.pushToTalk = this.config.isPushToTalk();
        this.inputDeviceName = this.config.getInputDevice();
        this.outputDeviceName = this.config.getOutputDevice();
        if (this.config.getPlayerVolumes() != null) {
            this.playerVolumes.clear();
            this.playerVolumes.putAll(this.config.getPlayerVolumes());
        }
    }

    public void connect(String serverHost, int serverPort, String authToken) throws IOException {
        if (this.connected) {
            return;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.socket = new DatagramSocket();
        try {
            this.socket.setReceiveBufferSize(131072);
            this.socket.setSendBufferSize(131072);
            this.socket.setReuseAddress(true);
            this.socket.setTrafficClass(4);
        }
        catch (Exception e) {
            Voice.LOGGER.warn("Failed to set socket optimizations: " + e.getMessage());
        }
        try {
            this.socket.connect(InetAddress.getByName(serverHost), serverPort);
        }
        catch (Exception e) {
            // empty catch block
        }
        VoiceHandshakePacket handshake = new VoiceHandshakePacket(this.playerNetworkId, authToken, this.micEnabled);
        this.sendPacket(handshake, serverHost, serverPort);
        this.connected = true;
        this.handshakeComplete = false;
        this.executor.submit(this::listenForPackets);
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.stopMicrophoneCapture();
        for (Integer senderId : this.senderThreadRunning.keySet()) {
            this.senderThreadRunning.put(senderId, false);
        }
        for (Thread thread : this.senderThreads.values()) {
            try {
                thread.interrupt();
                thread.join(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.senderThreads.clear();
        this.senderQueues.clear();
        this.senderThreadRunning.clear();
        for (OpenALAudioPlayback playback : this.openALPlaybackBySender.values()) {
            if (playback == null) continue;
            playback.close();
        }
        this.openALPlaybackBySender.clear();
        for (AudioProcessor decoder : this.decoderBySender.values()) {
            if (decoder == null) continue;
            decoder.close();
        }
        this.decoderBySender.clear();
        if (this.stereoAudioPlayback != null) {
            this.stereoAudioPlayback.clearQueue();
            this.stereoAudioPlayback.flushAudioBuffer();
            this.stereoAudioPlayback.close();
        }
        if (this.audioProcessor != null) {
            this.audioProcessor.close();
        }
        if (this.simple3D != null) {
            this.simple3D.cleanup();
            this.simple3D = null;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void listenForPackets() {
        byte[] buffer = new byte[2048];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        while (this.connected && !this.socket.isClosed()) {
            try {
                this.socket.receive(packet);
                this.handlePacket(packet);
                this.checkForStaleAudio();
                this.checkKeepAlive();
            }
            catch (IOException e) {
                String errorMsg;
                if (this.socket.isClosed() || (errorMsg = e.getMessage()) == null || errorMsg.contains("Connection reset") || errorMsg.contains("Connection refused") || errorMsg.contains("Network is unreachable") || errorMsg.contains("Receive timed out")) continue;
                Voice.LOGGER.warn("Error receiving packet: " + errorMsg);
            }
        }
    }

    private void handlePacket(DatagramPacket packet) {
        block13: {
            try {
                byte[] data = new byte[packet.getLength()];
                System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packet.getLength());
                UdpPacket udpPacket = UdpPacket.fromBytes(data);
                switch (udpPacket.getType()) {
                    case VOICE_HANDSHAKE_ACK: {
                        this.handleHandshakeAck((VoiceHandshakeAckPacket)udpPacket);
                        break;
                    }
                    case VOICE_DATA: {
                        this.handleVoiceData((VoiceDataPacket)udpPacket);
                        break;
                    }
                    case VOICE_DATA_RELAY: {
                        this.handleVoiceDataRelay((VoiceDataRelayPacket)udpPacket);
                        break;
                    }
                    case GROUP_DATA: {
                        this.handleGroupData((GroupDataPacket)udpPacket);
                        break;
                    }
                    case GROUP_MEMBER_UPDATE: {
                        this.handleGroupMemberUpdate((GroupMemberUpdatePacket)udpPacket);
                        break;
                    }
                    case GROUP_LIST: {
                        this.handleGroupList((GroupListPacket)udpPacket);
                        break;
                    }
                    case PING: {
                        this.handlePing();
                        break;
                    }
                    case PRESENCE_UPDATE: {
                        this.handlePresenceUpdate((PresenceUpdatePacket)udpPacket);
                        break;
                    }
                    case PRESENCE_BULK: {
                        this.handlePresenceBulk((PresenceBulkPacket)udpPacket);
                        break;
                    }
                    default: {
                        Voice.LOGGER.info("Received unhandled packet type: " + (Object)((Object)udpPacket.getType()));
                        break;
                    }
                }
            }
            catch (IOException e) {
                String errorMsg;
                if (!this.connected || (errorMsg = e.getMessage()) == null || errorMsg.contains("Connection reset") || errorMsg.contains("Connection refused") || errorMsg.contains("Network is unreachable")) break block13;
                Voice.LOGGER.warn("Error handling packet: " + errorMsg);
            }
        }
    }

    private void handleHandshakeAck(VoiceHandshakeAckPacket ack) {
        if (ack.isSuccess()) {
            this.handshakeComplete = true;
            this.lastKeepAlive = System.currentTimeMillis();
            this.lastSentKeepAlive = System.currentTimeMillis();
            if (this.micEnabled) {
                this.startMicrophoneCapture();
            }
            this.sendPresenceUpdate();
        } else {
            Voice.LOGGER.warn("Failed to connect to voice server: " + ack.getMessage());
            this.disconnect();
        }
        if (this.handshakeCallback != null) {
            this.handshakeCallback.accept(ack);
        }
    }

    private void handleVoiceData(VoiceDataPacket voiceData) {
        if (voiceData.getPlayerNetworkId() != null && !this.shouldProcessSource(voiceData.getPlayerNetworkId(), SourceType.DIRECT)) {
            this.dbg("Drop DIRECT from sender=" + voiceData.getPlayerNetworkId() + " due to activeSource=" + (Object)((Object)this.activeSourceBySender.get(voiceData.getPlayerNetworkId())));
            return;
        }
        if (voiceData.getAudioData().length == 0) {
            if (voiceData.getPlayerNetworkId() != null) {
                this.lastSeqBySender.remove(voiceData.getPlayerNetworkId());
                this.activatedPlayers.remove(voiceData.getPlayerNetworkId());
                this.clearSourceState(voiceData.getPlayerNetworkId());
                this.dbg("DIRECT end: cleared state for sender=" + voiceData.getPlayerNetworkId());
            }
            return;
        }
        if (voiceData.getPlayerNetworkId() != null && this.isDuplicateOpusPacket(voiceData.getPlayerNetworkId(), voiceData.getAudioData())) {
            this.dbg("CRC dedupe: drop DIRECT seq=" + voiceData.getSequenceNumber() + " sender=" + voiceData.getPlayerNetworkId());
            return;
        }
        this.processIncomingAudio(voiceData.getAudioData(), voiceData.getPlayerNetworkId(), voiceData.getSequenceNumber());
    }

    private void handleVoiceDataRelay(VoiceDataRelayPacket voiceDataRelay) {
        if (voiceDataRelay.getFromPlayerNetworkId() != null && !this.shouldProcessSource(voiceDataRelay.getFromPlayerNetworkId(), SourceType.RELAY)) {
            this.dbg("Drop RELAY from sender=" + voiceDataRelay.getFromPlayerNetworkId() + " due to activeSource=" + (Object)((Object)this.activeSourceBySender.get(voiceDataRelay.getFromPlayerNetworkId())));
            return;
        }
        if (voiceDataRelay.getAudioData().length == 0) {
            if (voiceDataRelay.getFromPlayerNetworkId() != null) {
                this.lastSeqBySender.remove(voiceDataRelay.getFromPlayerNetworkId());
                this.activatedPlayers.remove(voiceDataRelay.getFromPlayerNetworkId());
                this.clearSourceState(voiceDataRelay.getFromPlayerNetworkId());
                this.dbg("RELAY end: cleared state for sender=" + voiceDataRelay.getFromPlayerNetworkId());
            }
            return;
        }
        if (voiceDataRelay.getFromPlayerNetworkId() != null && this.isDuplicateOpusPacket(voiceDataRelay.getFromPlayerNetworkId(), voiceDataRelay.getAudioData())) {
            this.dbg("CRC dedupe: drop RELAY seq=" + voiceDataRelay.getSequenceNumber() + " sender=" + voiceDataRelay.getFromPlayerNetworkId());
            return;
        }
        this.processIncomingAudio(voiceDataRelay.getAudioData(), voiceDataRelay.getFromPlayerNetworkId(), voiceDataRelay.getSequenceNumber(), voiceDataRelay.getDistance(), voiceDataRelay.getVolume(), voiceDataRelay.getPlayerX(), voiceDataRelay.getPlayerY(), voiceDataRelay.getPlayerZ());
    }

    private void handleGroupData(GroupDataPacket groupData) {
        if (groupData.getFromPlayerNetworkId() != null && !this.shouldProcessSource(groupData.getFromPlayerNetworkId(), SourceType.GROUP)) {
            this.dbg("Drop GROUP from sender=" + groupData.getFromPlayerNetworkId() + " due to activeSource=" + (Object)((Object)this.activeSourceBySender.get(groupData.getFromPlayerNetworkId())));
            return;
        }
        if (groupData.getAudioData().length == 0) {
            if (groupData.getFromPlayerNetworkId() != null) {
                this.activatedPlayers.remove(groupData.getFromPlayerNetworkId());
                this.clearSourceState(groupData.getFromPlayerNetworkId());
                this.dbg("GROUP end: cleared state for sender=" + groupData.getFromPlayerNetworkId());
            }
            return;
        }
        if (this.isInGroup() && this.currentGroupName.equals(groupData.getGroupName())) {
            if (groupData.getFromPlayerNetworkId() != null && this.isDuplicateOpusPacket(groupData.getFromPlayerNetworkId(), groupData.getAudioData())) {
                this.dbg("CRC dedupe: drop GROUP seq=" + groupData.getSequenceNumber() + " sender=" + groupData.getFromPlayerNetworkId());
                return;
            }
            this.processIncomingAudio(groupData.getAudioData(), groupData.getFromPlayerNetworkId(), groupData.getSequenceNumber(), 0.0, 1.0f, 0.0, 0.0, 0.0);
        }
    }

    private void handleGroupMemberUpdate(GroupMemberUpdatePacket memberUpdate) {
        switch (memberUpdate.getUpdateType()) {
            case GROUP_CREATED: {
                if (memberUpdate.getPlayerNetworkId() == null || !memberUpdate.getPlayerNetworkId().equals(this.playerNetworkId)) break;
                this.currentGroupName = memberUpdate.getGroupName();
                this.groupMembers.clear();
                this.groupMembers.add(this.playerNetworkId);
                break;
            }
            case MEMBER_JOINED: {
                if (memberUpdate.getPlayerNetworkId() != null && memberUpdate.getPlayerNetworkId().equals(this.playerNetworkId)) {
                    this.currentGroupName = memberUpdate.getGroupName();
                    this.groupMembers.clear();
                    for (String memberName : memberUpdate.getGroupMembers()) {
                        Integer memberId = this.getPlayerIdFromName(memberName);
                        if (memberId == null) continue;
                        this.groupMembers.add(memberId);
                    }
                    break;
                }
                if (!this.isInGroup() || !this.currentGroupName.equals(memberUpdate.getGroupName()) || memberUpdate.getPlayerNetworkId() == null) break;
                this.groupMembers.add(memberUpdate.getPlayerNetworkId());
                break;
            }
            case MEMBER_LEFT: {
                if (memberUpdate.getPlayerNetworkId() != null && memberUpdate.getPlayerNetworkId().equals(this.playerNetworkId)) {
                    this.currentGroupName = null;
                    this.groupMembers.clear();
                    break;
                }
                if (!this.isInGroup() || !this.currentGroupName.equals(memberUpdate.getGroupName()) || memberUpdate.getPlayerNetworkId() == null) break;
                this.groupMembers.remove(memberUpdate.getPlayerNetworkId());
                break;
            }
            case GROUP_DELETED: {
                if (!this.isInGroup() || !this.currentGroupName.equals(memberUpdate.getGroupName())) break;
                this.currentGroupName = null;
                this.groupMembers.clear();
            }
        }
        if (this.groupCallback != null) {
            this.groupCallback.accept(memberUpdate);
        }
        if (this.groupMemberCallback != null && this.isInGroup()) {
            ArrayList<String> memberNames = new ArrayList<String>();
            for (Integer memberId : this.groupMembers) {
                String memberName = this.getPlayerNameFromId(memberId);
                if (memberName == null) continue;
                memberNames.add(memberName);
            }
            this.groupMemberCallback.accept(memberNames);
        }
    }

    private void handleGroupList(GroupListPacket groupList) {
        for (GroupListPacket.GroupInfo group : groupList.getGroups()) {
            Voice.LOGGER.info("  - " + group.getName() + " (" + group.getMemberCount() + " members)" + (group.hasPassword() ? " [Private]" : " [Public]"));
        }
        if (this.groupListCallback != null) {
            this.groupListCallback.accept(groupList);
        }
    }

    private void handlePresenceUpdate(PresenceUpdatePacket packet) {
        this.updatePresence(packet.getPlayerNetworkId(), packet.isVoiceSupported(), packet.isDeafened());
    }

    private void handlePresenceBulk(PresenceBulkPacket packet) {
        for (Map.Entry<Integer, PresenceBulkPacket.PlayerState> entry : packet.getPlayerStates().entrySet()) {
            this.updatePresence(entry.getKey(), entry.getValue().voiceSupported, entry.getValue().deafened);
        }
    }

    private void handlePing() {
        this.lastKeepAlive = System.currentTimeMillis();
        try {
            this.sendPacket(new PingPacket(), this.serverHost, this.serverPort);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processIncomingAudio(byte[] audioData, Integer fromPlayerId, long sequenceNumber) {
        this.processIncomingAudio(audioData, fromPlayerId, sequenceNumber, 0.0, 1.0f, 0.0, 0.0, 0.0);
    }

    private void processIncomingAudio(byte[] audioData, Integer fromPlayerId, long sequenceNumber, double distance, float volume, double playerX, double playerY, double playerZ) {
        this.lastAudioReceived = System.currentTimeMillis();
        this.lastKeepAlive = System.currentTimeMillis();
        if (this.userDeafened) {
            return;
        }
        if (fromPlayerId.equals(this.playerNetworkId)) {
            return;
        }
        Long lastSeqForSender = this.lastSeqBySender.get(fromPlayerId);
        if (lastSeqForSender == null) {
            TreeMap buffer = this.reorderBuffers.computeIfAbsent(fromPlayerId, k -> new TreeMap());
            buffer.put(sequenceNumber, new BufferedPacket(audioData, sequenceNumber, distance, volume, playerX, playerY, playerZ));
            int remaining = this.warmupRemainingBySender.getOrDefault(fromPlayerId, 3);
            if (remaining > 1) {
                this.warmupRemainingBySender.put(fromPlayerId, remaining - 1);
                return;
            }
            this.warmupRemainingBySender.remove(fromPlayerId);
            Long first = (Long)buffer.firstKey();
            if (first != null) {
                lastSeqForSender = first - 1L;
                this.lastSeqBySender.put(fromPlayerId, lastSeqForSender);
            }
            buffer.remove(sequenceNumber);
        }
        if (lastSeqForSender != null) {
            long missing;
            if (sequenceNumber <= lastSeqForSender) {
                return;
            }
            long expectedNext = lastSeqForSender + 1L;
            if (sequenceNumber > expectedNext && (missing = sequenceNumber - expectedNext) <= 10L) {
                TreeMap buffer = this.reorderBuffers.computeIfAbsent(fromPlayerId, k -> new TreeMap());
                buffer.put(sequenceNumber, new BufferedPacket(audioData, sequenceNumber, distance, volume, playerX, playerY, playerZ));
                return;
            }
        }
        String playerName = this.getPlayerNameFromId(fromPlayerId);
        AudioProcessor senderDecoder = this.decoderBySender.computeIfAbsent(fromPlayerId, k -> {
            AudioProcessor decoder = new AudioProcessor();
            if (decoder.isInitialized()) {
                return decoder;
            }
            decoder.close();
            return null;
        });
        if (senderDecoder != null && senderDecoder.isInitialized()) {
            byte[] decodedAudio;
            long expectedNext;
            long gap;
            Long lastSeqSeen = this.lastSeqBySender.get(fromPlayerId);
            if (lastSeqSeen != null && sequenceNumber > lastSeqSeen + 1L && (gap = sequenceNumber - (expectedNext = lastSeqSeen + 1L)) > 0L) {
                if (gap <= 4L) {
                    Set enqueuedSeqsPlc = this.enqueuedSeqBySender.computeIfAbsent(fromPlayerId, k -> ConcurrentHashMap.newKeySet());
                    for (long missingSeq = expectedNext; missingSeq < sequenceNumber; ++missingSeq) {
                        byte[] plc;
                        if (enqueuedSeqsPlc.contains(missingSeq) || (plc = senderDecoder.decodeSilence()) == null || plc.length <= 0) continue;
                        AdaptiveJitterBuffer.BufferedPacket plcPacket = new AdaptiveJitterBuffer.BufferedPacket(plc, missingSeq, distance, 1.0f, playerX, playerY, playerZ, System.currentTimeMillis(), 0L);
                        BlockingQueue<AdaptiveJitterBuffer.BufferedPacket> queue = this.senderQueues.get(fromPlayerId);
                        if (queue == null) continue;
                        queue.offer(plcPacket);
                        enqueuedSeqsPlc.add(missingSeq);
                    }
                } else {
                    for (long missingSeq = expectedNext; missingSeq < sequenceNumber; ++missingSeq) {
                        senderDecoder.decodeSilence();
                    }
                }
            }
            if ((decodedAudio = senderDecoder.decodeAudio(audioData)) != null && decodedAudio.length > 0) {
                this.lastTalkingByRemote.put(fromPlayerId, System.currentTimeMillis());
                float playerVolume = playerName != null ? this.getPlayerVolume(playerName) : 1.0f;
                float finalVolume = volume * this.masterVolume * playerVolume;
                Set enqueuedSeqs = this.enqueuedSeqBySender.computeIfAbsent(fromPlayerId, k -> ConcurrentHashMap.newKeySet());
                if (enqueuedSeqs.contains(sequenceNumber)) {
                    return;
                }
                AdaptiveJitterBuffer.BufferedPacket packet = new AdaptiveJitterBuffer.BufferedPacket(decodedAudio, sequenceNumber, distance, finalVolume, playerX, playerY, playerZ, System.currentTimeMillis(), 0L);
                this.ensureSenderThread(fromPlayerId);
                BlockingQueue<AdaptiveJitterBuffer.BufferedPacket> queue = this.senderQueues.get(fromPlayerId);
                if (queue != null) {
                    queue.offer(packet);
                    enqueuedSeqs.add(sequenceNumber);
                    if (enqueuedSeqs.size() > 128) {
                        enqueuedSeqs.clear();
                        enqueuedSeqs.add(sequenceNumber);
                    }
                }
                this.lastSeqBySender.put(fromPlayerId, sequenceNumber);
                TreeMap<Long, BufferedPacket> buffer = this.reorderBuffers.get(fromPlayerId);
                if (buffer != null) {
                    while (true) {
                        BufferedPacket next;
                        Long nextKey = buffer.higherKey(this.lastSeqBySender.get(fromPlayerId) - 1L);
                        long expectedNext2 = this.lastSeqBySender.get(fromPlayerId) + 1L;
                        if (nextKey == null || nextKey != expectedNext2 || (next = buffer.remove(nextKey)) == null) break;
                        byte[] nextDecoded = senderDecoder.decodeAudio(next.audioData);
                        if (nextDecoded == null || nextDecoded.length <= 0) continue;
                        Set enqueuedSeqs2 = this.enqueuedSeqBySender.computeIfAbsent(fromPlayerId, k -> ConcurrentHashMap.newKeySet());
                        if (!enqueuedSeqs2.contains(next.sequenceNumber)) {
                            AdaptiveJitterBuffer.BufferedPacket bufferedPacket = new AdaptiveJitterBuffer.BufferedPacket(nextDecoded, next.sequenceNumber, next.distance, next.volume, next.playerX, next.playerY, next.playerZ, System.currentTimeMillis(), 0L);
                            this.ensureSenderThread(fromPlayerId);
                            BlockingQueue<AdaptiveJitterBuffer.BufferedPacket> queue2 = this.senderQueues.get(fromPlayerId);
                            if (queue2 != null) {
                                queue2.offer(bufferedPacket);
                                enqueuedSeqs2.add(next.sequenceNumber);
                            }
                            this.dbg("Offered buffered next sender=" + fromPlayerId + " seq=" + next.sequenceNumber);
                        }
                        this.lastSeqBySender.put(fromPlayerId, next.sequenceNumber);
                    }
                    if (buffer.isEmpty()) {
                        this.reorderBuffers.remove(fromPlayerId);
                    }
                }
            }
        } else {
            Voice.LOGGER.warn("Audio processor not available for decoding audio from player " + fromPlayerId);
        }
    }

    public boolean isPlayerTalking(C_9590849 player) {
        if (player == null) {
            return false;
        }
        Integer id = player.f_5338989;
        if (id == null) {
            return false;
        }
        Long last = this.lastTalkingByRemote.get(id);
        if (last == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        long delta = now - last;
        if (delta < 500L) {
            return true;
        }
        this.lastTalkingByRemote.remove(id);
        this.activatedPlayers.remove(id);
        return false;
    }

    public void updatePresence(int playerNetworkId, boolean supported, boolean deafened) {
        if (supported) {
            this.presenceSupported.add(playerNetworkId);
        } else {
            this.presenceSupported.remove(playerNetworkId);
        }
        if (deafened) {
            this.presenceDeafened.add(playerNetworkId);
        } else {
            this.presenceDeafened.remove(playerNetworkId);
        }
    }

    public boolean isPlayerVoiceSupported(C_9590849 player) {
        if (player == null) {
            return false;
        }
        Integer id = player.f_5338989;
        if (id == null) {
            return false;
        }
        return this.presenceSupported.contains(id);
    }

    public boolean isPlayerDeafened(C_9590849 player) {
        if (player == null) {
            return false;
        }
        Integer id = player.f_5338989;
        if (id == null) {
            return false;
        }
        return this.presenceDeafened.contains(id);
    }

    private void queueToOutput(Integer senderId, byte[] monoDecoded, double playerX, double playerY, double playerZ, float finalVolume) {
        if (monoDecoded == null || monoDecoded.length == 0) {
            Voice.LOGGER.warn("Attempted to queue null or empty audio");
            return;
        }
        if (monoDecoded.length % 2 != 0) {
            Voice.LOGGER.warn("Invalid mono audio size: " + monoDecoded.length + " bytes (must be even)");
            return;
        }
        PlaybackState state = this.playbackStateMap.get(senderId);
        if (state == PlaybackState.OPENAL) {
            byte[] stereoAudio;
            OpenALAudioPlayback senderPlayback = this.openALPlaybackBySender.get(senderId);
            if (senderPlayback != null && senderPlayback.isInitialized() && (stereoAudio = this.calculateStereoPositioning(monoDecoded, playerX, playerY, playerZ, finalVolume)) != null && stereoAudio.length > 0) {
                this.dbg("Write to OpenAL sender=" + senderId + " len=" + stereoAudio.length);
                senderPlayback.writeAudioDirect(stereoAudio);
            }
        } else if (state == PlaybackState.STEREO_FALLBACK) {
            byte[] positionedAudio;
            StereoAudioPlayback fallbackPlayback = this.stereoPlaybackBySender.get(senderId);
            if (fallbackPlayback != null && fallbackPlayback.isInitialized()) {
                byte[] positionedAudio2 = this.calculateStereoPositioning(monoDecoded, playerX, playerY, playerZ, finalVolume);
                if (positionedAudio2 != null && positionedAudio2.length > 0) {
                    this.dbg("Enqueue to fallback StereoAudioPlayback sender=" + senderId + " len=" + positionedAudio2.length);
                    fallbackPlayback.queueAudio(positionedAudio2);
                }
            } else if (this.stereoAudioPlayback != null && this.stereoAudioPlayback.isInitialized() && (positionedAudio = this.calculateStereoPositioning(monoDecoded, playerX, playerY, playerZ, finalVolume)) != null && positionedAudio.length > 0) {
                this.dbg("Enqueue to global StereoAudioPlayback len=" + positionedAudio.length);
                this.stereoAudioPlayback.queueAudio(positionedAudio);
            }
        }
    }

    private void ensureSenderThread(Integer senderId) {
        if (this.senderThreads.containsKey(senderId)) {
            return;
        }
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.senderQueues.put(senderId, queue);
        this.senderThreadRunning.put(senderId, true);
        Thread thread = new Thread(() -> {
            boolean useSpecificDevice;
            Voice.LOGGER.info("[VoiceClient] Started playback thread for sender=" + senderId);
            boolean bl = useSpecificDevice = this.outputDeviceName != null && !this.outputDeviceName.equals("Default");
            if (!useSpecificDevice) {
                OpenALAudioPlayback playback = new OpenALAudioPlayback();
                if (playback.initialize()) {
                    this.openALPlaybackBySender.put(senderId, playback);
                    this.playbackStateMap.put(senderId, PlaybackState.OPENAL);
                    Voice.LOGGER.info("[VoiceClient] OpenAL source created for sender=" + senderId);
                } else {
                    playback.close();
                    Voice.LOGGER.warn("[VoiceClient] OpenAL initialization failed for sender=" + senderId + ", falling back to StereoAudioPlayback");
                    StereoAudioPlayback stereoPlayback = new StereoAudioPlayback(this.outputDeviceName);
                    if (!stereoPlayback.initialize()) {
                        stereoPlayback.close();
                        this.playbackStateMap.put(senderId, PlaybackState.FAILED);
                        Voice.LOGGER.error("[VoiceClient] Both OpenAL and StereoAudioPlayback failed for sender=" + senderId);
                        return;
                    }
                    this.stereoPlaybackBySender.put(senderId, stereoPlayback);
                    this.playbackStateMap.put(senderId, PlaybackState.STEREO_FALLBACK);
                    Voice.LOGGER.info("[VoiceClient] StereoAudioPlayback fallback initialized for sender=" + senderId);
                }
            } else {
                this.playbackStateMap.put(senderId, PlaybackState.STEREO_FALLBACK);
                Voice.LOGGER.info("[VoiceClient] Using global StereoAudioPlayback for sender=" + senderId);
            }
            try {
                while (this.senderThreadRunning.getOrDefault(senderId, false) != false) {
                    if (!this.connected) return;
                    AdaptiveJitterBuffer.BufferedPacket pkt = (AdaptiveJitterBuffer.BufferedPacket)queue.poll(10L, TimeUnit.MILLISECONDS);
                    if (pkt == null) continue;
                    this.queueToOutput(senderId, pkt.audioData, pkt.playerX, pkt.playerY, pkt.playerZ, pkt.volume);
                }
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                Voice.LOGGER.warn("[VoiceClient] Error in sender thread " + senderId + ": " + e.getMessage());
                return;
            }
            finally {
                Voice.LOGGER.info("[VoiceClient] Stopped playback thread for sender=" + senderId);
            }
        }, "Voice-Sender-" + senderId);
        thread.setDaemon(true);
        thread.start();
        this.senderThreads.put(senderId, thread);
    }

    private void sendPacket(UdpPacket packet, String host, int port) throws IOException {
        byte[] data = packet.toBytes();
        InetAddress address = InetAddress.getByName(host);
        DatagramPacket udpPacket = new DatagramPacket(data, data.length, address, port);
        this.socket.send(udpPacket);
    }

    public void setHandshakeCallback(Consumer<VoiceHandshakeAckPacket> callback) {
        this.handshakeCallback = callback;
    }

    public void setGroupCallback(Consumer<GroupMemberUpdatePacket> callback) {
        this.groupCallback = callback;
    }

    public void setGroupListCallback(Consumer<GroupListPacket> callback) {
        this.groupListCallback = callback;
    }

    public void setGroupMemberCallback(Consumer<List<String>> callback) {
        this.groupMemberCallback = callback;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Integer getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public boolean isMicEnabled() {
        return this.micEnabled;
    }

    private void startMicrophoneCapture() {
        if (this.microphoneCapture != null) {
            return;
        }
        this.microphoneCapture = new MicrophoneCapture(this::onAudioData, this.inputDeviceName);
        if (!this.microphoneCapture.startCapture()) {
            Voice.LOGGER.warn("Failed to start microphone capture");
            this.microphoneCapture = null;
        } else {
            Voice.LOGGER.info("Microphone capture started");
        }
    }

    private void stopMicrophoneCapture() {
        if (this.microphoneCapture != null) {
            this.microphoneCapture.stopCapture();
            this.microphoneCapture.close();
            this.microphoneCapture = null;
            Voice.LOGGER.info("Microphone capture stopped");
        }
        if (this.audioProcessor != null) {
            this.audioProcessor.resetEncoder();
        }
    }

    public void toggleMute() {
        if (this.userDeafened && this.micMuted) {
            this.toggleDeafened();
            return;
        }
        this.micMuted = !this.micMuted;
    }

    public boolean isMicMuted() {
        return this.micMuted;
    }

    public void toggleDeafened() {
        this.micMuted = this.userDeafened = !this.userDeafened;
        this.sendPresenceUpdate();
    }

    public boolean isDeafened() {
        return this.userDeafened;
    }

    private void sendPresenceUpdate() {
        if (!this.connected || this.playerNetworkId == null || this.serverHost == null) {
            return;
        }
        try {
            PresenceUpdatePacket packet = new PresenceUpdatePacket(this.playerNetworkId, true, this.userDeafened);
            this.sendPacket(packet, this.serverHost, this.serverPort);
        }
        catch (Exception e) {
            Voice.LOGGER.warn("Failed to send presence update: " + e.getMessage());
        }
    }

    public boolean isPushToTalk() {
        return this.pushToTalk;
    }

    public void setPushToTalk(boolean pushToTalk) {
        this.pushToTalk = pushToTalk;
        this.pttKeyPressed = false;
        if (this.config != null) {
            this.config.setPushToTalk(pushToTalk);
            this.config.save();
        }
    }

    public void setPttKeyPressed(boolean pressed) {
        this.pttKeyPressed = pressed;
    }

    public boolean isPttKeyPressed() {
        return this.pttKeyPressed;
    }

    public double getSilenceThreshold() {
        return this.silenceThreshold;
    }

    public void setSilenceThreshold(double silenceThreshold) {
        if (silenceThreshold < -127.0) {
            silenceThreshold = -127.0;
        }
        if (silenceThreshold > 0.0) {
            silenceThreshold = 0.0;
        }
        this.silenceThreshold = silenceThreshold;
        if (this.config != null) {
            this.config.setActivationThreshold(silenceThreshold);
            this.config.save();
        }
    }

    public float getMicrophoneGain() {
        return this.microphoneGain;
    }

    public void setMicrophoneGain(float microphoneGain) {
        if (microphoneGain < 0.0f) {
            microphoneGain = 0.0f;
        }
        if (microphoneGain > 2.0f) {
            microphoneGain = 2.0f;
        }
        this.microphoneGain = microphoneGain;
        if (this.audioProcessor != null) {
            this.audioProcessor.setMicrophoneGain(microphoneGain);
        }
        if (this.config != null) {
            this.config.setMicrophoneGain(microphoneGain);
            this.config.save();
        }
    }

    public float getMasterVolume() {
        return this.masterVolume;
    }

    public void setMasterVolume(float masterVolume) {
        if (masterVolume < 0.0f) {
            masterVolume = 0.0f;
        }
        if (masterVolume > 2.0f) {
            masterVolume = 2.0f;
        }
        this.masterVolume = masterVolume;
        if (this.config != null) {
            this.config.setMasterVolume(masterVolume);
            this.config.save();
        }
    }

    public float getPlayerVolume(String playerName) {
        return this.playerVolumes.getOrDefault(playerName, Float.valueOf(1.0f)).floatValue();
    }

    public void setPlayerVolume(String playerName, float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 2.0f) {
            volume = 2.0f;
        }
        if (volume == 1.0f) {
            this.playerVolumes.remove(playerName);
        } else {
            this.playerVolumes.put(playerName, Float.valueOf(volume));
        }
        if (this.config != null) {
            this.config.setPlayerVolume(playerName, volume);
            this.config.save();
        }
    }

    public String getCurrentGroupName() {
        return this.currentGroupName;
    }

    public boolean isInGroup() {
        return this.currentGroupName != null && !this.currentGroupName.isEmpty();
    }

    public Set<Integer> getGroupMembers() {
        return new HashSet<Integer>(this.groupMembers);
    }

    public void createGroup(String groupName, String password) {
        if (!this.connected) {
            Voice.LOGGER.warn("Cannot create group: not connected to voice server");
            return;
        }
        try {
            GroupCreatePacket packet = new GroupCreatePacket(groupName, password);
            this.sendPacket(packet, this.serverHost, this.serverPort);
            Voice.LOGGER.info("Sent group creation request for: " + groupName);
        }
        catch (IOException e) {
            Voice.LOGGER.warn("Failed to send group creation packet: " + e.getMessage());
        }
    }

    public void joinGroup(String groupName, String password) {
        if (!this.connected) {
            Voice.LOGGER.warn("Cannot join group: not connected to voice server");
            return;
        }
        try {
            GroupJoinPacket packet = new GroupJoinPacket(groupName, password);
            this.sendPacket(packet, this.serverHost, this.serverPort);
            Voice.LOGGER.info("Sent group join request for: " + groupName);
        }
        catch (IOException e) {
            Voice.LOGGER.warn("Failed to send group join packet: " + e.getMessage());
        }
    }

    public void leaveGroup() {
        if (!this.connected) {
            Voice.LOGGER.warn("Cannot leave group: not connected to voice server");
            return;
        }
        if (!this.isInGroup()) {
            Voice.LOGGER.warn("Cannot leave group: not currently in a group");
            return;
        }
        try {
            GroupLeavePacket packet = new GroupLeavePacket(this.currentGroupName);
            this.sendPacket(packet, this.serverHost, this.serverPort);
            Voice.LOGGER.info("Sent group leave request for: " + this.currentGroupName);
        }
        catch (IOException e) {
            Voice.LOGGER.warn("Failed to send group leave packet: " + e.getMessage());
        }
    }

    public void requestGroupList() {
        if (!this.connected) {
            Voice.LOGGER.warn("Cannot request group list: not connected to voice server");
            return;
        }
        try {
            GroupListPacket packet = new GroupListPacket();
            this.sendPacket(packet, this.serverHost, this.serverPort);
        }
        catch (IOException e) {
            Voice.LOGGER.warn("Failed to send group list request: " + e.getMessage());
        }
    }

    public String getInputDeviceName() {
        return this.inputDeviceName;
    }

    public void setInputDeviceName(String deviceName) {
        boolean wasTestingMic;
        this.inputDeviceName = deviceName;
        if (this.config != null) {
            this.config.setInputDevice(deviceName);
            this.config.save();
        }
        if (wasTestingMic = this.isMicrophoneTesting) {
            this.stopMicrophoneTesting();
        }
        if (this.connected) {
            this.stopMicrophoneCapture();
            this.microphoneCapture = new MicrophoneCapture(this::onAudioData, this.inputDeviceName);
            if (!this.microphoneCapture.startCapture()) {
                Voice.LOGGER.warn("Failed to start microphone capture for device: " + this.inputDeviceName);
                this.microphoneCapture = null;
            }
        }
        if (wasTestingMic) {
            this.startMicrophoneTesting();
        }
    }

    public String getOutputDeviceName() {
        return this.outputDeviceName;
    }

    public void setOutputDeviceName(String deviceName) {
        boolean shouldUseStereo;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastDeviceChangeTime < 100L) {
            return;
        }
        this.lastDeviceChangeTime = currentTime;
        this.outputDeviceName = deviceName;
        if (this.config != null) {
            this.config.setOutputDevice(deviceName);
            this.config.save();
        }
        boolean bl = shouldUseStereo = deviceName != null && !deviceName.equals("Default");
        if (shouldUseStereo && !this.openALPlaybackBySender.isEmpty()) {
            Voice.LOGGER.info("Switching to StereoAudioPlayback for device selection support");
            for (OpenALAudioPlayback playback : this.openALPlaybackBySender.values()) {
                if (playback == null) continue;
                playback.close();
            }
            this.openALPlaybackBySender.clear();
        } else if (!shouldUseStereo) {
            Voice.LOGGER.info("Switched back to OpenAL (per-sender sources will be created on demand)");
        }
        if (this.stereoAudioPlayback != null) {
            try {
                this.stereoAudioPlayback.close();
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Error closing previous audio playback: " + e.getMessage());
            }
        }
        try {
            this.stereoAudioPlayback = new StereoAudioPlayback(this.outputDeviceName);
            if (!this.stereoAudioPlayback.initialize()) {
                Voice.LOGGER.warn("Warning: Stereo audio playback not initialized with new device. Voice output may not work.");
                this.stereoAudioPlayback = null;
            }
        }
        catch (Exception e) {
            Voice.LOGGER.warn("Error initializing audio playback with new device: " + e.getMessage());
            this.stereoAudioPlayback = null;
        }
    }

    public boolean isTalking() {
        boolean currentlyTalking;
        long timeSinceLastTalking = System.currentTimeMillis() - this.lastTalkingTime;
        boolean bl = currentlyTalking = this.isTalking && timeSinceLastTalking < 500L;
        if (!currentlyTalking && this.isTalking) {
            this.isTalking = false;
        }
        return currentlyTalking;
    }

    private boolean isAudioSilent(byte[] audioData) {
        if (audioData == null || audioData.length == 0) {
            return true;
        }
        int offset = AudioUtils.getActivationOffset(audioData, this.silenceThreshold);
        return offset < 0;
    }

    private void checkForStaleAudio() {
        long timeSinceLastAudio = System.currentTimeMillis() - this.lastAudioReceived;
        if (timeSinceLastAudio > 10000L && this.stereoAudioPlayback != null) {
            this.stereoAudioPlayback.flushAudioBuffer();
        }
    }

    private void checkKeepAlive() {
        long timeSinceLastActivity;
        if (!this.handshakeComplete) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSentKeepAlive > 10000L) {
            try {
                this.sendPacket(new PingPacket(), this.serverHost, this.serverPort);
                this.lastSentKeepAlive = now;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((timeSinceLastActivity = now - this.lastKeepAlive) > 120000L) {
            Voice.LOGGER.warn("Voice server connection timed out (no activity for " + timeSinceLastActivity / 1000L + " seconds)");
            this.disconnect();
        }
    }

    private void onAudioData(byte[] audioData) {
        if (!this.connected || audioData == null || audioData.length == 0 || this.micMuted) {
            return;
        }
        boolean isSilence = this.pushToTalk ? !this.pttKeyPressed || audioData.length == 0 : this.isAudioSilent(audioData);
        if (isSilence) {
            return;
        }
        if (this.audioProcessor != null && this.audioProcessor.isInitialized()) {
            this.processAudioFrame(audioData);
        }
    }

    private void processAudioFrame(byte[] audioData) {
        block10: {
            try {
                block11: {
                    long currentSeq;
                    byte[] encodedAudio = null;
                    if (this.audioProcessor != null && this.audioProcessor.isInitialized()) {
                        encodedAudio = this.audioProcessor.encodeAudio(audioData);
                    }
                    if (encodedAudio == null || encodedAudio.length <= 0) break block10;
                    if (encodedAudio.length > 1024) {
                        Voice.LOGGER.warn("Encoded audio too large: " + encodedAudio.length + " bytes, skipping packet");
                        return;
                    }
                    if (this.sentSequenceNumbers.contains(currentSeq = this.sequenceNumber++)) {
                        return;
                    }
                    this.sentSequenceNumbers.add(currentSeq);
                    if (this.sentSequenceNumbers.size() > 1000) {
                        this.sentSequenceNumbers.clear();
                    }
                    try {
                        if (this.isInGroup()) {
                            GroupDataPacket groupPacket = new GroupDataPacket(this.currentGroupName, this.playerNetworkId, encodedAudio, currentSeq, new ArrayList<Integer>(this.groupMembers));
                            this.sendPacket(groupPacket, this.serverHost, this.serverPort);
                        } else {
                            VoiceDataPacket voicePacket = new VoiceDataPacket(this.playerNetworkId, encodedAudio, currentSeq);
                            this.sendPacket(voicePacket, this.serverHost, this.serverPort);
                        }
                    }
                    catch (IOException e) {
                        String errorMsg;
                        if (!this.connected || (errorMsg = e.getMessage()) == null || errorMsg.contains("Connection reset") || errorMsg.contains("Connection refused") || errorMsg.contains("Network is unreachable")) break block11;
                        Voice.LOGGER.warn("Failed to send voice data: " + errorMsg);
                    }
                }
                this.isTalking = true;
                this.lastTalkingTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                String errorMsg;
                if (!this.connected || (errorMsg = e.getMessage()) == null || errorMsg.contains("Connection reset") || errorMsg.contains("Connection refused") || errorMsg.contains("Network is unreachable")) break block10;
                Voice.LOGGER.warn("Failed to send voice data: " + errorMsg);
            }
        }
    }

    private byte[] applyMicrophoneGain(byte[] audioData, float gain) {
        if (gain == 1.0f) {
            return audioData;
        }
        if (this.audioGainBuffer.length < audioData.length) {
            byte[] out = new byte[audioData.length];
            this.applyGainToBuffer(audioData, out, gain);
            return out;
        }
        this.applyGainToBuffer(audioData, this.audioGainBuffer, gain);
        byte[] result = new byte[audioData.length];
        System.arraycopy(this.audioGainBuffer, 0, result, 0, audioData.length);
        return result;
    }

    private void applyGainToBuffer(byte[] input, byte[] output, float gain) {
        int i = 0;
        while (i + 1 < input.length) {
            int scaled;
            int sample = input[i] & 0xFF | (input[i + 1] & 0xFF) << 8;
            if (sample > Short.MAX_VALUE) {
                sample -= 65536;
            }
            if ((scaled = Math.round((float)sample * gain)) > Short.MAX_VALUE) {
                scaled = Short.MAX_VALUE;
            }
            if (scaled < Short.MIN_VALUE) {
                scaled = Short.MIN_VALUE;
            }
            int le = scaled;
            output[i] = (byte)(le & 0xFF);
            output[i + 1] = (byte)(le >>> 8 & 0xFF);
            i += 2;
        }
        if ((input.length & 1) == 1) {
            output[input.length - 1] = input[input.length - 1];
        }
    }

    private byte[] calculateStereoPositioning(byte[] audioData, double playerX, double playerY, double playerZ, float volume) {
        if (audioData == null || audioData.length == 0) {
            return null;
        }
        if (this.isInGroup()) {
            return this.duplicateMonoToStereo(audioData, volume);
        }
        double relX = playerX - this.simple3D.listenerX;
        double relZ = playerZ - this.simple3D.listenerZ;
        double distance = Math.sqrt(relX * relX + relZ * relZ);
        if (distance < 1.0E-6) {
            return this.duplicateMonoToStereo(audioData, volume);
        }
        double unitX = relX / distance;
        double unitZ = relZ / distance;
        double yawRad = Math.toRadians(this.simple3D.listenerYaw);
        double rx = Math.cos(yawRad);
        double rz = Math.sin(yawRad);
        float pan = (float)(-(unitX * rx + unitZ * rz));
        if (volume < 1.0f) {
            float distanceAttenuation = (float)Math.max(0.1, Math.min(1.0, 10.0 / Math.max(1.0, distance)));
            volume *= distanceAttenuation;
        }
        pan = Math.max(-1.0f, Math.min(1.0f, pan));
        return this.applyStereoPanning(audioData, pan, volume);
    }

    private byte[] applyStereoPanning(byte[] audioData, float pan, float volume) {
        if (Math.abs(pan) < 0.01f) {
            return this.duplicateMonoToStereo(audioData, volume);
        }
        byte[] stereoAudio = new byte[audioData.length * 2];
        float leftGain = (float)Math.sqrt(0.5 * (1.0 - (double)pan));
        float rightGain = (float)Math.sqrt(0.5 * (1.0 + (double)pan));
        volume = Math.min(volume, 1.0f);
        for (int i = 0; i < audioData.length; i += 2) {
            if (i + 1 >= audioData.length) continue;
            short sample = (short)(audioData[i + 1] << 8 | audioData[i] & 0xFF);
            int scaledSample = (int)((float)sample * volume);
            scaledSample = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, scaledSample));
            short volumeSample = (short)scaledSample;
            int leftScaled = (int)((float)volumeSample * leftGain);
            int rightScaled = (int)((float)volumeSample * rightGain);
            leftScaled = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, leftScaled));
            rightScaled = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, rightScaled));
            short leftSample = (short)leftScaled;
            short rightSample = (short)rightScaled;
            int stereoIndex = i / 2 * 4;
            stereoAudio[stereoIndex] = (byte)(leftSample & 0xFF);
            stereoAudio[stereoIndex + 1] = (byte)(leftSample >> 8 & 0xFF);
            stereoAudio[stereoIndex + 2] = (byte)(rightSample & 0xFF);
            stereoAudio[stereoIndex + 3] = (byte)(rightSample >> 8 & 0xFF);
        }
        return stereoAudio;
    }

    private byte[] duplicateMonoToStereo(byte[] monoAudio, float volume) {
        byte[] stereoAudio = new byte[monoAudio.length * 2];
        volume = Math.min(volume, 1.0f);
        for (int i = 0; i < monoAudio.length; i += 2) {
            if (i + 1 >= monoAudio.length) continue;
            short sample = (short)(monoAudio[i + 1] << 8 | monoAudio[i] & 0xFF);
            int scaledSample = (int)((float)sample * volume);
            scaledSample = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, scaledSample));
            short finalSample = (short)scaledSample;
            int stereoIndex = i / 2 * 4;
            stereoAudio[stereoIndex] = (byte)(finalSample & 0xFF);
            stereoAudio[stereoIndex + 1] = (byte)(finalSample >> 8 & 0xFF);
            stereoAudio[stereoIndex + 2] = (byte)(finalSample & 0xFF);
            stereoAudio[stereoIndex + 3] = (byte)(finalSample >> 8 & 0xFF);
        }
        return stereoAudio;
    }

    public void updateListenerPosition(double x, double y, double z, float yaw, float pitch) {
        if (this.simple3D != null && this.simple3D.isInitialized()) {
            this.simple3D.updateListener(x, y, z, yaw, pitch);
        }
    }

    public boolean startMicrophoneTesting() {
        boolean wasCapturing;
        if (this.isMicrophoneTesting) {
            return true;
        }
        if (this.testMicrophoneCapture != null) {
            this.stopMicrophoneTesting();
        }
        boolean bl = wasCapturing = this.microphoneCapture != null;
        if (wasCapturing) {
            this.stopMicrophoneCapture();
        }
        this.testMicrophoneCapture = new MicrophoneCapture(this::onTestMicrophoneData, this.inputDeviceName);
        if (!this.testMicrophoneCapture.startCapture()) {
            Voice.LOGGER.warn("Failed to start microphone testing");
            this.testMicrophoneCapture = null;
            if (wasCapturing && this.connected) {
                this.startMicrophoneCapture();
            }
            return false;
        }
        this.isMicrophoneTesting = true;
        Voice.LOGGER.info("Microphone testing started");
        return true;
    }

    public void stopMicrophoneTesting() {
        if (!this.isMicrophoneTesting) {
            return;
        }
        this.isMicrophoneTesting = false;
        if (this.testMicrophoneCapture != null) {
            this.testMicrophoneCapture.stopCapture();
            this.testMicrophoneCapture.close();
            this.testMicrophoneCapture = null;
        }
        if (this.connected && this.microphoneCapture == null) {
            this.startMicrophoneCapture();
        }
        Voice.LOGGER.info("Microphone testing stopped");
    }

    public boolean isMicrophoneTesting() {
        return this.isMicrophoneTesting;
    }

    private void onTestMicrophoneData(byte[] audioData) {
        if (!this.isMicrophoneTesting || audioData == null || audioData.length == 0) {
            return;
        }
        try {
            byte[] gainedAudio = this.applyMicrophoneGain(audioData, this.microphoneGain);
            byte[] stereoAudio = this.duplicateMonoToStereo(gainedAudio, 1.0f);
            if (this.stereoAudioPlayback != null && this.stereoAudioPlayback.isInitialized()) {
                if (!this.stereoAudioPlayback.isRunning() && !this.stereoAudioPlayback.startPlayback()) {
                    Voice.LOGGER.warn("Failed to start stereo audio playback for mic testing");
                    return;
                }
                this.stereoAudioPlayback.queueAudio(stereoAudio);
            }
        }
        catch (Exception e) {
            Voice.LOGGER.warn("Error during microphone testing: " + e.getMessage());
        }
    }

    public String getPlayerNameFromId(Integer playerId) {
        try {
            Minecraft mc = MinecraftAccessor.getMinecraft();
            if (mc != null && mc.f_4601986 != null) {
                for (Object obj : mc.f_4601986.f_5515055) {
                    if (!(obj instanceof C_9590849)) continue;
                    C_9590849 player = (C_9590849)obj;
                    if (player.f_5338989 != playerId) continue;
                    return player.f_4437619;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Integer getPlayerIdFromName(String playerName) {
        try {
            Minecraft mc = MinecraftAccessor.getMinecraft();
            if (mc != null && mc.f_4601986 != null) {
                for (Object obj : mc.f_4601986.f_5515055) {
                    if (!(obj instanceof C_9590849)) continue;
                    C_9590849 player = (C_9590849)obj;
                    if (player.f_4437619 == null || !player.f_4437619.equals(playerName)) continue;
                    return player.f_5338989;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static enum SourceType {
        DIRECT,
        RELAY,
        GROUP;

    }

    private static class BufferedPacket {
        final byte[] audioData;
        final long sequenceNumber;
        final double distance;
        final float volume;
        final double playerX;
        final double playerY;
        final double playerZ;

        BufferedPacket(byte[] audioData, long sequenceNumber, double distance, float volume, double playerX, double playerY, double playerZ) {
            this.audioData = audioData;
            this.sequenceNumber = sequenceNumber;
            this.distance = distance;
            this.volume = volume;
            this.playerX = playerX;
            this.playerY = playerY;
            this.playerZ = playerZ;
        }
    }

    private static enum PlaybackState {
        OPENAL,
        STEREO_FALLBACK,
        FAILED;

    }
}

