/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class VoiceServerConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @SerializedName(value="port")
    private int port = 25566;
    @SerializedName(value="server_host")
    private String serverHost = "0.0.0.0";
    @SerializedName(value="audio")
    private AudioConfig audio = new AudioConfig();

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public AudioConfig getAudio() {
        return this.audio;
    }

    public void setAudio(AudioConfig audio) {
        this.audio = audio;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VoiceServerConfig load() {
        Path configPath = Paths.get("config", "voice-server.json");
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create config directory: " + e.getMessage());
        }
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                VoiceServerConfig config = (VoiceServerConfig)GSON.fromJson((Reader)reader, VoiceServerConfig.class);
                if (config != null) {
                    VoiceServerConfig voiceServerConfig = config;
                    return voiceServerConfig;
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load config file: " + e.getMessage());
            }
        }
        VoiceServerConfig defaultConfig = new VoiceServerConfig();
        defaultConfig.save();
        return defaultConfig;
    }

    public void save() {
        Path configPath = Paths.get("config", "voice-server.json");
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save config file: " + e.getMessage());
        }
    }

    public static class AudioConfig {
        @SerializedName(value="max_distance")
        private double maxDistance = 48.0;

        public double getMaxDistance() {
            return this.maxDistance;
        }

        public void setMaxDistance(double maxDistance) {
            this.maxDistance = maxDistance;
        }
    }
}

