/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.client.init.Voice;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.CreateGroupScreen;
import com.moyettes.voice.gui.GroupMembersScreen;
import com.moyettes.voice.gui.JoinGroupScreen;
import com.moyettes.voice.udp.GroupListPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import org.lwjgl.input.Mouse;

public class GroupsScreen
extends BaseVoiceScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int NAME_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 20;
    private final List<GroupEntry> entries = new ArrayList<GroupEntry>();
    private int scrollOffset = 0;
    private List<GroupListPacket.GroupInfo> availableGroups = new ArrayList<GroupListPacket.GroupInfo>();
    private static GroupsScreen currentInstance = null;

    @Override
    protected void initContent() {
        currentInstance = this;
        Voice.requestGroupList();
        this.buildGroupEntries();
    }

    @Override
    protected void renderContent(int mouseX, int mouseY, float tickDelta) {
        int wheel = Mouse.getDWheel();
        if (wheel != 0) {
            int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
            int contentTop = backgroundY + 24;
            int contentBottom = backgroundY + this.backgroundHeight - 36;
            int contentHeight = contentBottom - contentTop;
            int maxScroll = Math.max(0, this.entries.size() * 24 - contentHeight);
            this.scrollOffset -= (int)Math.signum(wheel) * 16;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > maxScroll) {
                this.scrollOffset = maxScroll;
            }
        }
        this.layoutAndRenderEntries(mouseX, mouseY, tickDelta);
    }

    @Override
    protected String getBackgroundTexture() {
        return "/assets/legacyvoicechat/textures/gui/group.png";
    }

    @Override
    protected String getTitle() {
        return "Join or Create Group";
    }

    @Override
    protected void handleCustomButtonClick(C_2348249 button) {
        if (button.f_5920996 >= 5000 && button.f_5920996 < 5000 + this.entries.size()) {
            int groupIndex = button.f_5920996 - 5000;
            if (groupIndex >= 0 && groupIndex < this.entries.size()) {
                GroupEntry entry = this.entries.get(groupIndex);
                if (entry.group.hasPassword()) {
                    System.out.println("Opening password dialog for private group: " + entry.group.getName());
                    this.f_7153641.m_6408915((C_3020744)new JoinGroupScreen(entry.group.getName()));
                } else {
                    Voice.joinGroup(entry.group.getName(), null);
                    System.out.println("Joining public group: " + entry.group.getName());
                    this.f_7153641.m_6408915((C_3020744)new GroupMembersScreen());
                }
            }
        } else if (button.f_5920996 == 1105) {
            this.f_7153641.m_6408915((C_3020744)new CreateGroupScreen());
        }
    }

    private void buildGroupEntries() {
        this.entries.clear();
        ArrayList toKeep = new ArrayList();
        for (Object o : this.f_2213969) {
            if (!(o instanceof C_2348249)) continue;
            C_2348249 b = (C_2348249)o;
            if (b.f_5920996 != 3000 && b.f_5920996 != 3001 && b.f_5920996 != 3002) continue;
            toKeep.add(o);
        }
        this.f_2213969.clear();
        for (Object o : toKeep) {
            this.f_2213969.add(o);
        }
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int contentTop = backgroundY + 24;
        int buttonX = backgroundX + 10 + 100 + 4;
        int buttonWidth = this.backgroundWidth - 120;
        for (GroupListPacket.GroupInfo group : this.availableGroups) {
            String buttonText = group.hasPassword() ? "Join (Private)" : "Join";
            C_2348249 joinButton = new C_2348249(5000 + this.entries.size(), buttonX, contentTop + this.entries.size() * 24, buttonWidth, 20, buttonText);
            this.f_2213969.add(joinButton);
            this.entries.add(new GroupEntry(group, joinButton));
        }
        int buttonY = backgroundY + this.backgroundHeight - 28;
        this.f_2213969.add(new C_2348249(1105, backgroundX + 8, buttonY, this.backgroundWidth - 16, 20, "Create Group"));
    }

    private void layoutAndRenderEntries(int mouseX, int mouseY, float tickDelta) {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int contentTop = backgroundY + 24;
        int contentBottom = backgroundY + this.backgroundHeight - 36;
        if (this.entries.isEmpty()) {
            String message = "No groups to join";
            int messageWidth = this.f_2020658.m_0040387(message);
            int messageX = backgroundX + (this.backgroundWidth - messageWidth) / 2;
            int messageY = backgroundY + this.backgroundHeight / 2;
            this.f_2020658.m_4683674(message, messageX, messageY, 0xAAAAAA);
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean visible;
            GroupEntry e = this.entries.get(i);
            int rowY = contentTop + i * 24 - this.scrollOffset;
            e.joinButton.f_1990467 = visible = rowY + 20 > contentTop && rowY < contentBottom;
            e.joinButton.f_3923091 = backgroundX + 10 + 100 + 4;
            e.joinButton.f_8532347 = rowY;
            if (!visible) continue;
            String groupDisplay = e.group.getName() + " (" + e.group.getMemberCount() + ")" + (e.group.hasPassword() ? " [Private]" : " [Public]");
            this.f_2020658.m_4683674(groupDisplay, backgroundX + 10, rowY + 6, 0xFFFFFF);
        }
    }

    public void updateGroupList(List<GroupListPacket.GroupInfo> groups) {
        this.availableGroups = new ArrayList<GroupListPacket.GroupInfo>(groups);
        this.buildGroupEntries();
    }

    public static void updateCurrentGroupList(List<GroupListPacket.GroupInfo> groups) {
        if (currentInstance != null) {
            currentInstance.updateGroupList(groups);
        }
    }

    public void m_8984281() {
        if (currentInstance == this) {
            currentInstance = null;
        }
        super.m_8984281();
    }

    private static class GroupEntry {
        final GroupListPacket.GroupInfo group;
        final C_2348249 joinButton;

        GroupEntry(GroupListPacket.GroupInfo group, C_2348249 joinButton) {
            this.group = group;
            this.joinButton = joinButton;
        }
    }
}

