/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.client.init.Voice;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.widget.VoiceSliderWidget;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_5786166;
import org.lwjgl.opengl.GL11;

public class VoiceSettingsScreen
extends BaseVoiceScreen {
    private static final String MICROPHONE_ICON = "/assets/legacyvoicechat/textures/icons/microphone.png";
    private static final String MICROPHONE_MUTE_ICON = "/assets/legacyvoicechat/textures/icons/microphone_off.png";
    private static final String PLAYER_MUTED = "/assets/legacyvoicechat/textures/icons/player_muted.png";
    private static final String PLAYER_TALKING = "/assets/legacyvoicechat/textures/icons/player_talking.png";
    private boolean isMuted = false;
    private boolean isDeafened = false;
    private double threshold = -60.0;
    private float lastSliderValue = 0.5f;
    private float micGain = 1.0f;
    private float voiceVolume = 1.0f;
    private boolean pushToTalk = false;
    private boolean testingMic = false;
    private List<String> inputDevices;
    private int selectedDeviceIndex;
    private List<String> outputDevices;
    private int selectedOutputDeviceIndex;

    @Override
    protected void initContent() {
        VoiceClient vc = Voice.getVoiceClient();
        if (vc != null) {
            this.threshold = vc.getSilenceThreshold();
            this.micGain = vc.getMicrophoneGain();
            this.voiceVolume = vc.getMasterVolume();
            this.testingMic = vc.isMicrophoneTesting();
            this.pushToTalk = vc.isPushToTalk();
        }
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        this.initVoiceControls(vc, backgroundX, backgroundY);
        this.initMuteButton(vc, backgroundX, backgroundY);
        this.initDefeanButton(vc, backgroundX, backgroundY);
    }

    private void initVoiceControls(VoiceClient vc, int backgroundX, int backgroundY) {
        int controlX = backgroundX + 8;
        int controlY = backgroundY + 22;
        int controlWidth = this.backgroundWidth - 16;
        this.f_2213969.add(new VoiceSliderWidget(1100, controlX, controlY, controlWidth, 20, "Voice Chat Volume: " + Math.round(this.voiceVolume * 100.0f) + "%", Math.max(0.0f, Math.min(1.0f, this.voiceVolume / 2.0f))));
        float gain = vc != null ? vc.getMicrophoneGain() : this.micGain;
        this.f_2213969.add(new VoiceSliderWidget(1102, controlX, controlY + 24, controlWidth, 20, "Microphone Volume: " + Math.round(gain * 100.0f) + "%", Math.max(0.0f, Math.min(1.0f, gain / 2.0f))));
        String activationLabel = "Activation Type: " + (this.pushToTalk ? "Push To Talk" : "Voice");
        this.f_2213969.add(new C_2348249(1103, controlX, controlY + 48, controlWidth, 20, activationLabel));
        double sliderValue = 1.0 - Math.max(-127.0, this.threshold) / -127.0;
        this.lastSliderValue = (float)sliderValue;
        this.f_2213969.add(new VoiceSliderWidget(1104, controlX, controlY + 72, controlWidth, 20, "Activation Threshold: " + (int)Math.round(this.threshold) + " dB", (float)sliderValue));
        this.buildInputDevices();
        String currentName = vc != null ? vc.getInputDeviceName() : null;
        this.selectedDeviceIndex = currentName != null ? Math.max(0, this.inputDevices.indexOf(currentName)) : 0;
        String label = "Microphone: " + this.inputDevices.get(this.selectedDeviceIndex);
        this.f_2213969.add(new C_2348249(1004, controlX, controlY + 96, controlWidth, 20, label));
        this.buildOutputDevices();
        String currentOutputName = vc != null ? vc.getOutputDeviceName() : null;
        this.selectedOutputDeviceIndex = currentOutputName != null ? Math.max(0, this.outputDevices.indexOf(currentOutputName)) : 0;
        String outputLabel = "Speakers: " + this.outputDevices.get(this.selectedOutputDeviceIndex);
        this.f_2213969.add(new C_2348249(1005, controlX, controlY + 120, controlWidth, 20, outputLabel));
        String testLabel = this.testingMic ? "Disable Microphone Testing" : "Test Microphone";
        this.f_2213969.add(new C_2348249(1105, controlX, controlY + 144, controlWidth, 20, testLabel));
    }

    private void initMuteButton(VoiceClient vc, int backgroundX, int backgroundY) {
        int buttonX = backgroundX + 8;
        int buttonY = backgroundY + this.backgroundHeight - 28;
        if (vc != null) {
            this.isMuted = vc.isMicMuted();
        }
        C_2348249 muteButton = new C_2348249(2000, buttonX, buttonY, 20, 20, null);
        this.f_2213969.add(muteButton);
    }

    private void initDefeanButton(VoiceClient vc, int backgroundX, int backgroundY) {
        int buttonX = backgroundX + 32;
        int buttonY = backgroundY + this.backgroundHeight - 28;
        if (vc != null) {
            this.isDeafened = vc.isDeafened();
        }
        C_2348249 defeanButton = new C_2348249(2001, buttonX, buttonY, 20, 20, null);
        this.f_2213969.add(defeanButton);
    }

    @Override
    protected void handleCustomButtonClick(C_2348249 button) {
        VoiceClient vc = Voice.getVoiceClient();
        if (button.f_5920996 == 2000) {
            if (vc != null) {
                vc.toggleMute();
                this.isMuted = vc.isMicMuted();
            }
        } else if (button.f_5920996 == 2001) {
            if (vc != null) {
                vc.toggleDeafened();
                this.isDeafened = vc.isDeafened();
                this.isMuted = vc.isMicMuted();
            }
        } else if (button.f_5920996 == 1103) {
            this.pushToTalk = !this.pushToTalk;
            button.f_4865617 = "Activation Type: " + (this.pushToTalk ? "Push To Talk" : "Voice");
            if (vc != null) {
                vc.setPushToTalk(this.pushToTalk);
            }
        } else if (button.f_5920996 == 1004) {
            this.selectedDeviceIndex = (this.selectedDeviceIndex + 1) % this.inputDevices.size();
            String name = this.inputDevices.get(this.selectedDeviceIndex);
            button.f_4865617 = "Microphone: " + name;
            if (vc != null) {
                if ("Default".equals(name)) {
                    vc.setInputDeviceName(null);
                } else {
                    vc.setInputDeviceName(name);
                }
            }
        } else if (button.f_5920996 == 1005) {
            this.selectedOutputDeviceIndex = (this.selectedOutputDeviceIndex + 1) % this.outputDevices.size();
            String name = this.outputDevices.get(this.selectedOutputDeviceIndex);
            button.f_4865617 = "Speakers: " + name;
            if (vc != null) {
                if ("Default".equals(name)) {
                    vc.setOutputDeviceName(null);
                } else {
                    vc.setOutputDeviceName(name);
                }
            }
        } else if (button.f_5920996 == 1105) {
            this.testingMic = !this.testingMic;
            String string = button.f_4865617 = this.testingMic ? "Disable Microphone Testing" : "Test Microphone";
            if (vc != null) {
                if (this.testingMic) {
                    if (!vc.startMicrophoneTesting()) {
                        this.testingMic = false;
                        button.f_4865617 = "Test Microphone";
                        System.err.println("Failed to start microphone testing");
                    }
                } else {
                    vc.stopMicrophoneTesting();
                }
            }
        }
    }

    @Override
    protected void renderContent(int mouseX, int mouseY, float tickDelta) {
        for (Object o : this.f_2213969) {
            if (!(o instanceof VoiceSliderWidget)) continue;
            VoiceSliderWidget s = (VoiceSliderWidget)((Object)o);
            if (s.f_5920996 == 1100) {
                this.voiceVolume = Math.max(0.0f, Math.min(2.0f, s.f_4574660 * 2.0f));
                s.f_4865617 = "Voice Chat Volume: " + Math.round(this.voiceVolume * 100.0f) + "%";
                VoiceClient vc = Voice.getVoiceClient();
                if (vc == null) continue;
                vc.setMasterVolume(this.voiceVolume);
                continue;
            }
            if (s.f_5920996 == 1102) {
                this.micGain = Math.max(0.0f, Math.min(2.0f, s.f_4574660 * 2.0f));
                s.f_4865617 = "Microphone Volume: " + (int)(this.micGain * 100.0f) + "%";
                VoiceClient vc2 = Voice.getVoiceClient();
                if (vc2 == null) continue;
                vc2.setMicrophoneGain(this.micGain);
                continue;
            }
            if (s.f_5920996 != 1104) continue;
            if (Math.abs(s.f_4574660 - this.lastSliderValue) > 0.001f) {
                this.lastSliderValue = s.f_4574660;
                this.threshold = (1.0 - (double)s.f_4574660) * -127.0;
                this.threshold = Math.max(-127.0, Math.min(0.0, this.threshold));
                VoiceClient vc3 = Voice.getVoiceClient();
                if (vc3 != null) {
                    vc3.setSilenceThreshold(this.threshold);
                }
            }
            s.f_4865617 = "Activation Threshold: " + (int)Math.round(this.threshold) + " dB";
        }
    }

    @Override
    protected String getBackgroundTexture() {
        return "/assets/legacyvoicechat/textures/gui/background.png";
    }

    @Override
    protected String getTitle() {
        return "Voice Settings";
    }

    public void m_8984281() {
        VoiceClient vc = Voice.getVoiceClient();
        if (vc != null && this.testingMic) {
            vc.stopMicrophoneTesting();
        }
        super.m_8984281();
    }

    @Override
    protected void drawForeground() {
        super.drawForeground();
        this.drawMuteIcon();
        this.drawDeafenedIcon();
    }

    protected void drawMuteIcon() {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int buttonX = backgroundX + 8;
        int buttonY = backgroundY + this.backgroundHeight - 28;
        int buttonSize = 20;
        int iconSize = 12;
        int iconX = buttonX + (buttonSize - iconSize) / 2;
        int iconY = buttonY + (buttonSize - iconSize) / 2;
        String iconPath = this.isMuted ? MICROPHONE_MUTE_ICON : MICROPHONE_ICON;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_7153641.f_9413506.m_4291731(iconPath);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        C_5786166 bufferBuilder = C_5786166.f_7436514;
        bufferBuilder.m_5815628();
        bufferBuilder.m_1165938((double)iconX, (double)(iconY + iconSize), 0.0, 0.0, 1.0);
        bufferBuilder.m_1165938((double)(iconX + iconSize), (double)(iconY + iconSize), 0.0, 1.0, 1.0);
        bufferBuilder.m_1165938((double)(iconX + iconSize), (double)iconY, 0.0, 1.0, 0.0);
        bufferBuilder.m_1165938((double)iconX, (double)iconY, 0.0, 0.0, 0.0);
        bufferBuilder.m_7459300();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    protected void drawDeafenedIcon() {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int buttonX = backgroundX + 32;
        int buttonY = backgroundY + this.backgroundHeight - 28;
        int buttonSize = 20;
        int iconSize = 12;
        int iconX = buttonX + (buttonSize - iconSize) / 2;
        int iconY = buttonY + (buttonSize - iconSize) / 2;
        String iconPath = this.isDeafened ? PLAYER_MUTED : PLAYER_TALKING;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_7153641.f_9413506.m_4291731(iconPath);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        C_5786166 bufferBuilder = C_5786166.f_7436514;
        bufferBuilder.m_5815628();
        bufferBuilder.m_1165938((double)iconX, (double)(iconY + iconSize), 0.0, 0.0, 1.0);
        bufferBuilder.m_1165938((double)(iconX + iconSize), (double)(iconY + iconSize), 0.0, 1.0, 1.0);
        bufferBuilder.m_1165938((double)(iconX + iconSize), (double)iconY, 0.0, 1.0, 0.0);
        bufferBuilder.m_1165938((double)iconX, (double)iconY, 0.0, 0.0, 0.0);
        bufferBuilder.m_7459300();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private void buildInputDevices() {
        this.inputDevices = new ArrayList<String>();
        this.inputDevices.add("Default");
        try {
            Mixer.Info[] mixers;
            for (Mixer.Info mi : mixers = AudioSystem.getMixerInfo()) {
                try {
                    String name;
                    Mixer m = AudioSystem.getMixer(mi);
                    Line.Info lineInfo = new Line.Info(TargetDataLine.class);
                    if (!m.isLineSupported(lineInfo) || this.inputDevices.contains(name = mi.getName())) continue;
                    this.inputDevices.add(name);
                }
                catch (Exception e) {
                    System.out.println("  \u2717 Error: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error getting mixer info: " + e.getMessage());
        }
        if (this.inputDevices.isEmpty()) {
            this.inputDevices.add("Default");
        }
    }

    private void buildOutputDevices() {
        this.outputDevices = new ArrayList<String>();
        this.outputDevices.add("Default");
        try {
            Mixer.Info[] mixers;
            for (Mixer.Info mi : mixers = AudioSystem.getMixerInfo()) {
                try {
                    String name;
                    Mixer m = AudioSystem.getMixer(mi);
                    Line.Info lineInfo = new Line.Info(SourceDataLine.class);
                    if (!m.isLineSupported(lineInfo) || this.outputDevices.contains(name = mi.getName())) continue;
                    this.outputDevices.add(name);
                }
                catch (Exception e) {
                    System.out.println("  \u2717 Error: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error getting mixer info: " + e.getMessage());
        }
        if (this.outputDevices.isEmpty()) {
            this.outputDevices.add("Default");
        }
    }
}

