/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.server;

import com.moyettes.voice.config.VoiceServerConfig;
import com.moyettes.voice.server.init.Voice;
import com.moyettes.voice.udp.GroupCreatePacket;
import com.moyettes.voice.udp.GroupDataPacket;
import com.moyettes.voice.udp.GroupJoinPacket;
import com.moyettes.voice.udp.GroupLeavePacket;
import com.moyettes.voice.udp.GroupListPacket;
import com.moyettes.voice.udp.GroupMemberUpdatePacket;
import com.moyettes.voice.udp.PingPacket;
import com.moyettes.voice.udp.PresenceBulkPacket;
import com.moyettes.voice.udp.PresenceUpdatePacket;
import com.moyettes.voice.udp.UdpPacket;
import com.moyettes.voice.udp.VoiceDataPacket;
import com.moyettes.voice.udp.VoiceDataRelayPacket;
import com.moyettes.voice.udp.VoiceHandshakeAckPacket;
import com.moyettes.voice.udp.VoiceHandshakePacket;
import com.moyettes.voice.utils.MinecraftServerAccessor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_3292284;

public class VoiceServer {
    private static final String PROTOCOL_VERSION = "1.0.0";
    private DatagramSocket socket;
    private ExecutorService executor;
    private boolean running = false;
    private int port;
    private VoiceServerConfig config;
    private Map<SocketAddress, Integer> connectedPlayers = new HashMap<SocketAddress, Integer>();
    private final Map<String, Group> groups = new ConcurrentHashMap<String, Group>();
    private final Map<Integer, String> playerToGroup = new ConcurrentHashMap<Integer, String>();
    private final Map<Integer, C_3292284> playerCache = new ConcurrentHashMap<Integer, C_3292284>();
    private final Map<Integer, SocketAddress> playerAddressCache = new ConcurrentHashMap<Integer, SocketAddress>();
    private long lastCacheUpdate = 0L;
    private static final long CACHE_UPDATE_INTERVAL = 1000L;
    private final Map<SocketAddress, Long> lastKeepAlive = new ConcurrentHashMap<SocketAddress, Long>();
    private final Map<SocketAddress, Long> lastSentKeepAlive = new ConcurrentHashMap<SocketAddress, Long>();
    private final Map<Integer, Boolean> playerVoiceSupported = new ConcurrentHashMap<Integer, Boolean>();
    private final Map<Integer, Boolean> playerDeafenState = new ConcurrentHashMap<Integer, Boolean>();

    public VoiceServer() {
        this.config = VoiceServerConfig.load();
        this.port = this.config.getPort();
        this.executor = Executors.newCachedThreadPool();
    }

    public void start() throws IOException {
        if (this.running) {
            return;
        }
        this.socket = new DatagramSocket(this.port);
        try {
            this.socket.setReceiveBufferSize(262144);
            this.socket.setSendBufferSize(262144);
            this.socket.setReuseAddress(true);
            this.socket.setTrafficClass(4);
        }
        catch (Exception e) {
            System.err.println("Failed to set socket buffer sizes: " + e.getMessage());
        }
        this.running = true;
        this.executor.submit(this::listenForPackets);
    }

    public void stop() {
        this.running = false;
        this.connectedPlayers.clear();
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private void listenForPackets() {
        byte[] buffer = new byte[2048];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        while (this.running && !this.socket.isClosed()) {
            try {
                this.socket.receive(packet);
                int length = packet.getLength();
                if (length <= 0) continue;
                byte[] dataCopy = new byte[length];
                System.arraycopy(packet.getData(), packet.getOffset(), dataCopy, 0, length);
                SocketAddress sender = packet.getSocketAddress();
                this.executor.submit(() -> {
                    DatagramPacket safePacket = new DatagramPacket(dataCopy, dataCopy.length, sender);
                    this.handlePacket(safePacket);
                });
            }
            catch (IOException e) {
                String errorMsg;
                if (!this.running || (errorMsg = e.getMessage()) != null && (errorMsg.contains("Connection reset") || errorMsg.contains("Connection refused") || errorMsg.contains("Network is unreachable") || errorMsg.contains("Socket closed"))) continue;
                System.err.println("Error receiving packet: " + e.getMessage());
            }
        }
    }

    private void handlePacket(DatagramPacket packet) {
        try {
            UdpPacket udpPacket;
            int packetLength = packet.getLength();
            if (packetLength <= 0) {
                return;
            }
            byte[] data = new byte[packetLength];
            System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packetLength);
            try {
                udpPacket = UdpPacket.fromBytes(data);
            }
            catch (IOException e) {
                System.err.println("Failed to parse packet from " + packet.getSocketAddress() + " (" + data.length + " bytes): " + e.getMessage());
                return;
            }
            SocketAddress clientAddress = packet.getSocketAddress();
            switch (udpPacket.getType()) {
                case VOICE_HANDSHAKE: {
                    this.handleHandshake((VoiceHandshakePacket)udpPacket, clientAddress);
                    break;
                }
                case VOICE_DATA: {
                    this.handleVoiceData((VoiceDataPacket)udpPacket, clientAddress);
                    break;
                }
                case GROUP_CREATE: {
                    this.handleGroupCreate((GroupCreatePacket)udpPacket, clientAddress);
                    break;
                }
                case GROUP_JOIN: {
                    this.handleGroupJoin((GroupJoinPacket)udpPacket, clientAddress);
                    break;
                }
                case GROUP_LEAVE: {
                    this.handleGroupLeave((GroupLeavePacket)udpPacket, clientAddress);
                    break;
                }
                case GROUP_LIST: {
                    this.handleGroupList((GroupListPacket)udpPacket, clientAddress);
                    break;
                }
                case GROUP_DATA: {
                    this.handleGroupData((GroupDataPacket)udpPacket, clientAddress);
                    break;
                }
                case PING: {
                    this.handlePing((PingPacket)udpPacket, clientAddress);
                    break;
                }
                case PRESENCE_UPDATE: {
                    this.handlePresenceUpdate((PresenceUpdatePacket)udpPacket, clientAddress);
                    break;
                }
                default: {
                    System.out.println("Unknown packet type received from " + clientAddress);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected error handling packet from " + packet.getSocketAddress() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void handleHandshake(VoiceHandshakePacket handshake, SocketAddress clientAddress) {
        String message;
        String authToken;
        Integer playerNetworkId = handshake.getPlayerNetworkId();
        boolean success = this.validateAuthToken(playerNetworkId, authToken = handshake.getAuthToken());
        String string = message = success ? "Connection established" : "Invalid auth token";
        if (success) {
            this.connectedPlayers.put(clientAddress, playerNetworkId);
            this.playerAddressCache.put(playerNetworkId, clientAddress);
            this.playerVoiceSupported.put(playerNetworkId, true);
            this.playerDeafenState.put(playerNetworkId, false);
            this.lastKeepAlive.put(clientAddress, System.currentTimeMillis());
            this.lastSentKeepAlive.put(clientAddress, System.currentTimeMillis());
            this.updatePlayerCache();
            this.sendPresenceBulkToPlayer(clientAddress);
            this.broadcastPresenceUpdate(playerNetworkId, true, false);
        }
        VoiceHandshakeAckPacket ack = new VoiceHandshakeAckPacket(success, message);
        this.sendPacket(ack, clientAddress);
    }

    private void handleVoiceData(VoiceDataPacket voiceData, SocketAddress clientAddress) {
        Integer playerNetworkId = voiceData.getPlayerNetworkId();
        byte[] audioData = voiceData.getAudioData();
        long sequenceNumber = voiceData.getSequenceNumber();
        if (!this.connectedPlayers.containsValue(playerNetworkId)) {
            return;
        }
        this.relayAudioData(playerNetworkId, audioData, sequenceNumber);
    }

    private void handlePing(PingPacket pingPacket, SocketAddress clientAddress) {
        this.lastKeepAlive.put(clientAddress, System.currentTimeMillis());
        this.sendPacket(new PingPacket(), clientAddress);
    }

    private void handlePresenceUpdate(PresenceUpdatePacket packet, SocketAddress clientAddress) {
        Integer playerNetworkId = packet.getPlayerNetworkId();
        boolean voiceSupported = packet.isVoiceSupported();
        boolean deafened = packet.isDeafened();
        if (!this.connectedPlayers.containsValue(playerNetworkId)) {
            return;
        }
        this.playerVoiceSupported.put(playerNetworkId, voiceSupported);
        this.playerDeafenState.put(playerNetworkId, deafened);
        this.broadcastPresenceUpdate(playerNetworkId, voiceSupported, deafened);
    }

    private void sendPresenceBulkToPlayer(SocketAddress clientAddress) {
        try {
            HashMap<Integer, PresenceBulkPacket.PlayerState> playerStates = new HashMap<Integer, PresenceBulkPacket.PlayerState>();
            for (Map.Entry<Integer, Boolean> entry : this.playerVoiceSupported.entrySet()) {
                Integer playerId = entry.getKey();
                boolean voiceSupported = entry.getValue();
                boolean deafened = this.playerDeafenState.getOrDefault(playerId, false);
                playerStates.put(playerId, new PresenceBulkPacket.PlayerState(voiceSupported, deafened));
            }
            if (!playerStates.isEmpty()) {
                PresenceBulkPacket bulkPacket = new PresenceBulkPacket(playerStates);
                this.sendPacket(bulkPacket, clientAddress);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to send presence bulk: " + e.getMessage());
        }
    }

    private void broadcastPresenceUpdate(int playerNetworkId, boolean voiceSupported, boolean deafened) {
        try {
            PresenceUpdatePacket packet = new PresenceUpdatePacket(playerNetworkId, voiceSupported, deafened);
            for (SocketAddress address : this.connectedPlayers.keySet()) {
                this.sendPacket(packet, address);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to broadcast presence update: " + e.getMessage());
        }
    }

    private void relayAudioData(Integer fromPlayerId, byte[] audioData, long sequenceNumber) {
        String senderGroupName = this.playerToGroup.get(fromPlayerId);
        if (senderGroupName != null) {
            this.relayGroupAudio(fromPlayerId, audioData, sequenceNumber, senderGroupName);
            return;
        }
        this.relayProximityAudio(fromPlayerId, audioData, sequenceNumber);
    }

    private void relayGroupAudio(Integer fromPlayerId, byte[] audioData, long sequenceNumber, String groupName) {
        Group group = this.groups.get(groupName);
        if (group == null || !group.getMembers().contains(fromPlayerId)) {
            return;
        }
        for (Integer memberId : group.getMembers()) {
            SocketAddress memberAddress;
            if (memberId.equals(fromPlayerId) || (memberAddress = this.playerAddressCache.get(memberId)) == null) continue;
            try {
                VoiceDataRelayPacket relayPacket = new VoiceDataRelayPacket(fromPlayerId, audioData, sequenceNumber, 0.0, 1.0f, 0.0, 0.0, 0.0);
                this.sendPacket(relayPacket, memberAddress);
            }
            catch (Exception exception) {}
        }
    }

    private void relayProximityAudio(Integer fromPlayerId, byte[] audioData, long sequenceNumber) {
        this.updatePlayerCacheIfNeeded();
        C_3292284 senderPlayer = this.playerCache.get(fromPlayerId);
        if (senderPlayer == null) {
            return;
        }
        double maxDistance = this.config.getAudio().getMaxDistance();
        double maxDistanceSquared = maxDistance * maxDistance * 1.25;
        ArrayList<DatagramPacket> packetsToSend = new ArrayList<DatagramPacket>();
        for (Map.Entry<SocketAddress, Integer> entry : this.connectedPlayers.entrySet()) {
            C_3292284 recipientPlayer;
            Integer recipientPlayerId = entry.getValue();
            if (recipientPlayerId.equals(fromPlayerId) || this.playerToGroup.containsKey(recipientPlayerId) || (recipientPlayer = this.playerCache.get(recipientPlayerId)) == null || !(maxDistanceSquared > 0.0) || !senderPlayer.f_4703454.equals(recipientPlayer.f_4703454)) continue;
            try {
                double distanceSquared = this.getDistanceSquared(senderPlayer, recipientPlayer);
                if (distanceSquared > maxDistanceSquared) continue;
                double distance = Math.sqrt(distanceSquared);
                float volume = this.calculateVolumeAttenuation(distance, maxDistance);
                VoiceDataRelayPacket relayPacket = new VoiceDataRelayPacket(fromPlayerId, audioData, sequenceNumber, distance, volume, senderPlayer.f_6638345, senderPlayer.f_1187082, senderPlayer.f_9103758);
                byte[] packetData = relayPacket.toBytes();
                packetsToSend.add(new DatagramPacket(packetData, packetData.length, entry.getKey()));
            }
            catch (Exception exception) {}
        }
        for (DatagramPacket packet : packetsToSend) {
            try {
                this.socket.send(packet);
            }
            catch (IOException e) {
                String errorMsg = e.getMessage();
                if (errorMsg == null || errorMsg.contains("Connection reset") || errorMsg.contains("Connection refused") || errorMsg.contains("Network is unreachable") || errorMsg.contains("Socket closed") || errorMsg.contains("Broken pipe")) continue;
                System.err.println("Failed to relay audio: " + e.getMessage());
            }
        }
    }

    private boolean validateAuthToken(Integer playerNetworkId, String authToken) {
        String validToken = Voice.getPlayerAuthToken(playerNetworkId);
        return validToken != null && validToken.equals(authToken);
    }

    private void sendPacket(UdpPacket packet, SocketAddress address) {
        block2: {
            try {
                byte[] data = packet.toBytes();
                DatagramPacket udpPacket = new DatagramPacket(data, data.length, address);
                this.socket.send(udpPacket);
            }
            catch (IOException e) {
                String errorMsg = e.getMessage();
                if (errorMsg != null && (errorMsg.contains("Connection reset") || errorMsg.contains("Connection refused") || errorMsg.contains("Network is unreachable") || errorMsg.contains("Socket closed") || errorMsg.contains("Broken pipe"))) break block2;
                System.err.println("Error sending packet to " + address + ": " + e.getMessage());
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocolVersion() {
        return PROTOCOL_VERSION;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void disconnectPlayer(Integer playerNetworkId) {
        SocketAddress playerAddress = null;
        for (Map.Entry<SocketAddress, Integer> entry : this.connectedPlayers.entrySet()) {
            if (!entry.getValue().equals(playerNetworkId)) continue;
            playerAddress = entry.getKey();
            break;
        }
        if (playerAddress != null) {
            this.connectedPlayers.remove(playerAddress);
        }
        this.playerCache.remove(playerNetworkId);
        this.playerAddressCache.remove(playerNetworkId);
        this.playerVoiceSupported.remove(playerNetworkId);
        this.playerDeafenState.remove(playerNetworkId);
        this.broadcastPresenceUpdate(playerNetworkId, false, false);
        this.leaveGroup(playerNetworkId);
    }

    public Map<SocketAddress, Integer> getConnectedPlayers() {
        return new HashMap<SocketAddress, Integer>(this.connectedPlayers);
    }

    public VoiceServerConfig getConfig() {
        return this.config;
    }

    private void updatePlayerCacheIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - this.lastCacheUpdate > 1000L) {
            this.updatePlayerCache();
            this.lastCacheUpdate = now;
        }
    }

    private void updatePlayerCache() {
        this.playerCache.clear();
        this.playerAddressCache.clear();
        MinecraftServer server = MinecraftServerAccessor.getMinecraftServer();
        if (server == null) {
            return;
        }
        block0: for (Map.Entry<SocketAddress, Integer> entry : this.connectedPlayers.entrySet()) {
            Integer playerId = entry.getValue();
            SocketAddress address = entry.getKey();
            this.playerAddressCache.put(playerId, address);
            for (int i = 0; i < server.m_8526012().f_9738318.size(); ++i) {
                C_3292284 player = (C_3292284)server.m_8526012().f_9738318.get(i);
                if (player.f_5338989 != playerId) continue;
                this.playerCache.put(playerId, player);
                continue block0;
            }
        }
    }

    private C_3292284 getPlayerEntity(Integer networkId) {
        this.updatePlayerCacheIfNeeded();
        return this.playerCache.get(networkId);
    }

    private double getDistanceSquared(C_3292284 player1, C_3292284 player2) {
        double dx = player1.f_6638345 - player2.f_6638345;
        double dy = player1.f_1187082 - player2.f_1187082;
        double dz = player1.f_9103758 - player2.f_9103758;
        return dx * dx + dy * dy + dz * dz;
    }

    private float calculateVolumeAttenuation(double distance, double maxDistance) {
        if (distance <= 0.0) {
            return 1.0f;
        }
        double fadeDistance = maxDistance / 8.0;
        if (distance <= fadeDistance) {
            return 1.0f;
        }
        float rolloffFactor = 0.95f;
        float attenuation = (float)(fadeDistance / (fadeDistance + (double)rolloffFactor * (distance - fadeDistance)));
        return Math.max(0.0f, Math.min(1.0f, attenuation));
    }

    private void handleGroupCreate(GroupCreatePacket packet, SocketAddress clientAddress) {
        Integer playerId = this.connectedPlayers.get(clientAddress);
        if (playerId == null) {
            return;
        }
        String groupName = packet.getGroupName();
        String password = packet.getPassword();
        if (groupName == null || groupName.trim().isEmpty()) {
            return;
        }
        if (this.groups.containsKey(groupName = groupName.trim())) {
            return;
        }
        if (this.playerToGroup.containsKey(playerId)) {
            this.leaveGroup(playerId);
        }
        Group group = new Group(groupName, password, playerId);
        this.groups.put(groupName, group);
        this.playerToGroup.put(playerId, groupName);
        this.sendGroupMemberUpdate(GroupMemberUpdatePacket.UpdateType.GROUP_CREATED, groupName, playerId, this.getPlayerName(playerId), new ArrayList<Integer>(group.getMembers()));
    }

    private void handleGroupJoin(GroupJoinPacket packet, SocketAddress clientAddress) {
        Integer playerId = this.connectedPlayers.get(clientAddress);
        if (playerId == null) {
            return;
        }
        String groupName = packet.getGroupName();
        String password = packet.getPassword();
        if (groupName == null || groupName.trim().isEmpty()) {
            return;
        }
        Group group = this.groups.get(groupName = groupName.trim());
        if (group == null) {
            return;
        }
        if (this.playerToGroup.containsKey(playerId)) {
            this.leaveGroup(playerId);
        }
        if (group.hasPassword() && !group.getPassword().equals(password)) {
            return;
        }
        group.addMember(playerId);
        this.playerToGroup.put(playerId, groupName);
        this.sendGroupMemberUpdate(GroupMemberUpdatePacket.UpdateType.MEMBER_JOINED, groupName, playerId, this.getPlayerName(playerId), new ArrayList<Integer>(group.getMembers()));
    }

    private void handleGroupLeave(GroupLeavePacket packet, SocketAddress clientAddress) {
        Integer playerId = this.connectedPlayers.get(clientAddress);
        if (playerId == null) {
            return;
        }
        this.leaveGroup(playerId);
    }

    private void handleGroupList(GroupListPacket packet, SocketAddress clientAddress) {
        Integer playerId = this.connectedPlayers.get(clientAddress);
        if (playerId == null) {
            return;
        }
        ArrayList<GroupListPacket.GroupInfo> groupList = new ArrayList<GroupListPacket.GroupInfo>();
        for (Group group : this.groups.values()) {
            groupList.add(new GroupListPacket.GroupInfo(group.getName(), group.hasPassword(), group.getMembers().size()));
        }
        GroupListPacket response = new GroupListPacket(groupList);
        this.sendPacket(response, clientAddress);
    }

    private void handleGroupData(GroupDataPacket packet, SocketAddress clientAddress) {
        Integer playerId = this.connectedPlayers.get(clientAddress);
        if (playerId == null) {
            return;
        }
        String groupName = packet.getGroupName();
        byte[] audioData = packet.getAudioData();
        long sequenceNumber = packet.getSequenceNumber();
        if (!this.playerToGroup.containsKey(playerId) || !this.playerToGroup.get(playerId).equals(groupName)) {
            return;
        }
        Group group = this.groups.get(groupName);
        if (group == null || !group.getMembers().contains(playerId)) {
            return;
        }
        for (Integer memberId : group.getMembers()) {
            SocketAddress memberAddress;
            if (memberId.equals(playerId) || (memberAddress = this.getPlayerAddress(memberId)) == null) continue;
            VoiceDataRelayPacket relayPacket = new VoiceDataRelayPacket(playerId, audioData, sequenceNumber, 0.0, 1.0f, 0.0, 0.0, 0.0);
            this.sendPacket(relayPacket, memberAddress);
        }
    }

    private void leaveGroup(Integer playerId) {
        String groupName = this.playerToGroup.get(playerId);
        if (groupName == null) {
            return;
        }
        Group group = this.groups.get(groupName);
        if (group == null) {
            return;
        }
        group.removeMember(playerId);
        this.playerToGroup.remove(playerId);
        this.sendGroupMemberUpdate(GroupMemberUpdatePacket.UpdateType.MEMBER_LEFT, groupName, playerId, this.getPlayerName(playerId), new ArrayList<Integer>(group.getMembers()));
        if (group.getMembers().isEmpty()) {
            this.groups.remove(groupName);
            this.sendGroupMemberUpdate(GroupMemberUpdatePacket.UpdateType.GROUP_DELETED, groupName, null, null, Collections.emptyList());
        }
    }

    private void sendGroupMemberUpdate(GroupMemberUpdatePacket.UpdateType updateType, String groupName, Integer playerId, String playerName, List<Integer> groupMembers) {
        for (SocketAddress address : this.connectedPlayers.keySet()) {
            GroupMemberUpdatePacket updatePacket = new GroupMemberUpdatePacket(updateType, groupName, playerId, playerName, groupMembers.stream().map(this::getPlayerName).collect(ArrayList::new, ArrayList::add, ArrayList::addAll));
            this.sendPacket(updatePacket, address);
        }
    }

    private String getPlayerName(Integer playerId) {
        C_3292284 player = this.getPlayerEntity(playerId);
        return player != null ? player.f_4437619 : "Unknown";
    }

    private SocketAddress getPlayerAddress(Integer playerId) {
        return this.playerAddressCache.get(playerId);
    }

    private static class Group {
        private final String name;
        private final String password;
        private final Set<Integer> members;
        private final Integer creatorId;

        public Group(String name, String password, Integer creatorId) {
            this.name = name;
            this.password = password;
            this.creatorId = creatorId;
            this.members = new HashSet<Integer>();
            this.members.add(creatorId);
        }

        public String getName() {
            return this.name;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean hasPassword() {
            return this.password != null && !this.password.isEmpty();
        }

        public Set<Integer> getMembers() {
            return new HashSet<Integer>(this.members);
        }

        public void addMember(Integer playerId) {
            this.members.add(playerId);
        }

        public void removeMember(Integer playerId) {
            this.members.remove(playerId);
        }
    }
}

