/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.server.init.metrics;

import com.moyettes.voice.server.init.metrics.VersionHelper;
import com.moyettes.voice.utils.MinecraftServerAccessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class Metrics {
    private static final String SUBMIT_URL = "https://moystats-production.up.railway.app/api/v1/metrics";
    private static final long REPORT_INTERVAL_MS = 1800000L;
    private final String serviceId;
    private final String serverUUID;
    private final boolean enabled;
    private final Timer timer;

    public Metrics(int serviceId, File configFolder) {
        this.serviceId = String.valueOf(serviceId);
        File moyStatsFolder = new File(configFolder, "moyStats");
        moyStatsFolder.mkdirs();
        File configFile = new File(moyStatsFolder, "config.yml");
        String uuid = null;
        boolean isEnabled = true;
        if (!configFile.exists()) {
            uuid = UUID.randomUUID().toString();
            this.writeConfig(configFile, uuid, true);
        } else {
            try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.trim().startsWith("serverUuid:")) {
                        uuid = line.substring(line.indexOf(":") + 1).trim();
                        continue;
                    }
                    if (!line.trim().startsWith("enabled:")) continue;
                    isEnabled = Boolean.parseBoolean(line.substring(line.indexOf(":") + 1).trim());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                this.writeConfig(configFile, uuid, isEnabled);
            }
        }
        this.serverUUID = uuid;
        this.enabled = isEnabled;
        this.timer = new Timer(true);
        if (this.enabled) {
            this.startSubmitting();
        }
    }

    private void writeConfig(File file, String uuid, boolean enabled) {
        try (PrintWriter writer = new PrintWriter(file);){
            writer.println("# bStats (Custom Backend) Config");
            writer.println("enabled: " + enabled);
            writer.println("serverUuid: " + uuid);
            writer.println("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startSubmitting() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Metrics.this.submitData();
            }
        }, 0L, 1800000L);
    }

    private void submitData() {
        try {
            int playerAmount = this.getPlayerCount();
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            String javaVersion = System.getProperty("java.version");
            int coreCount = Runtime.getRuntime().availableProcessors();
            String pluginVersion = "0.1.0";
            String jsonPayload = String.format("{\"serverUUID\": \"%s\",\"serviceId\": %s,\"metrics\": {\"playerAmount\": %d,\"osName\": \"%s\",\"osArch\": \"%s\",\"javaVersion\": \"%s\",\"coreCount\": %d,\"pluginVersion\": \"%s\",\"onlineMode\": %b,\"minecraftVersion\": \"%s\",\"serverSoftware\": \"%s\"}}", this.serverUUID, this.serviceId, playerAmount, this.escapeJson(osName), this.escapeJson(osArch), this.escapeJson(javaVersion), coreCount, this.escapeJson(pluginVersion), MinecraftServerAccessor.getMinecraftServer().m_7314394(), VersionHelper.getGameVersion(), "Ornithe");
            this.sendPostRequest(jsonPayload);
        }
        catch (Exception e) {
            System.err.println("[Metrics] Failed to submit metrics: " + e.getMessage());
        }
    }

    private void sendPostRequest(String json) throws IOException {
        URL url = new URL(SUBMIT_URL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setRequestProperty("Accept", "application/json");
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = json.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        int code = conn.getResponseCode();
        if (code != 200) {
            System.err.println("[Metrics] Error response: " + code);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String responseLine;
            StringBuilder response = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
        }
    }

    private String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private int getPlayerCount() {
        return MinecraftServerAccessor.getMinecraftServer().m_8526012().f_9738318.size();
    }
}

