/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.utils;

public class AudioUtils {
    public static short[] bytesToShorts(byte[] bytes) {
        short[] shorts = new short[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            shorts[i / 2] = AudioUtils.bytesToShort(bytes[i], bytes[i + 1]);
        }
        return shorts;
    }

    public static byte[] shortsToBytes(short[] shorts) {
        byte[] bytes = new byte[shorts.length * 2];
        for (int i = 0; i < bytes.length; i += 2) {
            byte[] sample = AudioUtils.shortToBytes(shorts[i / 2]);
            bytes[i] = sample[0];
            bytes[i + 1] = sample[1];
        }
        return bytes;
    }

    public static float[] bytesToFloats(byte[] bytes) {
        float[] floats = new float[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            floats[i / 2] = (float)AudioUtils.bytesToShort(bytes[i], bytes[i + 1]) / 32768.0f;
        }
        return floats;
    }

    public static byte[] floatsToBytes(float[] floats) {
        byte[] bytes = new byte[floats.length * 2];
        for (int i = 0; i < bytes.length; i += 2) {
            short audioSample = (short)(floats[i / 2] * 32768.0f);
            bytes[i] = (byte)audioSample;
            bytes[i + 1] = (byte)(audioSample >> 8);
        }
        return bytes;
    }

    public static short bytesToShort(byte b1, byte b2) {
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public static byte[] shortToBytes(short s) {
        return new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
    }

    public static float mulToDB(float mul) {
        return mul == 0.0f ? -3.4028235E38f : (float)(20.0 * Math.log10(mul));
    }

    public static float dbToMul(float db) {
        return Float.isFinite(db) ? (float)Math.pow(10.0, db / 20.0f) : 0.0f;
    }

    public static float gainCoefficient(int sampleRate, float time) {
        return (float)Math.exp(-1.0f / ((float)sampleRate * time));
    }

    public static int getActivationOffset(byte[] samples, double activationLevel) {
        int highestPos = -1;
        for (int i = 0; i < samples.length; i += 100) {
            double level = AudioUtils.calculateAudioLevel(samples, i, Math.min(i + 100, samples.length));
            if (!(level >= activationLevel)) continue;
            highestPos = i;
        }
        return highestPos;
    }

    public static double getHighestAudioLevel(byte[] samples) {
        double highest = -127.0;
        for (int i = 0; i < samples.length; i += 100) {
            double level = AudioUtils.calculateAudioLevel(samples, i, Math.min(i + 100, samples.length));
            if (!(level > highest)) continue;
            highest = level;
        }
        return highest;
    }

    public static double calculateAudioLevel(byte[] samples, int offset, int length) {
        double rms = 0.0;
        for (int i = offset; i < length; i += 2) {
            double sample = (double)AudioUtils.bytesToShort(samples[i], samples[i + 1]) / 32767.0;
            rms += sample * sample;
        }
        int sampleCount = length / 2;
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0) : -127.0;
        return db;
    }
}

