/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio;

import com.moyettes.voice.client.init.Voice;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class OpenALAudioPlayback {
    private static final int NUM_BUFFERS = 32;
    private static final int SAMPLE_RATE = 48000;
    private int source;
    private int[] bufferIds = new int[32];
    private int[] freeBuffers = new int[32];
    private int freeBufferCount = 0;
    private volatile boolean initialized = false;

    public boolean initialize() {
        if (this.initialized) {
            return true;
        }
        try {
            int i;
            if (!AL.isCreated()) {
                try {
                    AL.create();
                    Voice.LOGGER.info("OpenAL context created for playback thread");
                }
                catch (LWJGLException e) {
                    Voice.LOGGER.warn("Failed to create OpenAL context on playback thread: " + e.getMessage());
                    return false;
                }
            }
            this.source = AL10.alGenSources();
            if (this.source == 0) {
                Voice.LOGGER.warn("Failed to create OpenAL source - alGenSources returned 0");
                return false;
            }
            int error = AL10.alGetError();
            if (error != 0) {
                Voice.LOGGER.warn("Failed to create OpenAL source - AL error: " + this.getErrorString(error) + " (0x" + Integer.toHexString(error) + ")");
                return false;
            }
            AL10.alSourcei((int)this.source, (int)4103, (int)0);
            AL10.alSourcef((int)this.source, (int)4099, (float)1.0f);
            AL10.alSourcef((int)this.source, (int)4106, (float)1.0f);
            AL10.alSource3f((int)this.source, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSource3f((int)this.source, (int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSourcei((int)this.source, (int)514, (int)1);
            error = AL10.alGetError();
            if (error != 0) {
                this.cleanup();
                Voice.LOGGER.warn("Failed to configure OpenAL source - AL error: " + this.getErrorString(error) + " (0x" + Integer.toHexString(error) + ")");
                return false;
            }
            for (i = 0; i < 32; ++i) {
                this.bufferIds[i] = AL10.alGenBuffers();
            }
            error = AL10.alGetError();
            if (error != 0) {
                this.cleanup();
                Voice.LOGGER.warn("Failed to create OpenAL buffers - AL error: " + this.getErrorString(error) + " (0x" + Integer.toHexString(error) + ")");
                return false;
            }
            for (i = 0; i < 32; ++i) {
                this.freeBuffers[i] = this.bufferIds[i];
            }
            this.freeBufferCount = 32;
            this.initialized = true;
            Voice.LOGGER.info("OpenAL audio playback initialized successfully");
            return true;
        }
        catch (Exception e) {
            Voice.LOGGER.warn("Failed to initialize OpenAL: " + e.getMessage());
            e.printStackTrace();
            this.cleanup();
            return false;
        }
    }

    private String getErrorString(int error) {
        switch (error) {
            case 40961: {
                return "AL_INVALID_NAME";
            }
            case 40962: {
                return "AL_INVALID_ENUM";
            }
            case 40963: {
                return "AL_INVALID_VALUE";
            }
            case 40964: {
                return "AL_INVALID_OPERATION";
            }
            case 40965: {
                return "AL_OUT_OF_MEMORY";
            }
        }
        return "UNKNOWN_ERROR";
    }

    public void writeAudioDirect(byte[] audioData) {
        int bufferId;
        boolean needsPreBuffer;
        if (!this.initialized || audioData == null || audioData.length == 0) {
            return;
        }
        this.removeProcessedBuffers();
        int state = AL10.alGetSourcei((int)this.source, (int)4112);
        int queued = AL10.alGetSourcei((int)this.source, (int)4117);
        int processed = AL10.alGetSourcei((int)this.source, (int)4118);
        int active = queued - processed;
        boolean bl = needsPreBuffer = state == 4113 || state == 4116 || active <= 1;
        if (needsPreBuffer) {
            byte[] silentFrame = new byte[audioData.length];
            for (int i = 0; i < 8; ++i) {
                int silentBufferId = this.getFreeBuffer();
                if (silentBufferId == 0) {
                    this.removeProcessedBuffers();
                    silentBufferId = this.getFreeBuffer();
                    if (silentBufferId == 0) break;
                }
                ByteBuffer silentBuffer = BufferUtils.createByteBuffer((int)silentFrame.length);
                silentBuffer.put(silentFrame);
                silentBuffer.flip();
                AL10.alBufferData((int)silentBufferId, (int)4355, (ByteBuffer)silentBuffer, (int)48000);
                if (AL10.alGetError() == 0) {
                    AL10.alSourceQueueBuffers((int)this.source, (int)silentBufferId);
                    continue;
                }
                this.returnFreeBuffer(silentBufferId);
            }
        }
        if ((queued = AL10.alGetSourcei((int)this.source, (int)4117)) >= 32) {
            Voice.LOGGER.warn("Buffer overflow detected: " + queued + "/" + 32 + " - skipping packets");
            this.removeProcessedBuffers();
            if (this.getFreeBuffer() == 0) {
                return;
            }
        }
        if ((bufferId = this.getFreeBuffer()) == 0) {
            this.removeProcessedBuffers();
            bufferId = this.getFreeBuffer();
            if (bufferId == 0) {
                return;
            }
        }
        ByteBuffer audioBuffer = BufferUtils.createByteBuffer((int)audioData.length);
        audioBuffer.put(audioData);
        audioBuffer.flip();
        AL10.alBufferData((int)bufferId, (int)4355, (ByteBuffer)audioBuffer, (int)48000);
        int error = AL10.alGetError();
        if (error != 0) {
            Voice.LOGGER.warn("Failed to buffer audio data: " + this.getErrorString(error));
            this.returnFreeBuffer(bufferId);
            return;
        }
        AL10.alSourceQueueBuffers((int)this.source, (int)bufferId);
        error = AL10.alGetError();
        if (error != 0) {
            Voice.LOGGER.warn("Failed to queue buffer: " + this.getErrorString(error));
            return;
        }
        state = AL10.alGetSourcei((int)this.source, (int)4112);
        if (state != 4114) {
            AL10.alSourcePlay((int)this.source);
        }
    }

    private int getFreeBuffer() {
        if (this.freeBufferCount > 0) {
            return this.freeBuffers[--this.freeBufferCount];
        }
        return 0;
    }

    private void returnFreeBuffer(int bufferId) {
        if (this.freeBufferCount < 32) {
            this.freeBuffers[this.freeBufferCount++] = bufferId;
        }
    }

    private void removeProcessedBuffers() {
        for (int processed = AL10.alGetSourcei((int)this.source, (int)4118); processed > 0; --processed) {
            int bufferId = AL10.alSourceUnqueueBuffers((int)this.source);
            this.returnFreeBuffer(bufferId);
        }
    }

    public void close() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.source != 0) {
            try {
                AL10.alSourceStop((int)this.source);
                this.removeProcessedBuffers();
                AL10.alDeleteSources((int)this.source);
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Error during OpenAL source cleanup: " + e.getMessage());
            }
            this.source = 0;
        }
        if (this.bufferIds != null) {
            for (int i = 0; i < this.bufferIds.length; ++i) {
                if (this.bufferIds[i] == 0) continue;
                try {
                    AL10.alDeleteBuffers((int)this.bufferIds[i]);
                }
                catch (Exception e) {
                    Voice.LOGGER.warn("Error deleting OpenAL buffer " + i + ": " + e.getMessage());
                }
                this.bufferIds[i] = 0;
            }
        }
        if (AL.isCreated()) {
            try {
                AL.destroy();
                Voice.LOGGER.info("OpenAL context destroyed for playback thread");
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Error destroying OpenAL context: " + e.getMessage());
            }
        }
        this.initialized = false;
        Voice.LOGGER.info("OpenAL audio playback closed");
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

