/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.codec;

import com.moyettes.voice.client.init.Voice;
import com.plasmoverse.opus.OpusDecoder;
import com.plasmoverse.opus.OpusException;
import java.io.IOException;

public class NativeOpusDecoder {
    private OpusDecoder decoder;
    private final int sampleRate;
    private final int channels;
    private final int frameSize;
    private boolean initialized = false;

    public NativeOpusDecoder(int sampleRate, int frameSize, boolean stereo) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
        this.frameSize = frameSize;
    }

    public void initialize() {
        try {
            this.decoder = OpusDecoder.create(this.sampleRate, this.channels == 2, this.frameSize);
            this.initialized = true;
            Voice.LOGGER.info("Native Opus decoder initialized successfully");
        }
        catch (OpusException | IOException e) {
            Voice.LOGGER.warn("Failed to initialize native Opus decoder: " + e.getMessage());
            this.initialized = false;
        }
    }

    public short[] decode(byte[] opusData) {
        if (!this.initialized || this.decoder == null || opusData == null) {
            return null;
        }
        try {
            return this.decoder.decode(opusData);
        }
        catch (OpusException e) {
            Voice.LOGGER.warn("Native Opus decoding failed: " + e.getMessage());
            return null;
        }
    }

    public short[] decodeSilence() {
        if (!this.initialized || this.decoder == null) {
            return null;
        }
        try {
            return this.decoder.decode(null);
        }
        catch (OpusException e) {
            Voice.LOGGER.warn("Native Opus silence decoding failed: " + e.getMessage());
            return null;
        }
    }

    public void reset() {
        if (this.initialized && this.decoder != null) {
            try {
                this.decoder.reset();
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Failed to reset native Opus decoder: " + e.getMessage());
            }
        }
    }

    public void close() {
        if (this.decoder != null) {
            try {
                this.decoder.close();
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Failed to close native Opus decoder: " + e.getMessage());
            }
            this.decoder = null;
            this.initialized = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

