/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.utils;

public class AudioUtils {
    public static double getHighestAudioLevel(byte[] audioData) {
        if (audioData == null || audioData.length == 0) {
            return -127.0;
        }
        long sum = 0L;
        int sampleCount = 0;
        for (int i = 0; i < audioData.length - 1; i += 2) {
            int sample = audioData[i] & 0xFF | (audioData[i + 1] & 0xFF) << 8;
            if (sample > Short.MAX_VALUE) {
                sample -= 65536;
            }
            sum += (long)(sample * sample);
            ++sampleCount;
        }
        if (sampleCount == 0) {
            return -127.0;
        }
        double rms = Math.sqrt((double)sum / (double)sampleCount);
        return 20.0 * Math.log10(rms / 32768.0);
    }

    public static short getHighestAbsoluteSample(short[] samples) {
        short highest = 0;
        for (short sample : samples) {
            short abs = (short)Math.abs(sample);
            if (abs <= highest) continue;
            highest = abs;
        }
        return highest;
    }

    public static float dbToMul(float db) {
        return Float.isFinite(db) ? (float)Math.pow(10.0, db / 20.0f) : 0.0f;
    }

    public static float mulToDb(float mul) {
        return mul == 0.0f ? -3.4028235E38f : (float)(20.0 * Math.log10(mul));
    }

    public static float gainCoefficient(int sampleRate, float time) {
        return (float)Math.exp(-1.0f / ((float)sampleRate * time));
    }

    public static float[] shortsToFloatsRange(short[] shorts) {
        float[] floats = new float[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            floats[i] = (float)shorts[i] / 32768.0f;
        }
        return floats;
    }

    public static short[] floatsRangeToShort(float[] floats) {
        short[] shorts = new short[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            shorts[i] = (short)(floats[i] * 32768.0f);
        }
        return shorts;
    }

    public static short[] bytesToShorts(byte[] bytes) {
        short[] shorts = new short[bytes.length / 2];
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = (short)(bytes[i * 2] & 0xFF | (bytes[i * 2 + 1] & 0xFF) << 8);
        }
        return shorts;
    }

    public static byte[] shortsToBytes(short[] shorts) {
        byte[] bytes = new byte[shorts.length * 2];
        for (int i = 0; i < shorts.length; ++i) {
            bytes[i * 2] = (byte)(shorts[i] & 0xFF);
            bytes[i * 2 + 1] = (byte)(shorts[i] >> 8 & 0xFF);
        }
        return bytes;
    }

    public static float[] shortsToFloats(short[] shorts) {
        float[] floats = new float[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            floats[i] = (float)shorts[i] / 32768.0f;
        }
        return floats;
    }

    public static short[] floatsToShorts(float[] floats) {
        short[] shorts = new short[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            shorts[i] = (short)Math.max(-32768.0f, Math.min(32767.0f, floats[i] * 32768.0f));
        }
        return shorts;
    }

    public static short[] fadeIn(short[] samples, int channels) {
        if (samples == null || samples.length == 0) {
            return samples;
        }
        int fadeInDuration = samples.length;
        short[] processed = new short[samples.length];
        for (int index = 0; index < samples.length; index += channels) {
            float fade = Math.min((float)index / (float)fadeInDuration, 1.0f);
            for (int channel = 0; channel < channels; ++channel) {
                if (index + channel >= samples.length) continue;
                processed[index + channel] = (short)((float)samples[index + channel] * fade);
            }
        }
        return processed;
    }

    public static short[] fadeOut(short[] samples, int channels) {
        if (samples == null || samples.length == 0) {
            return samples;
        }
        int fadeOutDuration = samples.length;
        short[] processed = new short[samples.length];
        for (int index = 0; index < samples.length; index += channels) {
            float fade = Math.max((float)(fadeOutDuration - index) / (float)fadeOutDuration, 0.0f);
            for (int channel = 0; channel < channels; ++channel) {
                if (index + channel >= samples.length) continue;
                processed[index + channel] = (short)((float)samples[index + channel] * fade);
            }
        }
        return processed;
    }
}

