/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class ClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @SerializedName(value="microphone_gain")
    private float microphoneGain = 1.0f;
    @SerializedName(value="master_volume")
    private float masterVolume = 1.0f;
    @SerializedName(value="activation_threshold")
    private double activationThreshold = -60.0;
    @SerializedName(value="push_to_talk")
    private boolean pushToTalk = false;
    @SerializedName(value="input_device")
    private String inputDevice = null;
    @SerializedName(value="output_device")
    private String outputDevice = null;
    @SerializedName(value="player_volumes")
    private Map<String, Float> playerVolumes = new HashMap<String, Float>();
    private static final float MIN_VOLUME = 0.0f;
    private static final float MAX_VOLUME = 2.0f;
    private static final double MIN_THRESHOLD = -127.0;
    private static final double MAX_THRESHOLD = 0.0;

    public float getMicrophoneGain() {
        return this.microphoneGain;
    }

    public void setMicrophoneGain(float microphoneGain) {
        this.microphoneGain = Math.max(0.0f, Math.min(2.0f, microphoneGain));
    }

    public float getMasterVolume() {
        return this.masterVolume;
    }

    public void setMasterVolume(float masterVolume) {
        this.masterVolume = Math.max(0.0f, Math.min(2.0f, masterVolume));
    }

    public double getActivationThreshold() {
        return this.activationThreshold;
    }

    public void setActivationThreshold(double activationThreshold) {
        this.activationThreshold = Math.max(-127.0, Math.min(0.0, activationThreshold));
    }

    public boolean isPushToTalk() {
        return this.pushToTalk;
    }

    public void setPushToTalk(boolean pushToTalk) {
        this.pushToTalk = pushToTalk;
    }

    public String getInputDevice() {
        return this.inputDevice;
    }

    public void setInputDevice(String inputDevice) {
        this.inputDevice = inputDevice != null && inputDevice.trim().isEmpty() ? null : inputDevice;
    }

    public String getOutputDevice() {
        return this.outputDevice;
    }

    public void setOutputDevice(String outputDevice) {
        this.outputDevice = outputDevice != null && outputDevice.trim().isEmpty() ? null : outputDevice;
    }

    public Map<String, Float> getPlayerVolumes() {
        return this.playerVolumes;
    }

    public void setPlayerVolumes(Map<String, Float> playerVolumes) {
        this.playerVolumes = playerVolumes;
    }

    public void setPlayerVolume(String playerName, float volume) {
        float clampedVolume;
        if (playerName == null || playerName.trim().isEmpty()) {
            return;
        }
        if (this.playerVolumes == null) {
            this.playerVolumes = new HashMap<String, Float>();
        }
        if ((clampedVolume = Math.max(0.0f, Math.min(2.0f, volume))) == 1.0f) {
            this.playerVolumes.remove(playerName);
        } else {
            this.playerVolumes.put(playerName, Float.valueOf(clampedVolume));
        }
    }

    public float getPlayerVolume(String playerName) {
        if (this.playerVolumes == null) {
            return 1.0f;
        }
        return this.playerVolumes.getOrDefault(playerName, Float.valueOf(1.0f)).floatValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientConfig load() {
        Path configPath = Paths.get("config", "voice-client.json");
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create config directory: " + e.getMessage());
        }
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                ClientConfig config = (ClientConfig)GSON.fromJson((Reader)reader, ClientConfig.class);
                if (config != null) {
                    if (config.playerVolumes == null) {
                        config.playerVolumes = new HashMap<String, Float>();
                    }
                    ClientConfig clientConfig = config;
                    return clientConfig;
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load client config file: " + e.getMessage());
            }
        }
        ClientConfig defaultConfig = new ClientConfig();
        defaultConfig.save();
        return defaultConfig;
    }

    public void save() {
        Path configPath = Paths.get("config", "voice-client.json");
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save client config file: " + e.getMessage());
        }
    }
}

