/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.client.init.Voice;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.GroupMembersScreen;
import com.moyettes.voice.gui.GroupsScreen;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;

public class CreateGroupScreen
extends BaseVoiceScreen {
    private String groupNameText = "";
    private String passwordText = "";
    private C_2348249 createButton;
    private C_2348249 backButton;
    private boolean isEditingPassword = false;

    @Override
    protected void initContent() {
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        int buttonY = backgroundY + this.backgroundHeight - 60;
        int buttonWidth = (this.backgroundWidth - 40) / 2;
        int buttonSpacing = 8;
        this.createButton = new C_2348249(2001, backgroundX + 16, buttonY, buttonWidth, 20, "Create Group");
        this.backButton = new C_2348249(2002, backgroundX + 16 + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20, "Back");
        this.f_2213969.add(this.createButton);
        this.f_2213969.add(this.backButton);
    }

    @Override
    protected void renderContent(int mouseX, int mouseY, float tickDelta) {
        int groupNameColor;
        String displayPassword;
        int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
        this.f_2020658.m_4683674("Group Name:", backgroundX + 16, backgroundY + 30, 0xFFFFFF);
        this.f_2020658.m_4683674("Password (Optional):", backgroundX + 16, backgroundY + 60, 0xFFFFFF);
        String displayGroupName = this.groupNameText.isEmpty() ? "Enter group name..." : this.groupNameText;
        String string = displayPassword = this.passwordText.isEmpty() ? "Enter password..." : this.passwordText;
        int n = !this.isEditingPassword ? 0xFFFF00 : (groupNameColor = this.groupNameText.isEmpty() ? 0xAAAAAA : 0xFFFFFF);
        int passwordColor = this.isEditingPassword ? 0xFFFF00 : (this.passwordText.isEmpty() ? 0xAAAAAA : 0xFFFFFF);
        this.f_2020658.m_4683674(displayGroupName, backgroundX + 16, backgroundY + 45, groupNameColor);
        this.f_2020658.m_4683674(displayPassword, backgroundX + 16, backgroundY + 75, passwordColor);
    }

    @Override
    protected C_0561170 getBackgroundTexture() {
        return new C_0561170("legacyvoicechat", "textures/gui/group.png");
    }

    @Override
    protected String getTitle() {
        return "Create Group";
    }

    @Override
    protected void handleCustomButtonClick(C_2348249 button) {
        if (button.f_5920996 == 2001) {
            String groupName = this.groupNameText.trim();
            String password = this.passwordText.trim();
            if (!groupName.isEmpty()) {
                Voice.createGroup(groupName, password.isEmpty() ? null : password);
                this.f_7153641.m_6408915((C_3020744)new GroupMembersScreen());
            }
        } else if (button.f_5920996 == 2002) {
            this.f_7153641.m_6408915((C_3020744)new GroupsScreen());
        }
    }

    public void m_6992336(char character, int keyCode) {
        if (keyCode == 1) {
            this.f_7153641.m_6408915((C_3020744)new GroupsScreen());
            return;
        }
        if (keyCode == 28) {
            if (!this.groupNameText.trim().isEmpty()) {
                Voice.createGroup(this.groupNameText.trim(), this.passwordText.trim().isEmpty() ? null : this.passwordText.trim());
                this.f_7153641.m_6408915((C_3020744)new GroupMembersScreen());
            }
            return;
        }
        if (keyCode == 15) {
            this.isEditingPassword = !this.isEditingPassword;
            return;
        }
        if (keyCode == 14) {
            if (this.isEditingPassword && !this.passwordText.isEmpty()) {
                this.passwordText = this.passwordText.substring(0, this.passwordText.length() - 1);
            } else if (!this.isEditingPassword && !this.groupNameText.isEmpty()) {
                this.groupNameText = this.groupNameText.substring(0, this.groupNameText.length() - 1);
            }
            return;
        }
        if (character >= ' ' && character <= '~') {
            if (this.isEditingPassword && this.passwordText.length() < 32) {
                this.passwordText = this.passwordText + character;
            } else if (!this.isEditingPassword && this.groupNameText.length() < 32) {
                this.groupNameText = this.groupNameText + character;
            }
            return;
        }
        super.m_6992336(character, keyCode);
    }

    public void m_7362766(int mouseX, int mouseY, int button) {
        if (button == 0) {
            int backgroundX = (this.f_5465691 - this.backgroundWidth) / 2;
            int backgroundY = (this.f_3080061 - this.backgroundHeight) / 2;
            if (mouseX >= backgroundX + 16 && mouseX <= backgroundX + this.backgroundWidth - 16 && mouseY >= backgroundY + 45 && mouseY <= backgroundY + 60) {
                this.isEditingPassword = false;
                return;
            }
            if (mouseX >= backgroundX + 16 && mouseX <= backgroundX + this.backgroundWidth - 16 && mouseY >= backgroundY + 75 && mouseY <= backgroundY + 90) {
                this.isEditingPassword = true;
                return;
            }
        }
        super.m_7362766(mouseX, mouseY, button);
    }
}

