/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class VoiceDataRelayPacket
extends UdpPacket {
    private Integer fromPlayerNetworkId;
    private byte[] audioData;
    private long sequenceNumber;
    private double distance;
    private float volume;
    private double playerX;
    private double playerY;
    private double playerZ;

    public VoiceDataRelayPacket() {
        super(UdpPacket.PacketType.VOICE_DATA_RELAY);
    }

    public VoiceDataRelayPacket(Integer fromPlayerNetworkId, byte[] audioData, long sequenceNumber, double distance, float volume, double playerX, double playerY, double playerZ) {
        super(UdpPacket.PacketType.VOICE_DATA_RELAY);
        this.fromPlayerNetworkId = fromPlayerNetworkId;
        this.audioData = audioData;
        this.sequenceNumber = sequenceNumber;
        this.distance = distance;
        this.volume = volume;
        this.playerX = playerX;
        this.playerY = playerY;
        this.playerZ = playerZ;
    }

    @Override
    protected void writeData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.fromPlayerNetworkId);
        dos.writeLong(this.sequenceNumber);
        dos.writeDouble(this.distance);
        dos.writeFloat(this.volume);
        dos.writeDouble(this.playerX);
        dos.writeDouble(this.playerY);
        dos.writeDouble(this.playerZ);
        dos.writeInt(this.audioData.length);
        dos.write(this.audioData);
    }

    public static VoiceDataRelayPacket read(DataInputStream dis) throws IOException {
        VoiceDataRelayPacket packet = new VoiceDataRelayPacket();
        packet.fromPlayerNetworkId = dis.readInt();
        packet.sequenceNumber = dis.readLong();
        packet.distance = dis.readDouble();
        packet.volume = dis.readFloat();
        packet.playerX = dis.readDouble();
        packet.playerY = dis.readDouble();
        packet.playerZ = dis.readDouble();
        int dataLength = dis.readInt();
        if (dataLength < 0 || dataLength > 1024) {
            throw new IOException("Invalid audio data length: " + dataLength);
        }
        packet.audioData = new byte[dataLength];
        try {
            dis.readFully(packet.audioData);
        }
        catch (EOFException e) {
            throw new IOException("Insufficient data in packet: expected " + dataLength + " bytes", e);
        }
        return packet;
    }

    public Integer getFromPlayerNetworkId() {
        return this.fromPlayerNetworkId;
    }

    public byte[] getAudioData() {
        return this.audioData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public double getDistance() {
        return this.distance;
    }

    public float getVolume() {
        return this.volume;
    }

    public double getPlayerX() {
        return this.playerX;
    }

    public double getPlayerY() {
        return this.playerY;
    }

    public double getPlayerZ() {
        return this.playerZ;
    }
}

