/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VoiceHandshakePacket
extends UdpPacket {
    private Integer playerNetworkId;
    private String authToken;
    private boolean micEnabled;

    public VoiceHandshakePacket() {
        super(UdpPacket.PacketType.VOICE_HANDSHAKE);
    }

    public VoiceHandshakePacket(Integer playerNetworkId, String authToken, boolean micEnabled) {
        super(UdpPacket.PacketType.VOICE_HANDSHAKE);
        this.playerNetworkId = playerNetworkId;
        this.authToken = authToken;
        this.micEnabled = micEnabled;
    }

    @Override
    protected void writeData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.playerNetworkId);
        dos.writeUTF(this.authToken);
        dos.writeBoolean(this.micEnabled);
    }

    public static VoiceHandshakePacket read(DataInputStream dis) throws IOException {
        VoiceHandshakePacket packet = new VoiceHandshakePacket();
        packet.playerNetworkId = dis.readInt();
        packet.authToken = dis.readUTF();
        packet.micEnabled = dis.readBoolean();
        return packet;
    }

    public Integer getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public boolean isMicEnabled() {
        return this.micEnabled;
    }
}

