/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.filter;

import com.moyettes.voice.audio.filter.AudioFilter;
import com.moyettes.voice.audio.utils.AudioUtils;

public class LimiterFilter
implements AudioFilter {
    private static final float SLOPE = 1.0f;
    private static final float OUTPUT_GAIN = AudioUtils.dbToMul(0.0f);
    private static final float DEFAULT_THRESHOLD = -6.0f;
    private final int sampleRate;
    private final float threshold;
    private float[] envelopeBuf = new float[0];
    private float envelope;

    public LimiterFilter(int sampleRate, float thresholdDb) {
        this.sampleRate = sampleRate;
        this.threshold = thresholdDb;
    }

    @Override
    public String getName() {
        return "limiter";
    }

    @Override
    public short[] process(short[] samples) {
        float[] floatSamples = AudioUtils.shortsToFloatsRange(samples);
        this.analyzeEnvelope(floatSamples);
        this.limit(floatSamples);
        return AudioUtils.floatsRangeToShort(floatSamples);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int getSupportedChannels() {
        return 1;
    }

    private synchronized void limit(float[] samples) {
        int i = 0;
        while (i < samples.length) {
            float envDB = AudioUtils.mulToDb(this.envelopeBuf[i]);
            float limiterGain = 1.0f * (this.threshold - envDB);
            limiterGain = AudioUtils.dbToMul(Math.min(0.0f, limiterGain));
            int n = i++;
            samples[n] = samples[n] * (limiterGain * OUTPUT_GAIN);
        }
    }

    private synchronized void analyzeEnvelope(float[] samples) {
        this.envelopeBuf = new float[samples.length];
        float attackGain = AudioUtils.gainCoefficient(this.sampleRate, 1.0E-6f);
        float releaseGain = AudioUtils.gainCoefficient(this.sampleRate, 0.06f);
        float env = this.envelope;
        for (int i = 0; i < samples.length; ++i) {
            float envIn = Math.abs(samples[i]);
            env = env < envIn ? envIn + attackGain * (env - envIn) : envIn + releaseGain * (env - envIn);
            this.envelopeBuf[i] = Math.max(this.envelopeBuf[i], env);
        }
        this.envelope = this.envelopeBuf[samples.length - 1];
    }
}

