/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.codec;

import com.moyettes.voice.audio.codec.OpusMode;
import com.moyettes.voice.client.init.Voice;
import com.plasmoverse.opus.OpusEncoder;
import com.plasmoverse.opus.OpusException;
import java.io.IOException;
import java.util.Arrays;

public class NativeOpusEncoder {
    private OpusEncoder encoder;
    private final int sampleRate;
    private final int channels;
    private final int mtuSize;
    private boolean initialized = false;

    public NativeOpusEncoder(int sampleRate, int mtuSize, boolean stereo, OpusMode opusMode) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
        this.mtuSize = mtuSize;
    }

    public void initialize() {
        try {
            com.plasmoverse.opus.OpusMode mode = Arrays.stream(com.plasmoverse.opus.OpusMode.values()).filter(element -> element.getApplication() == OpusMode.VOIP.getApplication()).findFirst().orElseThrow(() -> new RuntimeException("Invalid opus application mode"));
            this.encoder = OpusEncoder.create(this.sampleRate, this.channels == 2, this.mtuSize, mode);
            this.encoder.setBitrate(-1000);
            this.initialized = true;
            Voice.LOGGER.info("Native Opus encoder initialized successfully with VOIP mode");
        }
        catch (OpusException | IOException e) {
            Voice.LOGGER.warn("Failed to initialize native Opus encoder: " + e.getMessage());
            this.initialized = false;
        }
    }

    public byte[] encode(short[] samples) {
        if (!this.initialized || this.encoder == null) {
            return null;
        }
        try {
            return this.encoder.encode(samples);
        }
        catch (OpusException e) {
            Voice.LOGGER.warn("Native Opus encoding failed: " + e.getMessage());
            return null;
        }
    }

    public void setBitrate(int bitrate) {
        if (this.initialized && this.encoder != null) {
            this.encoder.setBitrate(bitrate);
        }
    }

    public int getBitrate() {
        if (this.initialized && this.encoder != null) {
            try {
                return this.encoder.getBitrate();
            }
            catch (OpusException e) {
                return 0;
            }
        }
        return 0;
    }

    public void reset() {
        if (this.initialized && this.encoder != null) {
            try {
                this.encoder.reset();
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Failed to reset native Opus encoder: " + e.getMessage());
            }
        }
    }

    public void close() {
        if (this.encoder != null) {
            try {
                this.encoder.close();
            }
            catch (Exception e) {
                Voice.LOGGER.warn("Failed to close native Opus encoder: " + e.getMessage());
            }
            this.encoder = null;
            this.initialized = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

