/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PresenceUpdatePacket
extends UdpPacket {
    private int playerNetworkId;
    private boolean voiceSupported;
    private boolean deafened;

    public PresenceUpdatePacket() {
        super(UdpPacket.PacketType.PRESENCE_UPDATE);
    }

    public PresenceUpdatePacket(int playerNetworkId, boolean voiceSupported, boolean deafened) {
        super(UdpPacket.PacketType.PRESENCE_UPDATE);
        this.playerNetworkId = playerNetworkId;
        this.voiceSupported = voiceSupported;
        this.deafened = deafened;
    }

    @Override
    protected void writeData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.playerNetworkId);
        dos.writeBoolean(this.voiceSupported);
        dos.writeBoolean(this.deafened);
    }

    public static PresenceUpdatePacket read(DataInputStream dis) throws IOException {
        PresenceUpdatePacket packet = new PresenceUpdatePacket();
        packet.playerNetworkId = dis.readInt();
        packet.voiceSupported = dis.readBoolean();
        packet.deafened = dis.readBoolean();
        return packet;
    }

    public int getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public boolean isVoiceSupported() {
        return this.voiceSupported;
    }

    public boolean isDeafened() {
        return this.deafened;
    }
}

