/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class AdaptiveJitterBuffer {
    private final long packetDelayMillis;
    private final Queue<BufferedPacket> queue;
    private long firstPacketArrival = -1L;
    private long firstSequenceNumber = -1L;
    private long lastPacketArrival = -1L;
    private double jitterEstimate = 0.0;
    private long adaptiveDelayMillis;

    public AdaptiveJitterBuffer(int packetDelay) {
        this.adaptiveDelayMillis = this.packetDelayMillis = (long)packetDelay * 20L;
        this.queue = packetDelay <= 1 ? new LinkedBlockingQueue<BufferedPacket>() : new PriorityBlockingQueue<BufferedPacket>(packetDelay * 2, (a, b) -> Long.compare(a.sequenceNumber, b.sequenceNumber));
    }

    public void offer(byte[] audioData, Integer senderId, long sequenceNumber, double distance, float volume, double playerX, double playerY, double playerZ) {
        long arrivalTime = System.currentTimeMillis();
        if (this.lastPacketArrival != -1L) {
            long transit = arrivalTime - this.lastPacketArrival;
            long delta = Math.abs(transit - 20L);
            this.jitterEstimate += ((double)delta - this.jitterEstimate) / 16.0;
            this.adaptiveDelayMillis = Math.round(this.jitterEstimate / 20.0) * 20L;
        }
        this.lastPacketArrival = arrivalTime;
        if (this.firstSequenceNumber == -1L) {
            this.firstPacketArrival = arrivalTime;
            this.firstSequenceNumber = sequenceNumber;
        }
        BufferedPacket packet = new BufferedPacket(audioData, sequenceNumber, distance, volume, playerX, playerY, playerZ, arrivalTime, this.calculateScheduledPlaybackTime(sequenceNumber, arrivalTime));
        this.queue.offer(packet);
    }

    private long calculateScheduledPlaybackTime(long sequenceNumber, long arrivalTime) {
        if (this.firstSequenceNumber == -1L) {
            return arrivalTime + this.packetDelayMillis;
        }
        long sequenceOffset = sequenceNumber - this.firstSequenceNumber;
        return this.firstPacketArrival + this.packetDelayMillis + sequenceOffset * 20L;
    }

    public BufferedPacket poll() {
        return this.queue.poll();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void reset() {
        this.queue.clear();
        this.firstSequenceNumber = -1L;
        this.firstPacketArrival = -1L;
        this.lastPacketArrival = -1L;
        this.jitterEstimate = 0.0;
        this.adaptiveDelayMillis = this.packetDelayMillis;
    }

    public static class BufferedPacket {
        public final byte[] audioData;
        public final long sequenceNumber;
        public final double distance;
        public final float volume;
        public final double playerX;
        public final double playerY;
        public final double playerZ;
        public final long arrivalTime;
        public final long scheduledPlaybackTime;

        public BufferedPacket(byte[] audioData, long sequenceNumber, double distance, float volume, double playerX, double playerY, double playerZ, long arrivalTime, long scheduledPlaybackTime) {
            this.audioData = audioData;
            this.sequenceNumber = sequenceNumber;
            this.distance = distance;
            this.volume = volume;
            this.playerX = playerX;
            this.playerY = playerY;
            this.playerZ = playerZ;
            this.arrivalTime = arrivalTime;
            this.scheduledPlaybackTime = scheduledPlaybackTime;
        }
    }
}

