/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.filter;

import com.moyettes.voice.audio.filter.AudioFilter;
import com.moyettes.voice.audio.utils.AudioUtils;

public class GainFilter
implements AudioFilter {
    private float volume;

    public GainFilter(float volume) {
        this.volume = volume;
    }

    @Override
    public String getName() {
        return "gain";
    }

    @Override
    public short[] process(short[] samples) {
        if (this.volume == 1.0f) {
            return samples;
        }
        short highestValue = AudioUtils.getHighestAbsoluteSample(samples);
        if (highestValue == 0) {
            return samples;
        }
        float maxPossibleMultiplier = 32766.0f / (float)highestValue;
        float actualVolume = Math.min(this.volume, maxPossibleMultiplier);
        short[] result = new short[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            result[i] = (short)((float)samples[i] * actualVolume);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.volume != 1.0f;
    }

    @Override
    public int getSupportedChannels() {
        return 2;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public float getVolume() {
        return this.volume;
    }
}

