/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.client.init;

import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.events.ClientEvents;
import com.moyettes.voice.events.KeyEvents;
import com.moyettes.voice.events.RenderEvents;
import com.moyettes.voice.gui.GroupMembersScreen;
import com.moyettes.voice.gui.GroupsScreen;
import com.moyettes.voice.mixin.ConnectionInterfaceMixin;
import com.moyettes.voice.packet.VoiceModSupportedPayload;
import com.moyettes.voice.packet.VoiceServerInfoPayload;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.minecraft.unmapped.C_4354908;
import net.minecraft.unmapped.C_5722573;
import net.minecraft.unmapped.C_8105098;
import net.ornithemc.osl.entrypoints.api.client.ClientModInitializer;
import net.ornithemc.osl.networking.api.CustomPayload;
import net.ornithemc.osl.networking.api.client.ClientConnectionEvents;
import net.ornithemc.osl.networking.api.client.ClientPlayNetworking;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Voice
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Voice Mod");
    private static VoiceClient voiceClient;
    private static final String PROTOCOL_VERSION = "1.0.0";
    private static final boolean MIC_ENABLED = true;
    public static KeyEvents keyEvents;

    public void initClient() {
        LOGGER.info("Initializing voice mod!");
        this.registerNetworkListeners();
        new ClientEvents();
        new RenderEvents();
        keyEvents = new KeyEvents();
    }

    private void registerNetworkListeners() {
        ClientPlayNetworking.registerListener((String)"voice|server_info", VoiceServerInfoPayload::new, (minecraft, handler, payload) -> {
            LOGGER.info("Received voice server info - Port: " + payload.getVoiceServerPort() + ", Protocol: " + payload.getProtocolVersion());
            this.connectToVoiceServer((VoiceServerInfoPayload)payload, minecraft);
            return true;
        });
        ClientConnectionEvents.PLAY_READY.register(minecraft -> {
            LOGGER.info("Connected to server, sending voice mod support");
            VoiceModSupportedPayload modSupported = new VoiceModSupportedPayload(PROTOCOL_VERSION);
            ClientPlayNetworking.send((String)"voice|mod_supported", (CustomPayload)modSupported);
        });
        ClientConnectionEvents.DISCONNECT.register(minecraft -> {
            if (voiceClient == null) {
                return;
            }
            voiceClient.disconnect();
        });
    }

    private void connectToVoiceServer(VoiceServerInfoPayload serverInfo, C_8105098 minecraft) {
        try {
            Integer playerNetworkId = this.getPlayerNetworkId(minecraft);
            voiceClient = new VoiceClient(playerNetworkId, true);
            voiceClient.setHandshakeCallback(ack -> {
                if (!ack.isSuccess()) {
                    LOGGER.warn("Failed to connect to voice server: " + ack.getMessage());
                } else {
                    this.startListenerPositionUpdater(minecraft);
                }
            });
            String serverHost = serverInfo.getServerHost();
            if ("0.0.0.0".equals(serverHost)) {
                try {
                    InetAddress resolvedAddress = this.resolveServerHostFromConnection(minecraft);
                    serverHost = resolvedAddress instanceof Inet4Address && !resolvedAddress.isLoopbackAddress() ? resolvedAddress.getHostAddress() : "127.0.0.1";
                }
                catch (Exception e) {
                    LOGGER.warn("Could not resolve 0.0.0.0, using localhost: " + e.getMessage());
                    serverHost = "127.0.0.1";
                }
            }
            voiceClient.setGroupListCallback(groupList -> GroupsScreen.updateCurrentGroupList(groupList.getGroups()));
            voiceClient.setGroupMemberCallback(memberNames -> GroupMembersScreen.updateCurrentMemberList(memberNames));
            voiceClient.connect(serverHost, serverInfo.getVoiceServerPort(), serverInfo.getAuthToken());
        }
        catch (IOException e) {
            LOGGER.error("Failed to connect to voice server: " + e.getMessage());
        }
    }

    private InetAddress resolveServerHostFromConnection(C_8105098 minecraft) {
        C_5722573 networkHandler = minecraft.m_3332347();
        if (networkHandler == null) {
            throw new IllegalStateException("No network handler");
        }
        C_5722573 accessor = networkHandler;
        C_4354908 connection = accessor.m_0632702();
        if (connection == null) {
            throw new IllegalStateException("No connection");
        }
        ConnectionInterfaceMixin connectionAccessor = (ConnectionInterfaceMixin)connection;
        SocketAddress remoteAddress = connectionAccessor.getAddress();
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalStateException("Not an InetSocketAddress");
        }
        return ((InetSocketAddress)remoteAddress).getAddress();
    }

    private Integer getPlayerNetworkId(C_8105098 minecraft) {
        try {
            if (minecraft != null && minecraft.f_7663840 != null) {
                return minecraft.f_7663840.m_3843079();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get player network ID: " + e.getMessage());
        }
        return 12345;
    }

    public static VoiceClient getVoiceClient() {
        return voiceClient;
    }

    public static void createGroup(String groupName, String password) {
        if (voiceClient != null) {
            voiceClient.createGroup(groupName, password);
        } else {
            LOGGER.warn("Cannot create group: voice client not connected");
        }
    }

    public static void joinGroup(String groupName, String password) {
        if (voiceClient != null) {
            voiceClient.joinGroup(groupName, password);
        } else {
            LOGGER.warn("Cannot join group: voice client not connected");
        }
    }

    public static void leaveGroup() {
        if (voiceClient != null) {
            voiceClient.leaveGroup();
        } else {
            LOGGER.warn("Cannot leave group: voice client not connected");
        }
    }

    public static void requestGroupList() {
        if (voiceClient != null) {
            voiceClient.requestGroupList();
        } else {
            LOGGER.warn("Cannot request group list: voice client not connected");
        }
    }

    public static boolean isInGroup() {
        return voiceClient != null && voiceClient.isInGroup();
    }

    public static String getCurrentGroupName() {
        return voiceClient != null ? voiceClient.getCurrentGroupName() : null;
    }

    public static void forceDisconnect() {
        if (voiceClient != null) {
            voiceClient.disconnect();
            voiceClient = null;
        }
    }

    private void startListenerPositionUpdater(C_8105098 minecraft) {
        Thread positionUpdater = new Thread(() -> {
            while (voiceClient != null && voiceClient.isConnected()) {
                try {
                    if (minecraft.f_7663840 != null) {
                        float yaw;
                        double x = minecraft.f_7663840.f_6638345;
                        double y = minecraft.f_7663840.f_1187082;
                        double z = minecraft.f_7663840.f_9103758;
                        float pitch = minecraft.f_7663840.f_0243146;
                        for (yaw = minecraft.f_7663840.f_7165431; yaw < 0.0f; yaw += 360.0f) {
                        }
                        while (yaw >= 360.0f) {
                            yaw -= 360.0f;
                        }
                        voiceClient.updateListenerPosition(x, y, z, yaw, pitch);
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Error updating listener position: " + e.getMessage());
                }
            }
        }, "VoiceListenerPositionUpdater");
        positionUpdater.setDaemon(true);
        positionUpdater.start();
    }
}

