/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.events;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.unmapped.C_9590849;

public class ClientEvents {
    public static ClientEvents INSTANCE;
    private final List<Runnable> inputEvents;
    private final List<Consumer<Float>> renderHUDEvents;
    private final List<RenderPlayerIconCallback> renderPlayerIconEvents = new ArrayList<RenderPlayerIconCallback>();

    public ClientEvents() {
        INSTANCE = this;
        this.inputEvents = new ArrayList<Runnable>();
        this.renderHUDEvents = new ArrayList<Consumer<Float>>();
    }

    public void onInput() {
        this.inputEvents.forEach(Runnable::run);
    }

    public void registerKeyBindsEvent(Runnable onHandleKeyBinds) {
        this.inputEvents.add(onHandleKeyBinds);
    }

    public void onRenderHUD(float tickDelta) {
        this.renderHUDEvents.forEach(callback -> callback.accept(Float.valueOf(tickDelta)));
    }

    public void registerRenderHUDEvent(Consumer<Float> renderHUDEvent) {
        this.renderHUDEvents.add(renderHUDEvent);
    }

    public void onRenderPlayerIcons(C_9590849 player, double d, double e, double f) {
        this.renderPlayerIconEvents.forEach(cb -> cb.render(player, d, e, f));
    }

    public void registerRenderPlayerIconsEvent(RenderPlayerIconCallback callback) {
        this.renderPlayerIconEvents.add(callback);
    }

    @FunctionalInterface
    public static interface RenderPlayerIconCallback {
        public void render(C_9590849 var1, double var2, double var4, double var6);
    }
}

