/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.client.init.Voice;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.widget.VoiceSliderWidget;
import com.moyettes.voice.utils.MinecraftAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9590849;
import org.lwjgl.input.Mouse;

public class PlayersScreen
extends BaseVoiceScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int NAME_WIDTH = 70;
    private static final int SLIDER_HEIGHT = 20;
    private final Map<String, Double> playerNameToVolume = new HashMap<String, Double>();
    private final List<PlayerEntry> entries = new ArrayList<PlayerEntry>();
    private int scrollOffset = 0;

    @Override
    protected void initContent() {
        this.buildPlayerEntries();
    }

    @Override
    protected void renderContent(int mouseX, int mouseY, float tickDelta) {
        int wheel = Mouse.getDWheel();
        if (wheel != 0) {
            int backgroundY = (this.f_2141163 - this.backgroundHeight) / 2;
            int contentTop = backgroundY + 24;
            int contentBottom = backgroundY + this.backgroundHeight - 36;
            int contentHeight = contentBottom - contentTop;
            int maxScroll = Math.max(0, this.entries.size() * 24 - contentHeight);
            this.scrollOffset -= (int)Math.signum(wheel) * 16;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > maxScroll) {
                this.scrollOffset = maxScroll;
            }
        }
        this.layoutAndRenderEntries(mouseX, mouseY, tickDelta);
    }

    @Override
    protected C_0561170 getBackgroundTexture() {
        return new C_0561170("legacyvoicechat", "textures/gui/players.png");
    }

    @Override
    protected String getTitle() {
        return "Players";
    }

    @Override
    protected void handleCustomButtonClick(C_2348249 button) {
    }

    private void buildPlayerEntries() {
        this.entries.clear();
        ArrayList toKeep = new ArrayList();
        for (Object o : this.f_9855393) {
            if (!(o instanceof C_2348249)) continue;
            C_2348249 b = (C_2348249)o;
            if (b.f_5920996 != 3000 && b.f_5920996 != 3001 && b.f_5920996 != 3002) continue;
            toKeep.add(o);
        }
        this.f_9855393.clear();
        for (Object o : toKeep) {
            this.f_9855393.add(o);
        }
        C_8105098 mc = MinecraftAccessor.getMinecraft();
        if (mc == null || mc.f_4601986 == null) {
            return;
        }
        int backgroundX = (this.f_2753897 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_2141163 - this.backgroundHeight) / 2;
        int contentTop = backgroundY + 24;
        int sliderX = backgroundX + 10 + 70 + 4;
        int sliderWidth = this.backgroundWidth - 90;
        VoiceClient vc = Voice.getVoiceClient();
        String currentPlayerName = mc.f_7663840 != null ? mc.f_7663840.m_6689989() : null;
        for (Object obj : mc.f_4601986.f_5515055) {
            C_9590849 p;
            if (!(obj instanceof C_9590849) || (p = (C_9590849)obj).m_6689989() == null || p.m_6689989().equals(currentPlayerName)) continue;
            float initialVolume = 1.0f;
            if (vc != null) {
                initialVolume = vc.getPlayerVolume(p.m_6689989());
            }
            float sliderValue = initialVolume / 2.0f;
            VoiceSliderWidget slider = new VoiceSliderWidget(4000 + this.entries.size(), sliderX, contentTop + this.entries.size() * 24, sliderWidth, 20, p.m_6689989() + ": " + Math.round(initialVolume * 100.0f) + "%", sliderValue);
            this.f_9855393.add(slider);
            this.entries.add(new PlayerEntry(p.m_6689989(), slider));
        }
    }

    private void layoutAndRenderEntries(int mouseX, int mouseY, float tickDelta) {
        int backgroundX = (this.f_2753897 - this.backgroundWidth) / 2;
        int backgroundY = (this.f_2141163 - this.backgroundHeight) / 2;
        int contentTop = backgroundY + 24;
        int contentBottom = backgroundY + this.backgroundHeight - 36;
        int sliderX = backgroundX + 5 + 70 + 4;
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean visible;
            PlayerEntry e = this.entries.get(i);
            int rowY = contentTop + i * 24 - this.scrollOffset;
            e.slider.f_5773839 = visible = rowY + 20 > contentTop && rowY < contentBottom;
            e.slider.f_3923091 = sliderX;
            e.slider.f_8532347 = rowY;
            if (!visible) continue;
            double vol = Math.max(0.0, Math.min(2.0, (double)e.slider.value * 2.0));
            this.playerNameToVolume.put(e.playerName, vol);
            e.slider.f_4215674 = (int)Math.round(vol * 100.0) + "%";
            VoiceClient vc = Voice.getVoiceClient();
            if (vc != null) {
                vc.setPlayerVolume(e.playerName, (float)vol);
            }
            this.f_0492613.m_4683674(e.playerName, backgroundX + 10, rowY + 6, 0xFFFFFF);
        }
    }

    private static class PlayerEntry {
        final String playerName;
        final VoiceSliderWidget slider;

        PlayerEntry(String playerName, VoiceSliderWidget slider) {
            this.playerName = playerName;
            this.slider = slider;
        }
    }
}

