/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.server.init;

import com.moyettes.voice.packet.VoiceModSupportedPayload;
import com.moyettes.voice.packet.VoiceServerInfoPayload;
import com.moyettes.voice.server.VoiceServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.unmapped.C_3292284;
import net.ornithemc.osl.entrypoints.api.server.ServerModInitializer;
import net.ornithemc.osl.networking.api.CustomPayload;
import net.ornithemc.osl.networking.api.server.ServerConnectionEvents;
import net.ornithemc.osl.networking.api.server.ServerPlayNetworking;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Voice
implements ServerModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Voice Mod");
    private static VoiceServer voiceServer;
    private static final Map<Integer, String> playerAuthTokens;

    public void initServer() {
        LOGGER.info("Initializing voice mod!");
        try {
            voiceServer = new VoiceServer();
            voiceServer.start();
            LOGGER.info("Voice server started on port " + voiceServer.getPort() + " (from config)");
        }
        catch (IOException e) {
            LOGGER.error("Failed to start voice server: " + e.getMessage());
        }
        this.registerNetworkListeners();
    }

    private void registerNetworkListeners() {
        ServerPlayNetworking.registerListener((String)"voice|mod_supported", VoiceModSupportedPayload::new, (server, handler, player, payload) -> {
            LOGGER.info("Player " + player.m_6689989() + " supports voice mod with protocol " + payload.getProtocolVersion());
            String authToken = this.generateAuthToken(player.m_6689989());
            LOGGER.info("Generated auth token for player " + player.m_6689989() + " (network ID: " + player.m_3843079() + "): " + authToken);
            playerAuthTokens.put(player.m_3843079(), authToken);
            String serverHost = this.getServerHost();
            VoiceServerInfoPayload serverInfo = new VoiceServerInfoPayload(voiceServer.getPort(), authToken, voiceServer.getProtocolVersion(), serverHost);
            ServerPlayNetworking.send((C_3292284)player, (String)"voice|server_info", (CustomPayload)serverInfo);
            LOGGER.info("Sent voice server info to " + player.m_6689989());
            return false;
        });
        ServerConnectionEvents.DISCONNECT.register((handler, player) -> {
            if (voiceServer != null) {
                voiceServer.disconnectPlayer(player.m_3843079());
            }
            playerAuthTokens.remove(player.m_3843079());
        });
    }

    private String generateAuthToken(String playerName) {
        return "token_" + playerName + "_" + System.currentTimeMillis();
    }

    private String getServerHost() {
        return voiceServer.getConfig().getServerHost();
    }

    public static VoiceServer getVoiceServer() {
        return voiceServer;
    }

    public static String getPlayerAuthToken(Integer playerNetworkId) {
        return playerAuthTokens.get(playerNetworkId);
    }

    static {
        playerAuthTokens = new HashMap<Integer, String>();
    }
}

