/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.sound;

import java.util.concurrent.ConcurrentHashMap;

public class Simple3DAudio {
    private final ConcurrentHashMap<Integer, PlayerAudioSource> playerSources = new ConcurrentHashMap();
    public double listenerX = 0.0;
    public double listenerY = 0.0;
    public double listenerZ = 0.0;
    public float listenerYaw = 0.0f;
    public float listenerPitch = 0.0f;

    public boolean initialize() {
        System.out.println("Simple 3D audio system initialized");
        return true;
    }

    public PlayerAudioSource getOrCreatePlayerSource(Integer playerId) {
        return this.playerSources.computeIfAbsent(playerId, id -> {
            System.out.println("Created audio source for player " + id);
            return new PlayerAudioSource();
        });
    }

    public void updateListener(double x, double y, double z, float yaw, float pitch) {
        this.listenerX = x;
        this.listenerY = y;
        this.listenerZ = z;
        this.listenerYaw = yaw;
        this.listenerPitch = pitch;
    }

    public void playPlayerAudio(Integer playerId, byte[] audioData, double playerX, double playerY, double playerZ, float volume) {
        PlayerAudioSource source = this.getOrCreatePlayerSource(playerId);
        if (source != null) {
            byte[] positionedAudio = this.calculateStereoPositioning(audioData, playerX, playerY, playerZ, volume);
            source.playAudio(positionedAudio);
        }
    }

    private byte[] calculateStereoPositioning(byte[] audioData, double playerX, double playerY, double playerZ, float volume) {
        double angle;
        double deltaX = playerX - this.listenerX;
        double deltaZ = playerZ - this.listenerZ;
        double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        for (angle = Math.atan2(deltaZ, deltaX) - Math.toRadians(this.listenerYaw); angle > Math.PI; angle -= Math.PI * 2) {
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        float pan = (float)Math.sin(angle);
        float stereoWidth = (float)Math.max(0.1, Math.min(1.0, 10.0 / Math.max(1.0, distance)));
        return this.applyStereoPanning(audioData, pan *= stereoWidth, volume);
    }

    private byte[] applyStereoPanning(byte[] audioData, float pan, float volume) {
        if (Math.abs(pan) < 0.01f) {
            return this.duplicateMonoToStereo(audioData, volume);
        }
        byte[] stereoAudio = new byte[audioData.length * 2];
        for (int i = 0; i < audioData.length; i += 2) {
            if (i + 1 >= audioData.length) continue;
            short sample = (short)(audioData[i + 1] << 8 | audioData[i] & 0xFF);
            sample = (short)((float)sample * volume);
            float leftGain = (float)Math.sqrt((1.0f - pan) / 2.0f);
            float rightGain = (float)Math.sqrt((1.0f + pan) / 2.0f);
            short leftSample = (short)((float)sample * leftGain);
            short rightSample = (short)((float)sample * rightGain);
            int stereoIndex = i / 2 * 4;
            stereoAudio[stereoIndex] = (byte)(leftSample & 0xFF);
            stereoAudio[stereoIndex + 1] = (byte)(leftSample >> 8 & 0xFF);
            stereoAudio[stereoIndex + 2] = (byte)(rightSample & 0xFF);
            stereoAudio[stereoIndex + 3] = (byte)(rightSample >> 8 & 0xFF);
        }
        return stereoAudio;
    }

    private byte[] duplicateMonoToStereo(byte[] monoAudio, float volume) {
        byte[] stereoAudio = new byte[monoAudio.length * 2];
        for (int i = 0; i < monoAudio.length; i += 2) {
            if (i + 1 >= monoAudio.length) continue;
            short sample = (short)(monoAudio[i + 1] << 8 | monoAudio[i] & 0xFF);
            sample = (short)((float)sample * volume);
            int stereoIndex = i / 2 * 4;
            stereoAudio[stereoIndex] = (byte)(sample & 0xFF);
            stereoAudio[stereoIndex + 1] = (byte)(sample >> 8 & 0xFF);
            stereoAudio[stereoIndex + 2] = (byte)(sample & 0xFF);
            stereoAudio[stereoIndex + 3] = (byte)(sample >> 8 & 0xFF);
        }
        return stereoAudio;
    }

    public void removePlayerSource(Integer playerId) {
        PlayerAudioSource source = this.playerSources.remove(playerId);
        if (source != null) {
            source.cleanup();
        }
    }

    public boolean isInitialized() {
        return true;
    }

    public void cleanup() {
        for (PlayerAudioSource source : this.playerSources.values()) {
            if (source == null) continue;
            source.cleanup();
        }
        this.playerSources.clear();
    }

    public static class PlayerAudioSource {
        public void playAudio(byte[] audioData) {
        }

        public void cleanup() {
        }
    }
}

