/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GroupCreatePacket
extends UdpPacket {
    private String groupName;
    private String password;

    public GroupCreatePacket() {
        super(UdpPacket.PacketType.GROUP_CREATE);
    }

    public GroupCreatePacket(String groupName, String password) {
        super(UdpPacket.PacketType.GROUP_CREATE);
        this.groupName = groupName;
        this.password = password;
    }

    @Override
    protected void writeData(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.groupName != null ? this.groupName : "");
        dos.writeBoolean(this.password != null);
        if (this.password != null) {
            dos.writeUTF(this.password);
        }
    }

    public static GroupCreatePacket read(DataInputStream dis) throws IOException {
        GroupCreatePacket packet = new GroupCreatePacket();
        packet.groupName = dis.readUTF();
        boolean hasPassword = dis.readBoolean();
        packet.password = hasPassword ? dis.readUTF() : null;
        return packet;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isPublic() {
        return this.password == null || this.password.isEmpty();
    }
}

