/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.GroupCreatePacket;
import com.moyettes.voice.udp.GroupDataPacket;
import com.moyettes.voice.udp.GroupJoinPacket;
import com.moyettes.voice.udp.GroupLeavePacket;
import com.moyettes.voice.udp.GroupListPacket;
import com.moyettes.voice.udp.GroupMemberUpdatePacket;
import com.moyettes.voice.udp.PingPacket;
import com.moyettes.voice.udp.PresenceBulkPacket;
import com.moyettes.voice.udp.PresenceUpdatePacket;
import com.moyettes.voice.udp.VoiceDataPacket;
import com.moyettes.voice.udp.VoiceDataRelayPacket;
import com.moyettes.voice.udp.VoiceHandshakeAckPacket;
import com.moyettes.voice.udp.VoiceHandshakePacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class UdpPacket {
    private final PacketType type;

    protected UdpPacket(PacketType type) {
        this.type = type;
    }

    public PacketType getType() {
        return this.type;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(this.type.getId());
        this.writeData(dos);
        return baos.toByteArray();
    }

    public static UdpPacket fromBytes(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IOException("Cannot parse null or empty packet data");
        }
        if (data.length < 1) {
            throw new IOException("Packet too short to contain type byte");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        byte typeId = dis.readByte();
        PacketType type = PacketType.fromId(typeId);
        if (type == null) {
            throw new IOException("Unknown packet type ID: " + typeId);
        }
        switch (type.ordinal()) {
            case 0: {
                return VoiceHandshakePacket.read(dis);
            }
            case 1: {
                return VoiceHandshakeAckPacket.read(dis);
            }
            case 2: {
                return VoiceDataPacket.read(dis);
            }
            case 3: {
                return VoiceDataRelayPacket.read(dis);
            }
            case 4: {
                return GroupCreatePacket.read(dis);
            }
            case 5: {
                return GroupJoinPacket.read(dis);
            }
            case 6: {
                return GroupLeavePacket.read(dis);
            }
            case 7: {
                return GroupListPacket.read(dis);
            }
            case 8: {
                return GroupDataPacket.read(dis);
            }
            case 9: {
                return GroupMemberUpdatePacket.read(dis);
            }
            case 10: {
                return PingPacket.read(dis);
            }
            case 11: {
                return PresenceUpdatePacket.read(dis);
            }
            case 12: {
                return PresenceBulkPacket.read(dis);
            }
        }
        throw new IllegalArgumentException("Unknown packet type: " + (Object)((Object)type));
    }

    protected abstract void writeData(DataOutputStream var1) throws IOException;

    public static enum PacketType {
        VOICE_HANDSHAKE(1),
        VOICE_HANDSHAKE_ACK(2),
        VOICE_DATA(3),
        VOICE_DATA_RELAY(4),
        GROUP_CREATE(5),
        GROUP_JOIN(6),
        GROUP_LEAVE(7),
        GROUP_LIST(8),
        GROUP_DATA(9),
        GROUP_MEMBER_UPDATE(10),
        PING(11),
        PRESENCE_UPDATE(12),
        PRESENCE_BULK(13);

        private final int id;

        private PacketType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static PacketType fromId(int id) {
            for (PacketType type : PacketType.values()) {
                if (type.id != id) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown packet type: " + id);
        }
    }
}

