/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class VoiceDataPacket
extends UdpPacket {
    private Integer playerNetworkId;
    private byte[] audioData;
    private long sequenceNumber;

    public VoiceDataPacket() {
        super(UdpPacket.PacketType.VOICE_DATA);
    }

    public VoiceDataPacket(Integer playerNetworkId, byte[] audioData, long sequenceNumber) {
        super(UdpPacket.PacketType.VOICE_DATA);
        this.playerNetworkId = playerNetworkId;
        this.audioData = audioData;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    protected void writeData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.playerNetworkId);
        dos.writeLong(this.sequenceNumber);
        dos.writeInt(this.audioData.length);
        dos.write(this.audioData);
    }

    public static VoiceDataPacket read(DataInputStream dis) throws IOException {
        VoiceDataPacket packet = new VoiceDataPacket();
        packet.playerNetworkId = dis.readInt();
        packet.sequenceNumber = dis.readLong();
        int dataLength = dis.readInt();
        if (dataLength < 0 || dataLength > 1024) {
            throw new IOException("Invalid audio data length: " + dataLength);
        }
        packet.audioData = new byte[dataLength];
        try {
            dis.readFully(packet.audioData);
        }
        catch (EOFException e) {
            throw new IOException("Insufficient data in packet: expected " + dataLength + " bytes", e);
        }
        return packet;
    }

    public Integer getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public byte[] getAudioData() {
        return this.audioData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

