/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.udp;

import com.moyettes.voice.udp.UdpPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GroupDataPacket
extends UdpPacket {
    private String groupName;
    private Integer fromPlayerNetworkId;
    private byte[] audioData;
    private long sequenceNumber;
    private List<Integer> targetPlayerIds;

    public GroupDataPacket() {
        super(UdpPacket.PacketType.GROUP_DATA);
        this.targetPlayerIds = new ArrayList<Integer>();
    }

    public GroupDataPacket(String groupName, Integer fromPlayerNetworkId, byte[] audioData, long sequenceNumber, List<Integer> targetPlayerIds) {
        super(UdpPacket.PacketType.GROUP_DATA);
        this.groupName = groupName;
        this.fromPlayerNetworkId = fromPlayerNetworkId;
        this.audioData = audioData;
        this.sequenceNumber = sequenceNumber;
        this.targetPlayerIds = targetPlayerIds != null ? targetPlayerIds : new ArrayList();
    }

    @Override
    protected void writeData(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.groupName != null ? this.groupName : "");
        dos.writeInt(this.fromPlayerNetworkId);
        dos.writeLong(this.sequenceNumber);
        dos.writeInt(this.targetPlayerIds.size());
        for (Integer playerId : this.targetPlayerIds) {
            dos.writeInt(playerId);
        }
        dos.writeInt(this.audioData.length);
        dos.write(this.audioData);
    }

    public static GroupDataPacket read(DataInputStream dis) throws IOException {
        GroupDataPacket packet = new GroupDataPacket();
        packet.groupName = dis.readUTF();
        packet.fromPlayerNetworkId = dis.readInt();
        packet.sequenceNumber = dis.readLong();
        int targetCount = dis.readInt();
        for (int i = 0; i < targetCount; ++i) {
            packet.targetPlayerIds.add(dis.readInt());
        }
        int dataLength = dis.readInt();
        if (dataLength < 0 || dataLength > 1024) {
            throw new IOException("Invalid audio data length: " + dataLength);
        }
        packet.audioData = new byte[dataLength];
        try {
            dis.readFully(packet.audioData);
        }
        catch (EOFException e) {
            throw new IOException("Insufficient data in packet: expected " + dataLength + " bytes", e);
        }
        return packet;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getFromPlayerNetworkId() {
        return this.fromPlayerNetworkId;
    }

    public byte[] getAudioData() {
        return this.audioData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public List<Integer> getTargetPlayerIds() {
        return this.targetPlayerIds;
    }
}

