/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.api.events;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class Event<T> {
    private final List<T> listeners = new ArrayList<T>();
    private final Function<List<T>, T> invokerFactory;
    private T invoker;

    private Event(Function<List<T>, T> function) {
        this.invokerFactory = function;
    }

    public static <T> Event<T> of(Function<List<T>, T> function) {
        return new Event<T>(function);
    }

    public static <T> Event<Consumer<T>> consumer() {
        return Event.of(list -> object -> list.forEach(consumer -> consumer.accept(object)));
    }

    public static <T, U> Event<BiConsumer<T, U>> biConsumer() {
        return Event.of(list -> (object, object2) -> list.forEach(biConsumer -> biConsumer.accept(object, object2)));
    }

    public void register(T t) {
        this.listeners.add(t);
        if (this.invoker != null) {
            this.invoker = null;
        }
    }

    public T invoker() {
        if (this.invoker == null) {
            this.invoker = this.invokerFactory.apply(this.listeners);
        }
        return this.invoker;
    }
}

