/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class AdaptiveJitterBuffer {
    private final long packetDelayMillis;
    private final Queue<BufferedPacket> queue;
    private long firstPacketArrival = -1L;
    private long firstSequenceNumber = -1L;
    private long lastPacketArrival = -1L;
    private double jitterEstimate = 0.0;
    private long adaptiveDelayMillis;

    public AdaptiveJitterBuffer(int n) {
        this.adaptiveDelayMillis = this.packetDelayMillis = (long)n * 20L;
        this.queue = n <= 1 ? new LinkedBlockingQueue<BufferedPacket>() : new PriorityBlockingQueue<BufferedPacket>(n * 2, (bufferedPacket, bufferedPacket2) -> Long.compare(bufferedPacket.sequenceNumber, bufferedPacket2.sequenceNumber));
    }

    public void offer(byte[] byArray, Integer n, long l, double d, float f, double d2, double d3, double d4) {
        long l2 = System.currentTimeMillis();
        if (this.lastPacketArrival != -1L) {
            long l3 = l2 - this.lastPacketArrival;
            long l4 = Math.abs(l3 - 20L);
            this.jitterEstimate += ((double)l4 - this.jitterEstimate) / 16.0;
            this.adaptiveDelayMillis = Math.round(this.jitterEstimate / 20.0) * 20L;
        }
        this.lastPacketArrival = l2;
        if (this.firstSequenceNumber == -1L) {
            this.firstPacketArrival = l2;
            this.firstSequenceNumber = l;
        }
        BufferedPacket bufferedPacket = new BufferedPacket(byArray, l, d, f, d2, d3, d4, l2, this.calculateScheduledPlaybackTime(l, l2));
        this.queue.offer(bufferedPacket);
    }

    private long calculateScheduledPlaybackTime(long l, long l2) {
        if (this.firstSequenceNumber == -1L) {
            return l2 + this.packetDelayMillis;
        }
        long l3 = l - this.firstSequenceNumber;
        return this.firstPacketArrival + this.packetDelayMillis + l3 * 20L;
    }

    public BufferedPacket poll() {
        return this.queue.poll();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void reset() {
        this.queue.clear();
        this.firstSequenceNumber = -1L;
        this.firstPacketArrival = -1L;
        this.lastPacketArrival = -1L;
        this.jitterEstimate = 0.0;
        this.adaptiveDelayMillis = this.packetDelayMillis;
    }

    public static class BufferedPacket {
        public final byte[] audioData;
        public final long sequenceNumber;
        public final double distance;
        public final float volume;
        public final double playerX;
        public final double playerY;
        public final double playerZ;
        public final long arrivalTime;
        public final long scheduledPlaybackTime;

        public BufferedPacket(byte[] byArray, long l, double d, float f, double d2, double d3, double d4, long l2, long l3) {
            this.audioData = byArray;
            this.sequenceNumber = l;
            this.distance = d;
            this.volume = f;
            this.playerX = d2;
            this.playerY = d3;
            this.playerZ = d4;
            this.arrivalTime = l2;
            this.scheduledPlaybackTime = l3;
        }
    }
}

