/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio;

import java.util.function.Consumer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class MicrophoneCapture
implements Runnable {
    private static final float SAMPLE_RATE = 48000.0f;
    private static final int SAMPLE_SIZE_IN_BITS = 16;
    private static final int CHANNELS = 1;
    private static final boolean BIG_ENDIAN = false;
    private TargetDataLine microphone;
    private volatile boolean running;
    private Thread captureThread;
    private Consumer<byte[]> audioDataConsumer;
    private String preferredDeviceName;

    public MicrophoneCapture(Consumer<byte[]> consumer) {
        this(consumer, null);
    }

    public MicrophoneCapture(Consumer<byte[]> consumer, String string) {
        this.audioDataConsumer = consumer;
        this.preferredDeviceName = string;
    }

    public boolean startCapture() {
        if (this.running) {
            return true;
        }
        try {
            Mixer.Info[] infoArray;
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                mod_Voice.LOGGER.warn("Audio format not supported");
                return false;
            }
            if (this.preferredDeviceName != null && !this.preferredDeviceName.isEmpty() && !"Default".equals(this.preferredDeviceName)) {
                infoArray = AudioSystem.getMixerInfo();
                TargetDataLine targetDataLine = null;
                for (Mixer.Info info2 : infoArray) {
                    if (!this.preferredDeviceName.equals(info2.getName())) continue;
                    try {
                        Mixer mixer = AudioSystem.getMixer(info2);
                        Line.Info info3 = new Line.Info(TargetDataLine.class);
                        targetDataLine = (TargetDataLine)mixer.getLine(info3);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (targetDataLine != null) {
                    this.microphone = targetDataLine;
                }
            }
            if (this.microphone == null) {
                infoArray = new DataLine.Info(TargetDataLine.class, null);
                this.microphone = (TargetDataLine)AudioSystem.getLine((Line.Info)infoArray);
            }
            int n = 61440;
            this.microphone.open(audioFormat, n);
            this.microphone.start();
            this.running = true;
            this.captureThread = new Thread((Runnable)this, "MicrophoneCaptureThread");
            this.captureThread.setDaemon(true);
            this.captureThread.start();
            return true;
        }
        catch (LineUnavailableException lineUnavailableException) {
            mod_Voice.LOGGER.warn("Microphone line unavailable: " + lineUnavailableException.getMessage());
            return false;
        }
    }

    public void stopCapture() {
        this.running = false;
        if (this.captureThread != null) {
            try {
                this.captureThread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        mod_Voice.LOGGER.info("Microphone capture stopped.");
    }

    public void close() {
        this.stopCapture();
        if (this.microphone != null) {
            this.microphone.stop();
            this.microphone.close();
            this.microphone = null;
            mod_Voice.LOGGER.info("Microphone closed.");
        }
    }

    @Override
    public void run() {
        byte[] byArray = new byte[1920];
        int n = 0;
        byte[] byArray2 = new byte[4096];
        mod_Voice.LOGGER.info("Audio capture thread started");
        while (this.running) {
            try {
                int n2 = this.microphone.read(byArray2, 0, byArray2.length);
                if (n2 <= 0) continue;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = 1920 - n;
                    int n5 = Math.min(n4, n2 - n3);
                    System.arraycopy(byArray2, n3, byArray, n, n5);
                    n3 += n5;
                    if ((n += n5) != 1920) continue;
                    if (this.audioDataConsumer != null) {
                        byte[] byArray3 = new byte[1920];
                        System.arraycopy(byArray, 0, byArray3, 0, 1920);
                        this.audioDataConsumer.accept(byArray3);
                    }
                    n = 0;
                }
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Error in audio capture: " + exception.getMessage());
                break;
            }
        }
    }
}

