/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class OpenALAudioPlayback {
    private static final int NUM_BUFFERS = 32;
    private static final int SAMPLE_RATE = 48000;
    private int source;
    private int[] bufferIds = new int[32];
    private int[] freeBuffers = new int[32];
    private int freeBufferCount = 0;
    private volatile boolean initialized = false;

    public boolean initialize() {
        if (this.initialized) {
            return true;
        }
        try {
            int n;
            if (!AL.isCreated()) {
                try {
                    AL.create();
                    mod_Voice.LOGGER.info("OpenAL context created for playback thread");
                }
                catch (LWJGLException lWJGLException) {
                    mod_Voice.LOGGER.warn("Failed to create OpenAL context on playback thread: " + lWJGLException.getMessage());
                    return false;
                }
            }
            this.source = AL10.alGenSources();
            if (this.source == 0) {
                mod_Voice.LOGGER.warn("Failed to create OpenAL source - alGenSources returned 0");
                return false;
            }
            int n2 = AL10.alGetError();
            if (n2 != 0) {
                mod_Voice.LOGGER.warn("Failed to create OpenAL source - AL error: " + this.getErrorString(n2) + " (0x" + Integer.toHexString(n2) + ")");
                return false;
            }
            AL10.alSourcei((int)this.source, (int)4103, (int)0);
            AL10.alSourcef((int)this.source, (int)4099, (float)1.0f);
            AL10.alSourcef((int)this.source, (int)4106, (float)1.0f);
            AL10.alSource3f((int)this.source, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSource3f((int)this.source, (int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSourcei((int)this.source, (int)514, (int)1);
            n2 = AL10.alGetError();
            if (n2 != 0) {
                this.cleanup();
                mod_Voice.LOGGER.warn("Failed to configure OpenAL source - AL error: " + this.getErrorString(n2) + " (0x" + Integer.toHexString(n2) + ")");
                return false;
            }
            for (n = 0; n < 32; ++n) {
                this.bufferIds[n] = AL10.alGenBuffers();
            }
            n2 = AL10.alGetError();
            if (n2 != 0) {
                this.cleanup();
                mod_Voice.LOGGER.warn("Failed to create OpenAL buffers - AL error: " + this.getErrorString(n2) + " (0x" + Integer.toHexString(n2) + ")");
                return false;
            }
            for (n = 0; n < 32; ++n) {
                this.freeBuffers[n] = this.bufferIds[n];
            }
            this.freeBufferCount = 32;
            this.initialized = true;
            mod_Voice.LOGGER.info("OpenAL audio playback initialized successfully");
            return true;
        }
        catch (Exception exception) {
            mod_Voice.LOGGER.warn("Failed to initialize OpenAL: " + exception.getMessage());
            exception.printStackTrace();
            this.cleanup();
            return false;
        }
    }

    private String getErrorString(int n) {
        switch (n) {
            case 40961: {
                return "AL_INVALID_NAME";
            }
            case 40962: {
                return "AL_INVALID_ENUM";
            }
            case 40963: {
                return "AL_INVALID_VALUE";
            }
            case 40964: {
                return "AL_INVALID_OPERATION";
            }
            case 40965: {
                return "AL_OUT_OF_MEMORY";
            }
        }
        return "UNKNOWN_ERROR";
    }

    public void writeAudioDirect(byte[] byArray) {
        int n;
        int n2;
        boolean bl;
        if (!this.initialized || byArray == null || byArray.length == 0) {
            return;
        }
        this.removeProcessedBuffers();
        int n3 = AL10.alGetSourcei((int)this.source, (int)4112);
        int n4 = AL10.alGetSourcei((int)this.source, (int)4117);
        int n5 = AL10.alGetSourcei((int)this.source, (int)4118);
        int n6 = n4 - n5;
        boolean bl2 = bl = n3 == 4113 || n3 == 4116 || n6 <= 1;
        if (bl) {
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i < 8; ++i) {
                n2 = this.getFreeBuffer();
                if (n2 == 0) {
                    this.removeProcessedBuffers();
                    n2 = this.getFreeBuffer();
                    if (n2 == 0) break;
                }
                ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)byArray2.length);
                byteBuffer.put(byArray2);
                byteBuffer.flip();
                AL10.alBufferData((int)n2, (int)4355, (ByteBuffer)byteBuffer, (int)48000);
                if (AL10.alGetError() == 0) {
                    AL10.alSourceQueueBuffers((int)this.source, (int)n2);
                    continue;
                }
                this.returnFreeBuffer(n2);
            }
        }
        if ((n4 = AL10.alGetSourcei((int)this.source, (int)4117)) >= 32) {
            mod_Voice.LOGGER.warn("Buffer overflow detected: " + n4 + "/" + 32 + " - skipping packets");
            this.removeProcessedBuffers();
            if (this.getFreeBuffer() == 0) {
                return;
            }
        }
        if ((n = this.getFreeBuffer()) == 0) {
            this.removeProcessedBuffers();
            n = this.getFreeBuffer();
            if (n == 0) {
                return;
            }
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        AL10.alBufferData((int)n, (int)4355, (ByteBuffer)byteBuffer, (int)48000);
        n2 = AL10.alGetError();
        if (n2 != 0) {
            mod_Voice.LOGGER.warn("Failed to buffer audio data: " + this.getErrorString(n2));
            this.returnFreeBuffer(n);
            return;
        }
        AL10.alSourceQueueBuffers((int)this.source, (int)n);
        n2 = AL10.alGetError();
        if (n2 != 0) {
            mod_Voice.LOGGER.warn("Failed to queue buffer: " + this.getErrorString(n2));
            return;
        }
        n3 = AL10.alGetSourcei((int)this.source, (int)4112);
        if (n3 != 4114) {
            AL10.alSourcePlay((int)this.source);
        }
    }

    private int getFreeBuffer() {
        if (this.freeBufferCount > 0) {
            return this.freeBuffers[--this.freeBufferCount];
        }
        return 0;
    }

    private void returnFreeBuffer(int n) {
        if (this.freeBufferCount < 32) {
            this.freeBuffers[this.freeBufferCount++] = n;
        }
    }

    private void removeProcessedBuffers() {
        for (int i = AL10.alGetSourcei((int)this.source, (int)4118); i > 0; --i) {
            int n = AL10.alSourceUnqueueBuffers((int)this.source);
            this.returnFreeBuffer(n);
        }
    }

    public void close() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.source != 0) {
            try {
                AL10.alSourceStop((int)this.source);
                this.removeProcessedBuffers();
                AL10.alDeleteSources((int)this.source);
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Error during OpenAL source cleanup: " + exception.getMessage());
            }
            this.source = 0;
        }
        if (this.bufferIds != null) {
            for (int i = 0; i < this.bufferIds.length; ++i) {
                if (this.bufferIds[i] == 0) continue;
                try {
                    AL10.alDeleteBuffers((int)this.bufferIds[i]);
                }
                catch (Exception exception) {
                    mod_Voice.LOGGER.warn("Error deleting OpenAL buffer " + i + ": " + exception.getMessage());
                }
                this.bufferIds[i] = 0;
            }
        }
        if (AL.isCreated()) {
            try {
                AL.destroy();
                mod_Voice.LOGGER.info("OpenAL context destroyed for playback thread");
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Error destroying OpenAL context: " + exception.getMessage());
            }
        }
        this.initialized = false;
        mod_Voice.LOGGER.info("OpenAL audio playback closed");
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

