/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio;

import com.moyettes.voice.audio.AudioProcessor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class StereoAudioPlayback
implements Runnable {
    private static final int SAMPLE_SIZE_IN_BITS = 16;
    private static final int CHANNELS = 2;
    private static final boolean BIG_ENDIAN = false;
    private int sampleRate = 48000;
    private int stereoFrameBytes = 3840;
    private int bufferSize = this.stereoFrameBytes * 16;
    private SourceDataLine speaker;
    private volatile boolean running;
    private Thread playbackThread;
    private BlockingQueue<byte[]> audioQueue = new LinkedBlockingQueue<byte[]>(100);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private String outputDeviceName;

    public StereoAudioPlayback() {
        this(null);
    }

    public StereoAudioPlayback(String string) {
        this.outputDeviceName = string;
    }

    public boolean initialize() {
        if (this.initialized.get()) {
            return true;
        }
        try {
            try {
                this.sampleRate = AudioProcessor.getSampleRate();
            }
            catch (Throwable throwable) {
                this.sampleRate = 48000;
            }
            this.stereoFrameBytes = this.sampleRate / 1000 * 2 * 20 * 2;
            this.bufferSize = this.stereoFrameBytes * 16;
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 16, 2, 4, this.sampleRate, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                mod_Voice.LOGGER.warn("Stereo audio playback format not supported by system");
                return false;
            }
            if (this.outputDeviceName != null && !this.outputDeviceName.equals("Default")) {
                Mixer.Info[] infoArray;
                for (Mixer.Info info2 : infoArray = AudioSystem.getMixerInfo()) {
                    Mixer mixer;
                    if (!info2.getName().equals(this.outputDeviceName) || !(mixer = AudioSystem.getMixer(info2)).isLineSupported(info)) continue;
                    this.speaker = (SourceDataLine)mixer.getLine(info);
                    this.speaker.open(audioFormat, this.bufferSize);
                    mod_Voice.LOGGER.info("Using output device: " + this.outputDeviceName);
                    break;
                }
            }
            if (this.speaker == null) {
                this.speaker = (SourceDataLine)AudioSystem.getLine(info);
                this.speaker.open(audioFormat, this.bufferSize);
                if (this.outputDeviceName != null && !this.outputDeviceName.equals("Default")) {
                    mod_Voice.LOGGER.warn("Failed to use output device '" + this.outputDeviceName + "', falling back to default");
                }
            }
            if (this.speaker != null) {
                this.initialized.set(true);
                return true;
            }
            mod_Voice.LOGGER.warn("Failed to initialize any audio output device");
            return false;
        }
        catch (LineUnavailableException lineUnavailableException) {
            mod_Voice.LOGGER.warn("Stereo speaker line unavailable: " + lineUnavailableException.getMessage());
            return false;
        }
    }

    public boolean startPlayback() {
        if (!this.initialized.get() && !this.initialize()) {
            return false;
        }
        if (this.running) {
            return true;
        }
        if (this.speaker != null && !this.speaker.isRunning()) {
            try {
                this.speaker.start();
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Failed to start speaker line: " + exception.getMessage());
            }
        }
        this.running = true;
        this.playbackThread = new Thread((Runnable)this, "StereoAudioPlaybackThread");
        this.playbackThread.setDaemon(true);
        this.playbackThread.start();
        return true;
    }

    public void stopPlayback() {
        this.running = false;
        if (this.playbackThread != null) {
            try {
                this.playbackThread.join(100L);
                if (this.playbackThread.isAlive()) {
                    mod_Voice.LOGGER.warn("Audio playback thread did not stop gracefully");
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.speaker != null && this.speaker.isRunning()) {
            try {
                this.speaker.stop();
                this.speaker.flush();
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Error stopping speaker: " + exception.getMessage());
            }
        }
    }

    public void close() {
        this.stopPlayback();
        if (this.speaker != null) {
            try {
                if (this.speaker.isRunning()) {
                    this.speaker.stop();
                }
                this.speaker.flush();
                this.speaker.close();
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (string == null) {
                    string = exception.getClass().getSimpleName();
                }
                mod_Voice.LOGGER.warn("Error closing speaker line: " + string);
            }
            finally {
                this.speaker = null;
                this.initialized.set(false);
            }
        } else {
            this.initialized.set(false);
        }
        if (this.audioQueue != null) {
            this.audioQueue.clear();
        }
    }

    public void clearQueue() {
        if (this.audioQueue != null) {
            this.audioQueue.clear();
        }
    }

    public void flushAudioBuffer() {
        if (this.speaker != null && this.speaker.isRunning()) {
            this.speaker.flush();
        }
    }

    public void queueAudio(byte[] byArray) {
        if (this.running && byArray != null && byArray.length > 0) {
            try {
                if (this.audioQueue.size() > 90) {
                    this.audioQueue.poll();
                }
                if (!this.audioQueue.offer(byArray)) {
                    mod_Voice.LOGGER.warn("Stereo audio queue full, dropping packet");
                }
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Failed to queue stereo audio data: " + exception.getMessage());
            }
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                byte[] byArray = (byte[])this.audioQueue.poll();
                if (this.speaker != null && this.speaker.isOpen()) {
                    if (!this.speaker.isRunning()) {
                        try {
                            this.speaker.start();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (byArray != null && byArray.length > 0) {
                        this.speaker.write(byArray, 0, byArray.length);
                    }
                }
                if (byArray != null) continue;
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            catch (Exception exception) {
                if (!this.running) continue;
                mod_Voice.LOGGER.warn("Error during stereo audio playback: " + exception.getMessage());
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isRunning() {
        return this.running;
    }
}

