/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.codec;

import com.plasmoverse.opus.OpusDecoder;
import com.plasmoverse.opus.OpusException;
import java.io.IOException;

public class NativeOpusDecoder {
    private OpusDecoder decoder;
    private final int sampleRate;
    private final int channels;
    private final int frameSize;
    private boolean initialized = false;

    public NativeOpusDecoder(int n, int n2, boolean bl) {
        this.sampleRate = n;
        this.channels = bl ? 2 : 1;
        this.frameSize = n2;
    }

    public void initialize() {
        try {
            this.decoder = OpusDecoder.create(this.sampleRate, this.channels == 2, this.frameSize);
            this.initialized = true;
            mod_Voice.LOGGER.info("Native Opus decoder initialized successfully");
        }
        catch (OpusException | IOException exception) {
            mod_Voice.LOGGER.warn("Failed to initialize native Opus decoder: " + exception.getMessage());
            this.initialized = false;
        }
    }

    public short[] decode(byte[] byArray) {
        if (!this.initialized || this.decoder == null || byArray == null) {
            return null;
        }
        try {
            return this.decoder.decode(byArray);
        }
        catch (OpusException opusException) {
            mod_Voice.LOGGER.warn("Native Opus decoding failed: " + opusException.getMessage());
            return null;
        }
    }

    public short[] decodeSilence() {
        if (!this.initialized || this.decoder == null) {
            return null;
        }
        try {
            return this.decoder.decode(null);
        }
        catch (OpusException opusException) {
            mod_Voice.LOGGER.warn("Native Opus silence decoding failed: " + opusException.getMessage());
            return null;
        }
    }

    public void reset() {
        if (this.initialized && this.decoder != null) {
            try {
                this.decoder.reset();
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Failed to reset native Opus decoder: " + exception.getMessage());
            }
        }
    }

    public void close() {
        if (this.decoder != null) {
            try {
                this.decoder.close();
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Failed to close native Opus decoder: " + exception.getMessage());
            }
            this.decoder = null;
            this.initialized = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

