/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.codec;

import com.moyettes.voice.audio.codec.OpusMode;
import com.plasmoverse.opus.OpusEncoder;
import com.plasmoverse.opus.OpusException;
import java.io.IOException;
import java.util.Arrays;

public class NativeOpusEncoder {
    private OpusEncoder encoder;
    private final int sampleRate;
    private final int channels;
    private final int mtuSize;
    private boolean initialized = false;

    public NativeOpusEncoder(int n, int n2, boolean bl, OpusMode opusMode) {
        this.sampleRate = n;
        this.channels = bl ? 2 : 1;
        this.mtuSize = n2;
    }

    public void initialize() {
        try {
            com.plasmoverse.opus.OpusMode opusMode2 = Arrays.stream(com.plasmoverse.opus.OpusMode.values()).filter(opusMode -> opusMode.getApplication() == OpusMode.VOIP.getApplication()).findFirst().orElseThrow(() -> new RuntimeException("Invalid opus application mode"));
            this.encoder = OpusEncoder.create(this.sampleRate, this.channels == 2, this.mtuSize, opusMode2);
            this.encoder.setBitrate(-1000);
            this.initialized = true;
            mod_Voice.LOGGER.info("Native Opus encoder initialized successfully with VOIP mode");
        }
        catch (OpusException | IOException exception) {
            mod_Voice.LOGGER.warn("Failed to initialize native Opus encoder: " + exception.getMessage());
            this.initialized = false;
        }
    }

    public byte[] encode(short[] sArray) {
        if (!this.initialized || this.encoder == null) {
            return null;
        }
        try {
            return this.encoder.encode(sArray);
        }
        catch (OpusException opusException) {
            mod_Voice.LOGGER.warn("Native Opus encoding failed: " + opusException.getMessage());
            return null;
        }
    }

    public void setBitrate(int n) {
        if (this.initialized && this.encoder != null) {
            this.encoder.setBitrate(n);
        }
    }

    public int getBitrate() {
        if (this.initialized && this.encoder != null) {
            try {
                return this.encoder.getBitrate();
            }
            catch (OpusException opusException) {
                return 0;
            }
        }
        return 0;
    }

    public void reset() {
        if (this.initialized && this.encoder != null) {
            try {
                this.encoder.reset();
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Failed to reset native Opus encoder: " + exception.getMessage());
            }
        }
    }

    public void close() {
        if (this.encoder != null) {
            try {
                this.encoder.close();
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Failed to close native Opus encoder: " + exception.getMessage());
            }
            this.encoder = null;
            this.initialized = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

