/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.filter;

import com.moyettes.voice.audio.filter.AudioFilter;
import com.moyettes.voice.audio.utils.AudioUtils;

public class GainFilter
implements AudioFilter {
    private float volume;

    public GainFilter(float f) {
        this.volume = f;
    }

    @Override
    public String getName() {
        return "gain";
    }

    @Override
    public short[] process(short[] sArray) {
        if (this.volume == 1.0f) {
            return sArray;
        }
        short s = AudioUtils.getHighestAbsoluteSample(sArray);
        if (s == 0) {
            return sArray;
        }
        float f = 32766.0f / (float)s;
        float f2 = Math.min(this.volume, f);
        short[] sArray2 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray2[i] = (short)((float)sArray[i] * f2);
        }
        return sArray2;
    }

    @Override
    public boolean isEnabled() {
        return this.volume != 1.0f;
    }

    @Override
    public int getSupportedChannels() {
        return 2;
    }

    public void setVolume(float f) {
        this.volume = f;
    }

    public float getVolume() {
        return this.volume;
    }
}

