/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.filter;

import com.moyettes.voice.audio.filter.AudioFilter;
import com.moyettes.voice.audio.utils.AudioUtils;

public class LimiterFilter
implements AudioFilter {
    private static final float SLOPE = 1.0f;
    private static final float OUTPUT_GAIN = AudioUtils.dbToMul(0.0f);
    private static final float DEFAULT_THRESHOLD = -6.0f;
    private final int sampleRate;
    private final float threshold;
    private float[] envelopeBuf = new float[0];
    private float envelope;

    public LimiterFilter(int n, float f) {
        this.sampleRate = n;
        this.threshold = f;
    }

    @Override
    public String getName() {
        return "limiter";
    }

    @Override
    public short[] process(short[] sArray) {
        float[] fArray = AudioUtils.shortsToFloatsRange(sArray);
        this.analyzeEnvelope(fArray);
        this.limit(fArray);
        return AudioUtils.floatsRangeToShort(fArray);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int getSupportedChannels() {
        return 1;
    }

    private synchronized void limit(float[] fArray) {
        int n = 0;
        while (n < fArray.length) {
            float f = AudioUtils.mulToDb(this.envelopeBuf[n]);
            float f2 = 1.0f * (this.threshold - f);
            f2 = AudioUtils.dbToMul(Math.min(0.0f, f2));
            int n2 = n++;
            fArray[n2] = fArray[n2] * (f2 * OUTPUT_GAIN);
        }
    }

    private synchronized void analyzeEnvelope(float[] fArray) {
        this.envelopeBuf = new float[fArray.length];
        float f = AudioUtils.gainCoefficient(this.sampleRate, 1.0E-6f);
        float f2 = AudioUtils.gainCoefficient(this.sampleRate, 0.06f);
        float f3 = this.envelope;
        for (int i = 0; i < fArray.length; ++i) {
            float f4 = Math.abs(fArray[i]);
            f3 = f3 < f4 ? f4 + f * (f3 - f4) : f4 + f2 * (f3 - f4);
            this.envelopeBuf[i] = Math.max(this.envelopeBuf[i], f3);
        }
        this.envelope = this.envelopeBuf[fArray.length - 1];
    }
}

