/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.filter;

import com.moyettes.voice.audio.filter.AudioFilter;
import com.moyettes.voice.audio.filter.LimiterFilter;
import com.moyettes.voice.audio.utils.AudioUtils;
import com.plasmoverse.rnnoise.Denoise;
import com.plasmoverse.rnnoise.DenoiseException;

public class NoiseSuppressionFilter
implements AudioFilter {
    private final boolean enabled;
    private final LimiterFilter limiter;
    private Denoise rnnoiseInstance;

    public NoiseSuppressionFilter(boolean bl) {
        this.enabled = bl;
        this.limiter = new LimiterFilter(48000, -6.0f);
        if (bl) {
            try {
                this.rnnoiseInstance = Denoise.create();
                mod_Voice.LOGGER.info("Plasmo Voice RNNoise noise suppression enabled with built-in limiter");
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Plasmo Voice RNNoise not available, noise suppression disabled: " + exception.getMessage());
                this.rnnoiseInstance = null;
            }
        }
    }

    @Override
    public String getName() {
        return "noise_suppression";
    }

    @Override
    public short[] process(short[] sArray) {
        this.limiter.process(sArray);
        if (!this.enabled || this.rnnoiseInstance == null) {
            return sArray;
        }
        try {
            float[] fArray = AudioUtils.shortsToFloatsRange(sArray);
            float[] fArray2 = this.rnnoiseInstance.process(fArray);
            return AudioUtils.floatsRangeToShort(fArray2);
        }
        catch (DenoiseException denoiseException) {
            mod_Voice.LOGGER.warn("Noise suppression failed: " + denoiseException.getMessage());
            return sArray;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.rnnoiseInstance != null;
    }

    @Override
    public int getSupportedChannels() {
        return 1;
    }

    public void close() {
        if (this.rnnoiseInstance != null) {
            try {
                this.rnnoiseInstance.getClass().getMethod("close", new Class[0]).invoke((Object)this.rnnoiseInstance, new Object[0]);
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Error closing RNNoise instance: " + exception.getMessage());
            }
            this.rnnoiseInstance = null;
        }
    }
}

