/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.audio.utils;

public class AudioUtils {
    public static double getHighestAudioLevel(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return -127.0;
        }
        long l = 0L;
        int n = 0;
        for (int i = 0; i < byArray.length - 1; i += 2) {
            int n2 = byArray[i] & 0xFF | (byArray[i + 1] & 0xFF) << 8;
            if (n2 > Short.MAX_VALUE) {
                n2 -= 65536;
            }
            l += (long)(n2 * n2);
            ++n;
        }
        if (n == 0) {
            return -127.0;
        }
        double d = Math.sqrt((double)l / (double)n);
        return 20.0 * Math.log10(d / 32768.0);
    }

    public static short getHighestAbsoluteSample(short[] sArray) {
        short s = 0;
        for (short s2 : sArray) {
            short s3 = (short)Math.abs(s2);
            if (s3 <= s) continue;
            s = s3;
        }
        return s;
    }

    public static float dbToMul(float f) {
        return Float.isFinite(f) ? (float)Math.pow(10.0, f / 20.0f) : 0.0f;
    }

    public static float mulToDb(float f) {
        return f == 0.0f ? -3.4028235E38f : (float)(20.0 * Math.log10(f));
    }

    public static float gainCoefficient(int n, float f) {
        return (float)Math.exp(-1.0f / ((float)n * f));
    }

    public static float[] shortsToFloatsRange(short[] sArray) {
        float[] fArray = new float[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            fArray[i] = (float)sArray[i] / 32768.0f;
        }
        return fArray;
    }

    public static short[] floatsRangeToShort(float[] fArray) {
        short[] sArray = new short[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            sArray[i] = (short)(fArray[i] * 32768.0f);
        }
        return sArray;
    }

    public static short[] bytesToShorts(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(byArray[i * 2] & 0xFF | (byArray[i * 2 + 1] & 0xFF) << 8);
        }
        return sArray;
    }

    public static byte[] shortsToBytes(short[] sArray) {
        byte[] byArray = new byte[sArray.length * 2];
        for (int i = 0; i < sArray.length; ++i) {
            byArray[i * 2] = (byte)(sArray[i] & 0xFF);
            byArray[i * 2 + 1] = (byte)(sArray[i] >> 8 & 0xFF);
        }
        return byArray;
    }

    public static float[] shortsToFloats(short[] sArray) {
        float[] fArray = new float[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            fArray[i] = (float)sArray[i] / 32768.0f;
        }
        return fArray;
    }

    public static short[] floatsToShorts(float[] fArray) {
        short[] sArray = new short[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            sArray[i] = (short)Math.max(-32768.0f, Math.min(32767.0f, fArray[i] * 32768.0f));
        }
        return sArray;
    }

    public static short[] fadeIn(short[] sArray, int n) {
        if (sArray == null || sArray.length == 0) {
            return sArray;
        }
        int n2 = sArray.length;
        short[] sArray2 = new short[sArray.length];
        for (int i = 0; i < sArray.length; i += n) {
            float f = Math.min((float)i / (float)n2, 1.0f);
            for (int j = 0; j < n; ++j) {
                if (i + j >= sArray.length) continue;
                sArray2[i + j] = (short)((float)sArray[i + j] * f);
            }
        }
        return sArray2;
    }

    public static short[] fadeOut(short[] sArray, int n) {
        if (sArray == null || sArray.length == 0) {
            return sArray;
        }
        int n2 = sArray.length;
        short[] sArray2 = new short[sArray.length];
        for (int i = 0; i < sArray.length; i += n) {
            float f = Math.max((float)(n2 - i) / (float)n2, 0.0f);
            for (int j = 0; j < n; ++j) {
                if (i + j >= sArray.length) continue;
                sArray2[i + j] = (short)((float)sArray[i + j] * f);
            }
        }
        return sArray2;
    }
}

