/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.client;

import com.moyettes.voice.audio.AdaptiveJitterBuffer;
import com.moyettes.voice.audio.AudioProcessor;
import com.moyettes.voice.audio.MicrophoneCapture;
import com.moyettes.voice.audio.OpenALAudioPlayback;
import com.moyettes.voice.audio.StereoAudioPlayback;
import com.moyettes.voice.config.ClientConfig;
import com.moyettes.voice.sound.Simple3DAudio;
import com.moyettes.voice.udp.GroupCreatePacket;
import com.moyettes.voice.udp.GroupDataPacket;
import com.moyettes.voice.udp.GroupJoinPacket;
import com.moyettes.voice.udp.GroupLeavePacket;
import com.moyettes.voice.udp.GroupListPacket;
import com.moyettes.voice.udp.GroupMemberUpdatePacket;
import com.moyettes.voice.udp.PingPacket;
import com.moyettes.voice.udp.PresenceBulkPacket;
import com.moyettes.voice.udp.PresenceUpdatePacket;
import com.moyettes.voice.udp.UdpPacket;
import com.moyettes.voice.udp.VoiceDataPacket;
import com.moyettes.voice.udp.VoiceDataRelayPacket;
import com.moyettes.voice.udp.VoiceHandshakeAckPacket;
import com.moyettes.voice.udp.VoiceHandshakePacket;
import com.moyettes.voice.utils.AudioUtils;
import com.moyettes.voice.utils.MinecraftAccessor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import net.minecraft.client.Minecraft;

public class VoiceClient {
    private DatagramSocket socket;
    private ExecutorService executor;
    private boolean connected = false;
    private String serverHost;
    private int serverPort;
    private Integer playerNetworkId;
    private boolean micEnabled;
    private volatile boolean micMuted = false;
    private volatile boolean userDeafened = false;
    private volatile boolean pushToTalk = false;
    private volatile boolean pttKeyPressed = false;
    private volatile double silenceThreshold = 0.0;
    private volatile float microphoneGain = 1.0f;
    private volatile float masterVolume = 1.0f;
    private volatile String inputDeviceName = null;
    private volatile String outputDeviceName = null;
    private volatile boolean isTalking = false;
    private volatile long lastDeviceChangeTime = 0L;
    private long lastTalkingTime = 0L;
    private Consumer<VoiceHandshakeAckPacket> handshakeCallback;
    private Consumer<GroupMemberUpdatePacket> groupCallback;
    private Consumer<GroupListPacket> groupListCallback;
    private Consumer<List<String>> groupMemberCallback;
    private MicrophoneCapture microphoneCapture;
    private AudioProcessor audioProcessor;
    private StereoAudioPlayback stereoAudioPlayback;
    private final Map<Integer, OpenALAudioPlayback> openALPlaybackBySender = new ConcurrentHashMap<Integer, OpenALAudioPlayback>();
    private final Map<Integer, StereoAudioPlayback> stereoPlaybackBySender = new ConcurrentHashMap<Integer, StereoAudioPlayback>();
    private final Map<Integer, PlaybackState> playbackStateMap = new ConcurrentHashMap<Integer, PlaybackState>();
    private final Map<Integer, AudioProcessor> decoderBySender = new ConcurrentHashMap<Integer, AudioProcessor>();
    private long sequenceNumber = 0L;
    private long lastAudioReceived = 0L;
    private final Map<Integer, Long> lastSeqBySender = new ConcurrentHashMap<Integer, Long>();
    private final Map<Integer, TreeMap<Long, BufferedPacket>> reorderBuffers = new ConcurrentHashMap<Integer, TreeMap<Long, BufferedPacket>>();
    private final Map<Integer, Integer> warmupRemainingBySender = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Long> lastTalkingByRemote = new ConcurrentHashMap<Integer, Long>();
    private final Set<Integer> activatedPlayers = ConcurrentHashMap.newKeySet();
    private final Set<Integer> presenceSupported = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Integer> presenceDeafened = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int REORDER_BUFFER_THRESHOLD = 10;
    private static final int WARMUP_PACKETS = 3;
    private final Map<Integer, Thread> senderThreads = new ConcurrentHashMap<Integer, Thread>();
    private final Map<Integer, BlockingQueue<AdaptiveJitterBuffer.BufferedPacket>> senderQueues = new ConcurrentHashMap<Integer, BlockingQueue<AdaptiveJitterBuffer.BufferedPacket>>();
    private final Map<Integer, Boolean> senderThreadRunning = new ConcurrentHashMap<Integer, Boolean>();
    private final Map<Integer, Set<Long>> enqueuedSeqBySender = new ConcurrentHashMap<Integer, Set<Long>>();
    private static final int SMALL_GAP_PLC_MAX = 4;
    private final Map<Integer, SourceType> activeSourceBySender = new ConcurrentHashMap<Integer, SourceType>();
    private final Map<Integer, ArrayDeque<Integer>> recentOpusCrcBySender = new ConcurrentHashMap<Integer, ArrayDeque<Integer>>();
    private static final int OPUS_CRC_WINDOW = 8;
    private long lastKeepAlive = 0L;
    private long lastSentKeepAlive = 0L;
    private boolean handshakeComplete = false;
    private Simple3DAudio simple3D;
    private MicrophoneCapture testMicrophoneCapture;
    private volatile boolean isMicrophoneTesting = false;
    private final Map<String, Float> playerVolumes = new ConcurrentHashMap<String, Float>();
    private volatile String currentGroupName = null;
    private final Set<Integer> groupMembers = ConcurrentHashMap.newKeySet();
    private ClientConfig config;
    private final byte[] audioGainBuffer = new byte[AudioProcessor.getFrameSize() * 2];
    private final Set<Long> sentSequenceNumbers = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final boolean DEBUG_LOG = false;
    private static long lastDebugLog = 0L;

    private boolean shouldProcessSource(Integer n, SourceType sourceType) {
        SourceType sourceType2 = this.activeSourceBySender.putIfAbsent(n, sourceType);
        return sourceType2 == null || sourceType2 == sourceType;
    }

    private void clearSourceState(Integer n) {
        StereoAudioPlayback stereoAudioPlayback;
        this.senderThreadRunning.put(n, false);
        Thread thread = this.senderThreads.remove(n);
        if (thread != null) {
            thread.interrupt();
        }
        this.senderQueues.remove(n);
        this.enqueuedSeqBySender.remove(n);
        this.reorderBuffers.remove(n);
        this.activeSourceBySender.remove(n);
        OpenALAudioPlayback openALAudioPlayback = this.openALPlaybackBySender.remove(n);
        if (openALAudioPlayback != null) {
            openALAudioPlayback.close();
        }
        if ((stereoAudioPlayback = this.stereoPlaybackBySender.remove(n)) != null) {
            stereoAudioPlayback.close();
        }
        this.playbackStateMap.remove(n);
        AudioProcessor audioProcessor = this.decoderBySender.remove(n);
        if (audioProcessor != null) {
            audioProcessor.close();
        }
    }

    private boolean isDuplicateOpusPacket(Integer n2, byte[] byArray) {
        if (n2 == null || byArray == null || byArray.length == 0) {
            return false;
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        int n3 = (int)cRC32.getValue();
        ArrayDeque arrayDeque = this.recentOpusCrcBySender.computeIfAbsent(n2, n -> new ArrayDeque(8));
        if (arrayDeque.contains(n3)) {
            return true;
        }
        if (arrayDeque.size() >= 8) {
            arrayDeque.pollFirst();
        }
        arrayDeque.offerLast(n3);
        return false;
    }

    private void dbg(String string) {
    }

    public VoiceClient(Integer n, boolean bl) {
        this.playerNetworkId = n;
        this.micEnabled = bl;
        this.executor = Executors.newCachedThreadPool();
        this.config = ClientConfig.load();
        this.loadConfigSettings();
        this.simple3D = new Simple3DAudio();
        if (!this.simple3D.initialize()) {
            mod_Voice.LOGGER.warn("Warning: Simple 3D audio not initialized. 3D audio may not work.");
        }
        this.audioProcessor = new AudioProcessor();
        if (this.audioProcessor.isInitialized()) {
            this.audioProcessor.setMicrophoneGain(this.microphoneGain);
        }
        boolean bl2 = this.outputDeviceName != null && !this.outputDeviceName.equals("Default");
        this.stereoAudioPlayback = new StereoAudioPlayback(this.outputDeviceName);
        if (!this.stereoAudioPlayback.initialize()) {
            mod_Voice.LOGGER.warn("Warning: Stereo audio playback not initialized. Microphone testing may not work.");
        }
        if (bl2) {
            mod_Voice.LOGGER.info("Using StereoAudioPlayback for output device: " + this.outputDeviceName);
        } else {
            mod_Voice.LOGGER.info("OpenAL will be used for audio playback (sources created per sender), StereoAudioPlayback for testing");
            this.dbg("Playback backend: OpenAL (per-sender sources)");
        }
    }

    private void loadConfigSettings() {
        if (this.config == null) {
            return;
        }
        this.microphoneGain = this.config.getMicrophoneGain();
        this.masterVolume = this.config.getMasterVolume();
        this.silenceThreshold = this.config.getActivationThreshold();
        this.pushToTalk = this.config.isPushToTalk();
        this.inputDeviceName = this.config.getInputDevice();
        this.outputDeviceName = this.config.getOutputDevice();
        if (this.config.getPlayerVolumes() != null) {
            this.playerVolumes.clear();
            this.playerVolumes.putAll(this.config.getPlayerVolumes());
        }
    }

    public void connect(String string, int n, String string2) throws IOException {
        if (this.connected) {
            return;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        this.serverHost = string;
        this.serverPort = n;
        this.socket = new DatagramSocket();
        try {
            this.socket.setReceiveBufferSize(131072);
            this.socket.setSendBufferSize(131072);
            this.socket.setReuseAddress(true);
            this.socket.setTrafficClass(4);
        }
        catch (Exception exception) {
            mod_Voice.LOGGER.warn("Failed to set socket optimizations: " + exception.getMessage());
        }
        try {
            this.socket.connect(InetAddress.getByName(string), n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        VoiceHandshakePacket voiceHandshakePacket = new VoiceHandshakePacket(this.playerNetworkId, string2, this.micEnabled);
        this.sendPacket(voiceHandshakePacket, string, n);
        this.connected = true;
        this.handshakeComplete = false;
        this.executor.submit(this::listenForPackets);
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.stopMicrophoneCapture();
        for (Integer object : this.senderThreadRunning.keySet()) {
            this.senderThreadRunning.put(object, false);
        }
        for (Thread thread : this.senderThreads.values()) {
            try {
                thread.interrupt();
                thread.join(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.senderThreads.clear();
        this.senderQueues.clear();
        this.senderThreadRunning.clear();
        for (OpenALAudioPlayback openALAudioPlayback : this.openALPlaybackBySender.values()) {
            if (openALAudioPlayback == null) continue;
            openALAudioPlayback.close();
        }
        this.openALPlaybackBySender.clear();
        for (AudioProcessor audioProcessor : this.decoderBySender.values()) {
            if (audioProcessor == null) continue;
            audioProcessor.close();
        }
        this.decoderBySender.clear();
        if (this.stereoAudioPlayback != null) {
            this.stereoAudioPlayback.clearQueue();
            this.stereoAudioPlayback.flushAudioBuffer();
            this.stereoAudioPlayback.close();
        }
        if (this.audioProcessor != null) {
            this.audioProcessor.close();
        }
        if (this.simple3D != null) {
            this.simple3D.cleanup();
            this.simple3D = null;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void listenForPackets() {
        byte[] byArray = new byte[2048];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        while (this.connected && !this.socket.isClosed()) {
            try {
                this.socket.receive(datagramPacket);
                this.handlePacket(datagramPacket);
                this.checkForStaleAudio();
                this.checkKeepAlive();
            }
            catch (IOException iOException) {
                String string;
                if (this.socket.isClosed() || (string = iOException.getMessage()) == null || string.contains("Connection reset") || string.contains("Connection refused") || string.contains("Network is unreachable") || string.contains("Receive timed out")) continue;
                mod_Voice.LOGGER.warn("Error receiving packet: " + string);
            }
        }
    }

    private void handlePacket(DatagramPacket datagramPacket) {
        block13: {
            try {
                byte[] byArray = new byte[datagramPacket.getLength()];
                System.arraycopy(datagramPacket.getData(), datagramPacket.getOffset(), byArray, 0, datagramPacket.getLength());
                UdpPacket udpPacket = UdpPacket.fromBytes(byArray);
                switch (udpPacket.getType()) {
                    case VOICE_HANDSHAKE_ACK: {
                        this.handleHandshakeAck((VoiceHandshakeAckPacket)udpPacket);
                        break;
                    }
                    case VOICE_DATA: {
                        this.handleVoiceData((VoiceDataPacket)udpPacket);
                        break;
                    }
                    case VOICE_DATA_RELAY: {
                        this.handleVoiceDataRelay((VoiceDataRelayPacket)udpPacket);
                        break;
                    }
                    case GROUP_DATA: {
                        this.handleGroupData((GroupDataPacket)udpPacket);
                        break;
                    }
                    case GROUP_MEMBER_UPDATE: {
                        this.handleGroupMemberUpdate((GroupMemberUpdatePacket)udpPacket);
                        break;
                    }
                    case GROUP_LIST: {
                        this.handleGroupList((GroupListPacket)udpPacket);
                        break;
                    }
                    case PING: {
                        this.handlePing();
                        break;
                    }
                    case PRESENCE_UPDATE: {
                        this.handlePresenceUpdate((PresenceUpdatePacket)udpPacket);
                        break;
                    }
                    case PRESENCE_BULK: {
                        this.handlePresenceBulk((PresenceBulkPacket)udpPacket);
                        break;
                    }
                    default: {
                        mod_Voice.LOGGER.info("Received unhandled packet type: " + (Object)((Object)udpPacket.getType()));
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                String string;
                if (!this.connected || (string = iOException.getMessage()) == null || string.contains("Connection reset") || string.contains("Connection refused") || string.contains("Network is unreachable")) break block13;
                mod_Voice.LOGGER.warn("Error handling packet: " + string);
            }
        }
    }

    private void handleHandshakeAck(VoiceHandshakeAckPacket voiceHandshakeAckPacket) {
        if (voiceHandshakeAckPacket.isSuccess()) {
            this.handshakeComplete = true;
            this.lastKeepAlive = System.currentTimeMillis();
            this.lastSentKeepAlive = System.currentTimeMillis();
            if (this.micEnabled) {
                this.startMicrophoneCapture();
            }
            this.sendPresenceUpdate();
        } else {
            mod_Voice.LOGGER.warn("Failed to connect to voice server: " + voiceHandshakeAckPacket.getMessage());
            this.disconnect();
        }
        if (this.handshakeCallback != null) {
            this.handshakeCallback.accept(voiceHandshakeAckPacket);
        }
    }

    private void handleVoiceData(VoiceDataPacket voiceDataPacket) {
        if (voiceDataPacket.getPlayerNetworkId() != null && !this.shouldProcessSource(voiceDataPacket.getPlayerNetworkId(), SourceType.DIRECT)) {
            this.dbg("Drop DIRECT from sender=" + voiceDataPacket.getPlayerNetworkId() + " due to activeSource=" + (Object)((Object)this.activeSourceBySender.get(voiceDataPacket.getPlayerNetworkId())));
            return;
        }
        if (voiceDataPacket.getAudioData().length == 0) {
            if (voiceDataPacket.getPlayerNetworkId() != null) {
                this.lastSeqBySender.remove(voiceDataPacket.getPlayerNetworkId());
                this.activatedPlayers.remove(voiceDataPacket.getPlayerNetworkId());
                this.clearSourceState(voiceDataPacket.getPlayerNetworkId());
                this.dbg("DIRECT end: cleared state for sender=" + voiceDataPacket.getPlayerNetworkId());
            }
            return;
        }
        if (voiceDataPacket.getPlayerNetworkId() != null && this.isDuplicateOpusPacket(voiceDataPacket.getPlayerNetworkId(), voiceDataPacket.getAudioData())) {
            this.dbg("CRC dedupe: drop DIRECT seq=" + voiceDataPacket.getSequenceNumber() + " sender=" + voiceDataPacket.getPlayerNetworkId());
            return;
        }
        this.processIncomingAudio(voiceDataPacket.getAudioData(), voiceDataPacket.getPlayerNetworkId(), voiceDataPacket.getSequenceNumber());
    }

    private void handleVoiceDataRelay(VoiceDataRelayPacket voiceDataRelayPacket) {
        if (voiceDataRelayPacket.getFromPlayerNetworkId() != null && !this.shouldProcessSource(voiceDataRelayPacket.getFromPlayerNetworkId(), SourceType.RELAY)) {
            this.dbg("Drop RELAY from sender=" + voiceDataRelayPacket.getFromPlayerNetworkId() + " due to activeSource=" + (Object)((Object)this.activeSourceBySender.get(voiceDataRelayPacket.getFromPlayerNetworkId())));
            return;
        }
        if (voiceDataRelayPacket.getAudioData().length == 0) {
            if (voiceDataRelayPacket.getFromPlayerNetworkId() != null) {
                this.lastSeqBySender.remove(voiceDataRelayPacket.getFromPlayerNetworkId());
                this.activatedPlayers.remove(voiceDataRelayPacket.getFromPlayerNetworkId());
                this.clearSourceState(voiceDataRelayPacket.getFromPlayerNetworkId());
                this.dbg("RELAY end: cleared state for sender=" + voiceDataRelayPacket.getFromPlayerNetworkId());
            }
            return;
        }
        if (voiceDataRelayPacket.getFromPlayerNetworkId() != null && this.isDuplicateOpusPacket(voiceDataRelayPacket.getFromPlayerNetworkId(), voiceDataRelayPacket.getAudioData())) {
            this.dbg("CRC dedupe: drop RELAY seq=" + voiceDataRelayPacket.getSequenceNumber() + " sender=" + voiceDataRelayPacket.getFromPlayerNetworkId());
            return;
        }
        this.processIncomingAudio(voiceDataRelayPacket.getAudioData(), voiceDataRelayPacket.getFromPlayerNetworkId(), voiceDataRelayPacket.getSequenceNumber(), voiceDataRelayPacket.getDistance(), voiceDataRelayPacket.getVolume(), voiceDataRelayPacket.getPlayerX(), voiceDataRelayPacket.getPlayerY(), voiceDataRelayPacket.getPlayerZ());
    }

    private void handleGroupData(GroupDataPacket groupDataPacket) {
        if (groupDataPacket.getFromPlayerNetworkId() != null && !this.shouldProcessSource(groupDataPacket.getFromPlayerNetworkId(), SourceType.GROUP)) {
            this.dbg("Drop GROUP from sender=" + groupDataPacket.getFromPlayerNetworkId() + " due to activeSource=" + (Object)((Object)this.activeSourceBySender.get(groupDataPacket.getFromPlayerNetworkId())));
            return;
        }
        if (groupDataPacket.getAudioData().length == 0) {
            if (groupDataPacket.getFromPlayerNetworkId() != null) {
                this.activatedPlayers.remove(groupDataPacket.getFromPlayerNetworkId());
                this.clearSourceState(groupDataPacket.getFromPlayerNetworkId());
                this.dbg("GROUP end: cleared state for sender=" + groupDataPacket.getFromPlayerNetworkId());
            }
            return;
        }
        if (this.isInGroup() && this.currentGroupName.equals(groupDataPacket.getGroupName())) {
            if (groupDataPacket.getFromPlayerNetworkId() != null && this.isDuplicateOpusPacket(groupDataPacket.getFromPlayerNetworkId(), groupDataPacket.getAudioData())) {
                this.dbg("CRC dedupe: drop GROUP seq=" + groupDataPacket.getSequenceNumber() + " sender=" + groupDataPacket.getFromPlayerNetworkId());
                return;
            }
            this.processIncomingAudio(groupDataPacket.getAudioData(), groupDataPacket.getFromPlayerNetworkId(), groupDataPacket.getSequenceNumber(), 0.0, 1.0f, 0.0, 0.0, 0.0);
        }
    }

    private void handleGroupMemberUpdate(GroupMemberUpdatePacket groupMemberUpdatePacket) {
        switch (groupMemberUpdatePacket.getUpdateType()) {
            case GROUP_CREATED: {
                if (groupMemberUpdatePacket.getPlayerNetworkId() == null || !groupMemberUpdatePacket.getPlayerNetworkId().equals(this.playerNetworkId)) break;
                this.currentGroupName = groupMemberUpdatePacket.getGroupName();
                this.groupMembers.clear();
                this.groupMembers.add(this.playerNetworkId);
                break;
            }
            case MEMBER_JOINED: {
                if (groupMemberUpdatePacket.getPlayerNetworkId() != null && groupMemberUpdatePacket.getPlayerNetworkId().equals(this.playerNetworkId)) {
                    this.currentGroupName = groupMemberUpdatePacket.getGroupName();
                    this.groupMembers.clear();
                    for (String object : groupMemberUpdatePacket.getGroupMembers()) {
                        Integer n = this.getPlayerIdFromName(object);
                        if (n == null) continue;
                        this.groupMembers.add(n);
                    }
                    break;
                }
                if (!this.isInGroup() || !this.currentGroupName.equals(groupMemberUpdatePacket.getGroupName()) || groupMemberUpdatePacket.getPlayerNetworkId() == null) break;
                this.groupMembers.add(groupMemberUpdatePacket.getPlayerNetworkId());
                break;
            }
            case MEMBER_LEFT: {
                if (groupMemberUpdatePacket.getPlayerNetworkId() != null && groupMemberUpdatePacket.getPlayerNetworkId().equals(this.playerNetworkId)) {
                    this.currentGroupName = null;
                    this.groupMembers.clear();
                    break;
                }
                if (!this.isInGroup() || !this.currentGroupName.equals(groupMemberUpdatePacket.getGroupName()) || groupMemberUpdatePacket.getPlayerNetworkId() == null) break;
                this.groupMembers.remove(groupMemberUpdatePacket.getPlayerNetworkId());
                break;
            }
            case GROUP_DELETED: {
                if (!this.isInGroup() || !this.currentGroupName.equals(groupMemberUpdatePacket.getGroupName())) break;
                this.currentGroupName = null;
                this.groupMembers.clear();
            }
        }
        if (this.groupCallback != null) {
            this.groupCallback.accept(groupMemberUpdatePacket);
        }
        if (this.groupMemberCallback != null && this.isInGroup()) {
            ArrayList arrayList = new ArrayList();
            for (Integer n : this.groupMembers) {
                String string = this.getPlayerNameFromId(n);
                if (string == null) continue;
                arrayList.add(string);
            }
            this.groupMemberCallback.accept(arrayList);
        }
    }

    private void handleGroupList(GroupListPacket groupListPacket) {
        for (GroupListPacket.GroupInfo groupInfo : groupListPacket.getGroups()) {
            mod_Voice.LOGGER.info("  - " + groupInfo.getName() + " (" + groupInfo.getMemberCount() + " members)" + (groupInfo.hasPassword() ? " [Private]" : " [Public]"));
        }
        if (this.groupListCallback != null) {
            this.groupListCallback.accept(groupListPacket);
        }
    }

    private void handlePresenceUpdate(PresenceUpdatePacket presenceUpdatePacket) {
        this.updatePresence(presenceUpdatePacket.getPlayerNetworkId(), presenceUpdatePacket.isVoiceSupported(), presenceUpdatePacket.isDeafened());
    }

    private void handlePresenceBulk(PresenceBulkPacket presenceBulkPacket) {
        for (Map.Entry<Integer, PresenceBulkPacket.PlayerState> entry : presenceBulkPacket.getPlayerStates().entrySet()) {
            this.updatePresence(entry.getKey(), entry.getValue().voiceSupported, entry.getValue().deafened);
        }
    }

    private void handlePing() {
        this.lastKeepAlive = System.currentTimeMillis();
        try {
            this.sendPacket(new PingPacket(), this.serverHost, this.serverPort);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processIncomingAudio(byte[] byArray, Integer n, long l) {
        this.processIncomingAudio(byArray, n, l, 0.0, 1.0f, 0.0, 0.0, 0.0);
    }

    private void processIncomingAudio(byte[] byArray, Integer n2, long l, double d, float f, double d2, double d3, double d4) {
        Long l2;
        Object object;
        this.lastAudioReceived = System.currentTimeMillis();
        this.lastKeepAlive = System.currentTimeMillis();
        if (this.userDeafened) {
            return;
        }
        if (n2.equals(this.playerNetworkId)) {
            return;
        }
        Long l3 = this.lastSeqBySender.get(n2);
        if (l3 == null) {
            object = this.reorderBuffers.computeIfAbsent(n2, n -> new TreeMap());
            ((TreeMap)object).put(l, new BufferedPacket(byArray, l, d, f, d2, d3, d4));
            int n3 = this.warmupRemainingBySender.getOrDefault(n2, 3);
            if (n3 > 1) {
                this.warmupRemainingBySender.put(n2, n3 - 1);
                return;
            }
            this.warmupRemainingBySender.remove(n2);
            l2 = (Long)((TreeMap)object).firstKey();
            if (l2 != null) {
                l3 = l2 - 1L;
                this.lastSeqBySender.put(n2, l3);
            }
            ((TreeMap)object).remove(l);
        }
        if (l3 != null) {
            long l4;
            if (l <= l3) {
                return;
            }
            long l5 = l3 + 1L;
            if (l > l5 && (l4 = l - l5) <= 10L) {
                TreeMap treeMap = this.reorderBuffers.computeIfAbsent(n2, n -> new TreeMap());
                treeMap.put(l, new BufferedPacket(byArray, l, d, f, d2, d3, d4));
                return;
            }
        }
        object = this.getPlayerNameFromId(n2);
        AudioProcessor audioProcessor = this.decoderBySender.computeIfAbsent(n2, n -> {
            AudioProcessor audioProcessor = new AudioProcessor();
            if (audioProcessor.isInitialized()) {
                return audioProcessor;
            }
            audioProcessor.close();
            return null;
        });
        if (audioProcessor != null && audioProcessor.isInitialized()) {
            byte[] byArray2;
            Object object2;
            Object object3;
            long l6;
            long l7;
            l2 = this.lastSeqBySender.get(n2);
            if (l2 != null && l > l2 + 1L && (l7 = l - (l6 = l2 + 1L)) > 0L) {
                if (l7 <= 4L) {
                    object3 = this.enqueuedSeqBySender.computeIfAbsent(n2, n -> ConcurrentHashMap.newKeySet());
                    for (long i = l6; i < l; ++i) {
                        if (object3.contains(i) || (object2 = audioProcessor.decodeSilence()) == null || ((byte[])object2).length <= 0) continue;
                        AdaptiveJitterBuffer.BufferedPacket bufferedPacket = new AdaptiveJitterBuffer.BufferedPacket((byte[])object2, i, d, 1.0f, d2, d3, d4, System.currentTimeMillis(), 0L);
                        BlockingQueue<AdaptiveJitterBuffer.BufferedPacket> blockingQueue = this.senderQueues.get(n2);
                        if (blockingQueue == null) continue;
                        blockingQueue.offer(bufferedPacket);
                        object3.add(i);
                    }
                } else {
                    for (long i = l6; i < l; ++i) {
                        audioProcessor.decodeSilence();
                    }
                }
            }
            if ((byArray2 = audioProcessor.decodeAudio(byArray)) != null && byArray2.length > 0) {
                this.lastTalkingByRemote.put(n2, System.currentTimeMillis());
                float f2 = object != null ? this.getPlayerVolume((String)object) : 1.0f;
                float f3 = f * this.masterVolume * f2;
                Set set = this.enqueuedSeqBySender.computeIfAbsent(n2, n -> ConcurrentHashMap.newKeySet());
                if (set.contains(l)) {
                    return;
                }
                object3 = new AdaptiveJitterBuffer.BufferedPacket(byArray2, l, d, f3, d2, d3, d4, System.currentTimeMillis(), 0L);
                this.ensureSenderThread(n2);
                BlockingQueue<AdaptiveJitterBuffer.BufferedPacket> blockingQueue = this.senderQueues.get(n2);
                if (blockingQueue != null) {
                    blockingQueue.offer((AdaptiveJitterBuffer.BufferedPacket)object3);
                    set.add(l);
                    if (set.size() > 128) {
                        set.clear();
                        set.add(l);
                    }
                }
                this.lastSeqBySender.put(n2, l);
                TreeMap<Long, BufferedPacket> treeMap = this.reorderBuffers.get(n2);
                if (treeMap != null) {
                    while (true) {
                        BufferedPacket bufferedPacket;
                        object2 = treeMap.higherKey(this.lastSeqBySender.get(n2) - 1L);
                        long l8 = this.lastSeqBySender.get(n2) + 1L;
                        if (object2 == null || (Long)object2 != l8 || (bufferedPacket = treeMap.remove(object2)) == null) break;
                        byte[] byArray3 = audioProcessor.decodeAudio(bufferedPacket.audioData);
                        if (byArray3 == null || byArray3.length <= 0) continue;
                        Set set2 = this.enqueuedSeqBySender.computeIfAbsent(n2, n -> ConcurrentHashMap.newKeySet());
                        if (!set2.contains(bufferedPacket.sequenceNumber)) {
                            AdaptiveJitterBuffer.BufferedPacket bufferedPacket2 = new AdaptiveJitterBuffer.BufferedPacket(byArray3, bufferedPacket.sequenceNumber, bufferedPacket.distance, bufferedPacket.volume, bufferedPacket.playerX, bufferedPacket.playerY, bufferedPacket.playerZ, System.currentTimeMillis(), 0L);
                            this.ensureSenderThread(n2);
                            BlockingQueue<AdaptiveJitterBuffer.BufferedPacket> blockingQueue2 = this.senderQueues.get(n2);
                            if (blockingQueue2 != null) {
                                blockingQueue2.offer(bufferedPacket2);
                                set2.add(bufferedPacket.sequenceNumber);
                            }
                            this.dbg("Offered buffered next sender=" + n2 + " seq=" + bufferedPacket.sequenceNumber);
                        }
                        this.lastSeqBySender.put(n2, bufferedPacket.sequenceNumber);
                    }
                    if (treeMap.isEmpty()) {
                        this.reorderBuffers.remove(n2);
                    }
                }
            }
        } else {
            mod_Voice.LOGGER.warn("Audio processor not available for decoding audio from player " + n2);
        }
    }

    public boolean isPlayerTalking(gs gs2) {
        if (gs2 == null) {
            return false;
        }
        Integer n = gs2.aD;
        if (n == null) {
            return false;
        }
        Long l = this.lastTalkingByRemote.get(n);
        if (l == null) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (l3 < 500L) {
            return true;
        }
        this.lastTalkingByRemote.remove(n);
        this.activatedPlayers.remove(n);
        return false;
    }

    public void updatePresence(int n, boolean bl, boolean bl2) {
        if (bl) {
            this.presenceSupported.add(n);
        } else {
            this.presenceSupported.remove(n);
        }
        if (bl2) {
            this.presenceDeafened.add(n);
        } else {
            this.presenceDeafened.remove(n);
        }
    }

    public boolean isPlayerVoiceSupported(gs gs2) {
        if (gs2 == null) {
            return false;
        }
        Integer n = gs2.aD;
        if (n == null) {
            return false;
        }
        return this.presenceSupported.contains(n);
    }

    public boolean isPlayerDeafened(gs gs2) {
        if (gs2 == null) {
            return false;
        }
        Integer n = gs2.aD;
        if (n == null) {
            return false;
        }
        return this.presenceDeafened.contains(n);
    }

    private void queueToOutput(Integer n, byte[] byArray, double d, double d2, double d3, float f) {
        if (byArray == null || byArray.length == 0) {
            mod_Voice.LOGGER.warn("Attempted to queue null or empty audio");
            return;
        }
        if (byArray.length % 2 != 0) {
            mod_Voice.LOGGER.warn("Invalid mono audio size: " + byArray.length + " bytes (must be even)");
            return;
        }
        PlaybackState playbackState = this.playbackStateMap.get(n);
        if (playbackState == PlaybackState.OPENAL) {
            byte[] byArray2;
            OpenALAudioPlayback openALAudioPlayback = this.openALPlaybackBySender.get(n);
            if (openALAudioPlayback != null && openALAudioPlayback.isInitialized() && (byArray2 = this.calculateStereoPositioning(byArray, d, d2, d3, f)) != null && byArray2.length > 0) {
                this.dbg("Write to OpenAL sender=" + n + " len=" + byArray2.length);
                openALAudioPlayback.writeAudioDirect(byArray2);
            }
        } else if (playbackState == PlaybackState.STEREO_FALLBACK) {
            byte[] byArray3;
            StereoAudioPlayback stereoAudioPlayback = this.stereoPlaybackBySender.get(n);
            if (stereoAudioPlayback != null && stereoAudioPlayback.isInitialized()) {
                byte[] byArray4 = this.calculateStereoPositioning(byArray, d, d2, d3, f);
                if (byArray4 != null && byArray4.length > 0) {
                    this.dbg("Enqueue to fallback StereoAudioPlayback sender=" + n + " len=" + byArray4.length);
                    stereoAudioPlayback.queueAudio(byArray4);
                }
            } else if (this.stereoAudioPlayback != null && this.stereoAudioPlayback.isInitialized() && (byArray3 = this.calculateStereoPositioning(byArray, d, d2, d3, f)) != null && byArray3.length > 0) {
                this.dbg("Enqueue to global StereoAudioPlayback len=" + byArray3.length);
                this.stereoAudioPlayback.queueAudio(byArray3);
            }
        }
    }

    private void ensureSenderThread(Integer n) {
        if (this.senderThreads.containsKey(n)) {
            return;
        }
        LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        this.senderQueues.put(n, linkedBlockingQueue);
        this.senderThreadRunning.put(n, true);
        Thread thread = new Thread(() -> {
            Object object;
            boolean bl;
            mod_Voice.LOGGER.info("[VoiceClient] Started playback thread for sender=" + n);
            boolean bl2 = bl = this.outputDeviceName != null && !this.outputDeviceName.equals("Default");
            if (!bl) {
                object = new OpenALAudioPlayback();
                if (((OpenALAudioPlayback)object).initialize()) {
                    this.openALPlaybackBySender.put(n, (OpenALAudioPlayback)object);
                    this.playbackStateMap.put(n, PlaybackState.OPENAL);
                    mod_Voice.LOGGER.info("[VoiceClient] OpenAL source created for sender=" + n);
                } else {
                    ((OpenALAudioPlayback)object).close();
                    mod_Voice.LOGGER.warn("[VoiceClient] OpenAL initialization failed for sender=" + n + ", falling back to StereoAudioPlayback");
                    StereoAudioPlayback stereoAudioPlayback = new StereoAudioPlayback(this.outputDeviceName);
                    if (!stereoAudioPlayback.initialize()) {
                        stereoAudioPlayback.close();
                        this.playbackStateMap.put(n, PlaybackState.FAILED);
                        mod_Voice.LOGGER.error("[VoiceClient] Both OpenAL and StereoAudioPlayback failed for sender=" + n);
                        return;
                    }
                    this.stereoPlaybackBySender.put(n, stereoAudioPlayback);
                    this.playbackStateMap.put(n, PlaybackState.STEREO_FALLBACK);
                    mod_Voice.LOGGER.info("[VoiceClient] StereoAudioPlayback fallback initialized for sender=" + n);
                }
            } else {
                this.playbackStateMap.put(n, PlaybackState.STEREO_FALLBACK);
                mod_Voice.LOGGER.info("[VoiceClient] Using global StereoAudioPlayback for sender=" + n);
            }
            try {
                while (this.senderThreadRunning.getOrDefault(n, false) != false) {
                    if (!this.connected) return;
                    object = (AdaptiveJitterBuffer.BufferedPacket)linkedBlockingQueue.poll(10L, TimeUnit.MILLISECONDS);
                    if (object == null) continue;
                    this.queueToOutput(n, ((AdaptiveJitterBuffer.BufferedPacket)object).audioData, ((AdaptiveJitterBuffer.BufferedPacket)object).playerX, ((AdaptiveJitterBuffer.BufferedPacket)object).playerY, ((AdaptiveJitterBuffer.BufferedPacket)object).playerZ, ((AdaptiveJitterBuffer.BufferedPacket)object).volume);
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("[VoiceClient] Error in sender thread " + n + ": " + exception.getMessage());
                return;
            }
            finally {
                mod_Voice.LOGGER.info("[VoiceClient] Stopped playback thread for sender=" + n);
            }
        }, "Voice-Sender-" + n);
        thread.setDaemon(true);
        thread.start();
        this.senderThreads.put(n, thread);
    }

    private void sendPacket(UdpPacket udpPacket, String string, int n) throws IOException {
        byte[] byArray = udpPacket.toBytes();
        InetAddress inetAddress = InetAddress.getByName(string);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        this.socket.send(datagramPacket);
    }

    public void setHandshakeCallback(Consumer<VoiceHandshakeAckPacket> consumer) {
        this.handshakeCallback = consumer;
    }

    public void setGroupCallback(Consumer<GroupMemberUpdatePacket> consumer) {
        this.groupCallback = consumer;
    }

    public void setGroupListCallback(Consumer<GroupListPacket> consumer) {
        this.groupListCallback = consumer;
    }

    public void setGroupMemberCallback(Consumer<List<String>> consumer) {
        this.groupMemberCallback = consumer;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Integer getPlayerNetworkId() {
        return this.playerNetworkId;
    }

    public boolean isMicEnabled() {
        return this.micEnabled;
    }

    private void startMicrophoneCapture() {
        if (this.microphoneCapture != null) {
            return;
        }
        this.microphoneCapture = new MicrophoneCapture(this::onAudioData, this.inputDeviceName);
        if (!this.microphoneCapture.startCapture()) {
            mod_Voice.LOGGER.warn("Failed to start microphone capture");
            this.microphoneCapture = null;
        } else {
            mod_Voice.LOGGER.info("Microphone capture started");
        }
    }

    private void stopMicrophoneCapture() {
        if (this.microphoneCapture != null) {
            this.microphoneCapture.stopCapture();
            this.microphoneCapture.close();
            this.microphoneCapture = null;
            mod_Voice.LOGGER.info("Microphone capture stopped");
        }
        if (this.audioProcessor != null) {
            this.audioProcessor.resetEncoder();
        }
    }

    public void toggleMute() {
        if (this.userDeafened && this.micMuted) {
            this.toggleDeafened();
            return;
        }
        this.micMuted = !this.micMuted;
    }

    public boolean isMicMuted() {
        return this.micMuted;
    }

    public void toggleDeafened() {
        this.micMuted = this.userDeafened = !this.userDeafened;
        this.sendPresenceUpdate();
    }

    public boolean isDeafened() {
        return this.userDeafened;
    }

    private void sendPresenceUpdate() {
        if (!this.connected || this.playerNetworkId == null || this.serverHost == null) {
            return;
        }
        try {
            PresenceUpdatePacket presenceUpdatePacket = new PresenceUpdatePacket(this.playerNetworkId, true, this.userDeafened);
            this.sendPacket(presenceUpdatePacket, this.serverHost, this.serverPort);
        }
        catch (Exception exception) {
            mod_Voice.LOGGER.warn("Failed to send presence update: " + exception.getMessage());
        }
    }

    public boolean isPushToTalk() {
        return this.pushToTalk;
    }

    public void setPushToTalk(boolean bl) {
        this.pushToTalk = bl;
        this.pttKeyPressed = false;
        if (this.config != null) {
            this.config.setPushToTalk(bl);
            this.config.save();
        }
    }

    public void setPttKeyPressed(boolean bl) {
        this.pttKeyPressed = bl;
    }

    public boolean isPttKeyPressed() {
        return this.pttKeyPressed;
    }

    public double getSilenceThreshold() {
        return this.silenceThreshold;
    }

    public void setSilenceThreshold(double d) {
        if (d < -127.0) {
            d = -127.0;
        }
        if (d > 0.0) {
            d = 0.0;
        }
        this.silenceThreshold = d;
        if (this.config != null) {
            this.config.setActivationThreshold(d);
            this.config.save();
        }
    }

    public float getMicrophoneGain() {
        return this.microphoneGain;
    }

    public void setMicrophoneGain(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 2.0f) {
            f = 2.0f;
        }
        this.microphoneGain = f;
        if (this.audioProcessor != null) {
            this.audioProcessor.setMicrophoneGain(f);
        }
        if (this.config != null) {
            this.config.setMicrophoneGain(f);
            this.config.save();
        }
    }

    public float getMasterVolume() {
        return this.masterVolume;
    }

    public void setMasterVolume(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 2.0f) {
            f = 2.0f;
        }
        this.masterVolume = f;
        if (this.config != null) {
            this.config.setMasterVolume(f);
            this.config.save();
        }
    }

    public float getPlayerVolume(String string) {
        return this.playerVolumes.getOrDefault(string, Float.valueOf(1.0f)).floatValue();
    }

    public void setPlayerVolume(String string, float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 2.0f) {
            f = 2.0f;
        }
        if (f == 1.0f) {
            this.playerVolumes.remove(string);
        } else {
            this.playerVolumes.put(string, Float.valueOf(f));
        }
        if (this.config != null) {
            this.config.setPlayerVolume(string, f);
            this.config.save();
        }
    }

    public String getCurrentGroupName() {
        return this.currentGroupName;
    }

    public boolean isInGroup() {
        return this.currentGroupName != null && !this.currentGroupName.isEmpty();
    }

    public Set<Integer> getGroupMembers() {
        return new HashSet<Integer>(this.groupMembers);
    }

    public void createGroup(String string, String string2) {
        if (!this.connected) {
            mod_Voice.LOGGER.warn("Cannot create group: not connected to voice server");
            return;
        }
        try {
            GroupCreatePacket groupCreatePacket = new GroupCreatePacket(string, string2);
            this.sendPacket(groupCreatePacket, this.serverHost, this.serverPort);
            mod_Voice.LOGGER.info("Sent group creation request for: " + string);
        }
        catch (IOException iOException) {
            mod_Voice.LOGGER.warn("Failed to send group creation packet: " + iOException.getMessage());
        }
    }

    public void joinGroup(String string, String string2) {
        if (!this.connected) {
            mod_Voice.LOGGER.warn("Cannot join group: not connected to voice server");
            return;
        }
        try {
            GroupJoinPacket groupJoinPacket = new GroupJoinPacket(string, string2);
            this.sendPacket(groupJoinPacket, this.serverHost, this.serverPort);
            mod_Voice.LOGGER.info("Sent group join request for: " + string);
        }
        catch (IOException iOException) {
            mod_Voice.LOGGER.warn("Failed to send group join packet: " + iOException.getMessage());
        }
    }

    public void leaveGroup() {
        if (!this.connected) {
            mod_Voice.LOGGER.warn("Cannot leave group: not connected to voice server");
            return;
        }
        if (!this.isInGroup()) {
            mod_Voice.LOGGER.warn("Cannot leave group: not currently in a group");
            return;
        }
        try {
            GroupLeavePacket groupLeavePacket = new GroupLeavePacket(this.currentGroupName);
            this.sendPacket(groupLeavePacket, this.serverHost, this.serverPort);
            mod_Voice.LOGGER.info("Sent group leave request for: " + this.currentGroupName);
        }
        catch (IOException iOException) {
            mod_Voice.LOGGER.warn("Failed to send group leave packet: " + iOException.getMessage());
        }
    }

    public void requestGroupList() {
        if (!this.connected) {
            mod_Voice.LOGGER.warn("Cannot request group list: not connected to voice server");
            return;
        }
        try {
            GroupListPacket groupListPacket = new GroupListPacket();
            this.sendPacket(groupListPacket, this.serverHost, this.serverPort);
        }
        catch (IOException iOException) {
            mod_Voice.LOGGER.warn("Failed to send group list request: " + iOException.getMessage());
        }
    }

    public String getInputDeviceName() {
        return this.inputDeviceName;
    }

    public void setInputDeviceName(String string) {
        boolean bl;
        this.inputDeviceName = string;
        if (this.config != null) {
            this.config.setInputDevice(string);
            this.config.save();
        }
        if (bl = this.isMicrophoneTesting) {
            this.stopMicrophoneTesting();
        }
        if (this.connected) {
            this.stopMicrophoneCapture();
            this.microphoneCapture = new MicrophoneCapture(this::onAudioData, this.inputDeviceName);
            if (!this.microphoneCapture.startCapture()) {
                mod_Voice.LOGGER.warn("Failed to start microphone capture for device: " + this.inputDeviceName);
                this.microphoneCapture = null;
            }
        }
        if (bl) {
            this.startMicrophoneTesting();
        }
    }

    public String getOutputDeviceName() {
        return this.outputDeviceName;
    }

    public void setOutputDeviceName(String string) {
        boolean bl;
        long l = System.currentTimeMillis();
        if (l - this.lastDeviceChangeTime < 100L) {
            return;
        }
        this.lastDeviceChangeTime = l;
        this.outputDeviceName = string;
        if (this.config != null) {
            this.config.setOutputDevice(string);
            this.config.save();
        }
        boolean bl2 = bl = string != null && !string.equals("Default");
        if (bl && !this.openALPlaybackBySender.isEmpty()) {
            mod_Voice.LOGGER.info("Switching to StereoAudioPlayback for device selection support");
            for (OpenALAudioPlayback openALAudioPlayback : this.openALPlaybackBySender.values()) {
                if (openALAudioPlayback == null) continue;
                openALAudioPlayback.close();
            }
            this.openALPlaybackBySender.clear();
        } else if (!bl) {
            mod_Voice.LOGGER.info("Switched back to OpenAL (per-sender sources will be created on demand)");
        }
        if (this.stereoAudioPlayback != null) {
            try {
                this.stereoAudioPlayback.close();
            }
            catch (Exception exception) {
                mod_Voice.LOGGER.warn("Error closing previous audio playback: " + exception.getMessage());
            }
        }
        try {
            this.stereoAudioPlayback = new StereoAudioPlayback(this.outputDeviceName);
            if (!this.stereoAudioPlayback.initialize()) {
                mod_Voice.LOGGER.warn("Warning: Stereo audio playback not initialized with new device. Voice output may not work.");
                this.stereoAudioPlayback = null;
            }
        }
        catch (Exception exception) {
            mod_Voice.LOGGER.warn("Error initializing audio playback with new device: " + exception.getMessage());
            this.stereoAudioPlayback = null;
        }
    }

    public boolean isTalking() {
        boolean bl;
        long l = System.currentTimeMillis() - this.lastTalkingTime;
        boolean bl2 = bl = this.isTalking && l < 500L;
        if (!bl && this.isTalking) {
            this.isTalking = false;
        }
        return bl;
    }

    private boolean isAudioSilent(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return true;
        }
        int n = AudioUtils.getActivationOffset(byArray, this.silenceThreshold);
        return n < 0;
    }

    private void checkForStaleAudio() {
        long l = System.currentTimeMillis() - this.lastAudioReceived;
        if (l > 10000L && this.stereoAudioPlayback != null) {
            this.stereoAudioPlayback.flushAudioBuffer();
        }
    }

    private void checkKeepAlive() {
        long l;
        if (!this.handshakeComplete) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - this.lastSentKeepAlive > 10000L) {
            try {
                this.sendPacket(new PingPacket(), this.serverHost, this.serverPort);
                this.lastSentKeepAlive = l2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((l = l2 - this.lastKeepAlive) > 120000L) {
            mod_Voice.LOGGER.warn("Voice server connection timed out (no activity for " + l / 1000L + " seconds)");
            this.disconnect();
        }
    }

    private void onAudioData(byte[] byArray) {
        if (!this.connected || byArray == null || byArray.length == 0 || this.micMuted) {
            return;
        }
        boolean bl = this.pushToTalk ? !this.pttKeyPressed || byArray.length == 0 : this.isAudioSilent(byArray);
        if (bl) {
            return;
        }
        if (this.audioProcessor != null && this.audioProcessor.isInitialized()) {
            this.processAudioFrame(byArray);
        }
    }

    private void processAudioFrame(byte[] byArray) {
        block10: {
            try {
                block11: {
                    long l;
                    byte[] byArray2 = null;
                    if (this.audioProcessor != null && this.audioProcessor.isInitialized()) {
                        byArray2 = this.audioProcessor.encodeAudio(byArray);
                    }
                    if (byArray2 == null || byArray2.length <= 0) break block10;
                    if (byArray2.length > 1024) {
                        mod_Voice.LOGGER.warn("Encoded audio too large: " + byArray2.length + " bytes, skipping packet");
                        return;
                    }
                    if (this.sentSequenceNumbers.contains(l = this.sequenceNumber++)) {
                        return;
                    }
                    this.sentSequenceNumbers.add(l);
                    if (this.sentSequenceNumbers.size() > 1000) {
                        this.sentSequenceNumbers.clear();
                    }
                    try {
                        if (this.isInGroup()) {
                            GroupDataPacket groupDataPacket = new GroupDataPacket(this.currentGroupName, this.playerNetworkId, byArray2, l, new ArrayList<Integer>(this.groupMembers));
                            this.sendPacket(groupDataPacket, this.serverHost, this.serverPort);
                        } else {
                            VoiceDataPacket voiceDataPacket = new VoiceDataPacket(this.playerNetworkId, byArray2, l);
                            this.sendPacket(voiceDataPacket, this.serverHost, this.serverPort);
                        }
                    }
                    catch (IOException iOException) {
                        String string;
                        if (!this.connected || (string = iOException.getMessage()) == null || string.contains("Connection reset") || string.contains("Connection refused") || string.contains("Network is unreachable")) break block11;
                        mod_Voice.LOGGER.warn("Failed to send voice data: " + string);
                    }
                }
                this.isTalking = true;
                this.lastTalkingTime = System.currentTimeMillis();
            }
            catch (Exception exception) {
                String string;
                if (!this.connected || (string = exception.getMessage()) == null || string.contains("Connection reset") || string.contains("Connection refused") || string.contains("Network is unreachable")) break block10;
                mod_Voice.LOGGER.warn("Failed to send voice data: " + string);
            }
        }
    }

    private byte[] applyMicrophoneGain(byte[] byArray, float f) {
        if (f == 1.0f) {
            return byArray;
        }
        if (this.audioGainBuffer.length < byArray.length) {
            byte[] byArray2 = new byte[byArray.length];
            this.applyGainToBuffer(byArray, byArray2, f);
            return byArray2;
        }
        this.applyGainToBuffer(byArray, this.audioGainBuffer, f);
        byte[] byArray3 = new byte[byArray.length];
        System.arraycopy(this.audioGainBuffer, 0, byArray3, 0, byArray.length);
        return byArray3;
    }

    private void applyGainToBuffer(byte[] byArray, byte[] byArray2, float f) {
        int n = 0;
        while (n + 1 < byArray.length) {
            int n2;
            int n3 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
            if (n3 > Short.MAX_VALUE) {
                n3 -= 65536;
            }
            if ((n2 = Math.round((float)n3 * f)) > Short.MAX_VALUE) {
                n2 = Short.MAX_VALUE;
            }
            if (n2 < Short.MIN_VALUE) {
                n2 = Short.MIN_VALUE;
            }
            int n4 = n2;
            byArray2[n] = (byte)(n4 & 0xFF);
            byArray2[n + 1] = (byte)(n4 >>> 8 & 0xFF);
            n += 2;
        }
        if ((byArray.length & 1) == 1) {
            byArray2[byArray.length - 1] = byArray[byArray.length - 1];
        }
    }

    private byte[] calculateStereoPositioning(byte[] byArray, double d, double d2, double d3, float f) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (this.isInGroup()) {
            return this.duplicateMonoToStereo(byArray, f);
        }
        double d4 = d - this.simple3D.listenerX;
        double d5 = d3 - this.simple3D.listenerZ;
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        if (d6 < 1.0E-6) {
            return this.duplicateMonoToStereo(byArray, f);
        }
        double d7 = d4 / d6;
        double d8 = d5 / d6;
        double d9 = Math.toRadians(this.simple3D.listenerYaw);
        double d10 = Math.cos(d9);
        double d11 = Math.sin(d9);
        float f2 = (float)(-(d7 * d10 + d8 * d11));
        if (f < 1.0f) {
            float f3 = (float)Math.max(0.1, Math.min(1.0, 10.0 / Math.max(1.0, d6)));
            f *= f3;
        }
        f2 = Math.max(-1.0f, Math.min(1.0f, f2));
        return this.applyStereoPanning(byArray, f2, f);
    }

    private byte[] applyStereoPanning(byte[] byArray, float f, float f2) {
        if (Math.abs(f) < 0.01f) {
            return this.duplicateMonoToStereo(byArray, f2);
        }
        byte[] byArray2 = new byte[byArray.length * 2];
        float f3 = (float)Math.sqrt(0.5 * (1.0 - (double)f));
        float f4 = (float)Math.sqrt(0.5 * (1.0 + (double)f));
        f2 = Math.min(f2, 1.0f);
        for (int i = 0; i < byArray.length; i += 2) {
            if (i + 1 >= byArray.length) continue;
            short s = (short)(byArray[i + 1] << 8 | byArray[i] & 0xFF);
            int n = (int)((float)s * f2);
            n = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n));
            short s2 = (short)n;
            int n2 = (int)((float)s2 * f3);
            int n3 = (int)((float)s2 * f4);
            n2 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n2));
            n3 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n3));
            short s3 = (short)n2;
            short s4 = (short)n3;
            int n4 = i / 2 * 4;
            byArray2[n4] = (byte)(s3 & 0xFF);
            byArray2[n4 + 1] = (byte)(s3 >> 8 & 0xFF);
            byArray2[n4 + 2] = (byte)(s4 & 0xFF);
            byArray2[n4 + 3] = (byte)(s4 >> 8 & 0xFF);
        }
        return byArray2;
    }

    private byte[] duplicateMonoToStereo(byte[] byArray, float f) {
        byte[] byArray2 = new byte[byArray.length * 2];
        f = Math.min(f, 1.0f);
        for (int i = 0; i < byArray.length; i += 2) {
            if (i + 1 >= byArray.length) continue;
            short s = (short)(byArray[i + 1] << 8 | byArray[i] & 0xFF);
            int n = (int)((float)s * f);
            n = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n));
            short s2 = (short)n;
            int n2 = i / 2 * 4;
            byArray2[n2] = (byte)(s2 & 0xFF);
            byArray2[n2 + 1] = (byte)(s2 >> 8 & 0xFF);
            byArray2[n2 + 2] = (byte)(s2 & 0xFF);
            byArray2[n2 + 3] = (byte)(s2 >> 8 & 0xFF);
        }
        return byArray2;
    }

    public void updateListenerPosition(double d, double d2, double d3, float f, float f2) {
        if (this.simple3D != null && this.simple3D.isInitialized()) {
            this.simple3D.updateListener(d, d2, d3, f, f2);
        }
    }

    public boolean startMicrophoneTesting() {
        boolean bl;
        if (this.isMicrophoneTesting) {
            return true;
        }
        if (this.testMicrophoneCapture != null) {
            this.stopMicrophoneTesting();
        }
        boolean bl2 = bl = this.microphoneCapture != null;
        if (bl) {
            this.stopMicrophoneCapture();
        }
        this.testMicrophoneCapture = new MicrophoneCapture(this::onTestMicrophoneData, this.inputDeviceName);
        if (!this.testMicrophoneCapture.startCapture()) {
            mod_Voice.LOGGER.warn("Failed to start microphone testing");
            this.testMicrophoneCapture = null;
            if (bl && this.connected) {
                this.startMicrophoneCapture();
            }
            return false;
        }
        this.isMicrophoneTesting = true;
        mod_Voice.LOGGER.info("Microphone testing started");
        return true;
    }

    public void stopMicrophoneTesting() {
        if (!this.isMicrophoneTesting) {
            return;
        }
        this.isMicrophoneTesting = false;
        if (this.testMicrophoneCapture != null) {
            this.testMicrophoneCapture.stopCapture();
            this.testMicrophoneCapture.close();
            this.testMicrophoneCapture = null;
        }
        if (this.connected && this.microphoneCapture == null) {
            this.startMicrophoneCapture();
        }
        mod_Voice.LOGGER.info("Microphone testing stopped");
    }

    public boolean isMicrophoneTesting() {
        return this.isMicrophoneTesting;
    }

    private void onTestMicrophoneData(byte[] byArray) {
        if (!this.isMicrophoneTesting || byArray == null || byArray.length == 0) {
            return;
        }
        try {
            byte[] byArray2 = this.applyMicrophoneGain(byArray, this.microphoneGain);
            byte[] byArray3 = this.duplicateMonoToStereo(byArray2, 1.0f);
            if (this.stereoAudioPlayback != null && this.stereoAudioPlayback.isInitialized()) {
                if (!this.stereoAudioPlayback.isRunning() && !this.stereoAudioPlayback.startPlayback()) {
                    mod_Voice.LOGGER.warn("Failed to start stereo audio playback for mic testing");
                    return;
                }
                this.stereoAudioPlayback.queueAudio(byArray3);
            }
        }
        catch (Exception exception) {
            mod_Voice.LOGGER.warn("Error during microphone testing: " + exception.getMessage());
        }
    }

    public String getPlayerNameFromId(Integer n) {
        try {
            Minecraft minecraft = MinecraftAccessor.getMinecraft();
            if (minecraft != null && minecraft.f != null) {
                for (Object e : minecraft.f.d) {
                    if (!(e instanceof gs)) continue;
                    gs gs2 = (gs)e;
                    if (gs2.aD != n) continue;
                    return gs2.l;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Integer getPlayerIdFromName(String string) {
        try {
            Minecraft minecraft = MinecraftAccessor.getMinecraft();
            if (minecraft != null && minecraft.f != null) {
                for (Object e : minecraft.f.d) {
                    if (!(e instanceof gs)) continue;
                    gs gs2 = (gs)e;
                    if (gs2.l == null || !gs2.l.equals(string)) continue;
                    return gs2.aD;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static enum SourceType {
        DIRECT,
        RELAY,
        GROUP;

    }

    private static class BufferedPacket {
        final byte[] audioData;
        final long sequenceNumber;
        final double distance;
        final float volume;
        final double playerX;
        final double playerY;
        final double playerZ;

        BufferedPacket(byte[] byArray, long l, double d, float f, double d2, double d3, double d4) {
            this.audioData = byArray;
            this.sequenceNumber = l;
            this.distance = d;
            this.volume = f;
            this.playerX = d2;
            this.playerY = d3;
            this.playerZ = d4;
        }
    }

    private static enum PlaybackState {
        OPENAL,
        STEREO_FALLBACK,
        FAILED;

    }
}

