/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class ClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @SerializedName(value="microphone_gain")
    private float microphoneGain = 1.0f;
    @SerializedName(value="master_volume")
    private float masterVolume = 1.0f;
    @SerializedName(value="activation_threshold")
    private double activationThreshold = -60.0;
    @SerializedName(value="push_to_talk")
    private boolean pushToTalk = false;
    @SerializedName(value="input_device")
    private String inputDevice = null;
    @SerializedName(value="output_device")
    private String outputDevice = null;
    @SerializedName(value="player_volumes")
    private Map<String, Float> playerVolumes = new HashMap<String, Float>();
    private static final float MIN_VOLUME = 0.0f;
    private static final float MAX_VOLUME = 2.0f;
    private static final double MIN_THRESHOLD = -127.0;
    private static final double MAX_THRESHOLD = 0.0;

    public float getMicrophoneGain() {
        return this.microphoneGain;
    }

    public void setMicrophoneGain(float f) {
        this.microphoneGain = Math.max(0.0f, Math.min(2.0f, f));
    }

    public float getMasterVolume() {
        return this.masterVolume;
    }

    public void setMasterVolume(float f) {
        this.masterVolume = Math.max(0.0f, Math.min(2.0f, f));
    }

    public double getActivationThreshold() {
        return this.activationThreshold;
    }

    public void setActivationThreshold(double d) {
        this.activationThreshold = Math.max(-127.0, Math.min(0.0, d));
    }

    public boolean isPushToTalk() {
        return this.pushToTalk;
    }

    public void setPushToTalk(boolean bl) {
        this.pushToTalk = bl;
    }

    public String getInputDevice() {
        return this.inputDevice;
    }

    public void setInputDevice(String string) {
        this.inputDevice = string != null && string.trim().isEmpty() ? null : string;
    }

    public String getOutputDevice() {
        return this.outputDevice;
    }

    public void setOutputDevice(String string) {
        this.outputDevice = string != null && string.trim().isEmpty() ? null : string;
    }

    public Map<String, Float> getPlayerVolumes() {
        return this.playerVolumes;
    }

    public void setPlayerVolumes(Map<String, Float> map) {
        this.playerVolumes = map;
    }

    public void setPlayerVolume(String string, float f) {
        float f2;
        if (string == null || string.trim().isEmpty()) {
            return;
        }
        if (this.playerVolumes == null) {
            this.playerVolumes = new HashMap<String, Float>();
        }
        if ((f2 = Math.max(0.0f, Math.min(2.0f, f))) == 1.0f) {
            this.playerVolumes.remove(string);
        } else {
            this.playerVolumes.put(string, Float.valueOf(f2));
        }
    }

    public float getPlayerVolume(String string) {
        if (this.playerVolumes == null) {
            return 1.0f;
        }
        return this.playerVolumes.getOrDefault(string, Float.valueOf(1.0f)).floatValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientConfig load() {
        Object object;
        Path path = Paths.get("config", "voice-client.json");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            System.err.println("Failed to create config directory: " + iOException.getMessage());
        }
        if (Files.exists(path, new LinkOption[0])) {
            try {
                object = Files.newBufferedReader(path);
                try {
                    ClientConfig clientConfig2 = GSON.fromJson((Reader)object, ClientConfig.class);
                    if (clientConfig2 != null) {
                        if (clientConfig2.playerVolumes == null) {
                            clientConfig2.playerVolumes = new HashMap<String, Float>();
                        }
                        ClientConfig clientConfig = clientConfig2;
                        return clientConfig;
                    }
                }
                finally {
                    if (object != null) {
                        ((Reader)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed to load client config file: " + iOException.getMessage());
            }
        }
        object = new ClientConfig();
        ((ClientConfig)object).save();
        return object;
    }

    public void save() {
        Path path = Paths.get("config", "voice-client.json");
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)bufferedWriter);
        }
        catch (IOException iOException) {
            System.err.println("Failed to save client config file: " + iOException.getMessage());
        }
    }
}

