/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.events;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ClientEvents {
    public static ClientEvents INSTANCE;
    private final List<Consumer<qb>> inputEvents;
    private final List<Runnable> renderHUDEvents;
    private final List<RenderPlayerIconCallback> renderPlayerIconEvents = new ArrayList<RenderPlayerIconCallback>();

    public ClientEvents() {
        INSTANCE = this;
        this.inputEvents = new ArrayList<Consumer<qb>>();
        this.renderHUDEvents = new ArrayList<Runnable>();
    }

    public void onInput(qb qb2) {
        this.inputEvents.forEach(consumer -> consumer.accept(qb2));
    }

    public void registerKeyBindsEvent(Consumer<qb> consumer) {
        this.inputEvents.add(consumer);
    }

    public void onRenderHUD() {
        this.renderHUDEvents.forEach(Runnable::run);
    }

    public void registerRenderHUDEvent(Runnable runnable) {
        this.renderHUDEvents.add(runnable);
    }

    public void onRenderPlayerIcons(gs gs2, double d, double d2, double d3) {
        this.renderPlayerIconEvents.forEach(renderPlayerIconCallback -> renderPlayerIconCallback.render(gs2, d, d2, d3));
    }

    public void registerRenderPlayerIconsEvent(RenderPlayerIconCallback renderPlayerIconCallback) {
        this.renderPlayerIconEvents.add(renderPlayerIconCallback);
    }

    @FunctionalInterface
    public static interface RenderPlayerIconCallback {
        public void render(gs var1, double var2, double var4, double var6);
    }
}

