/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.events;

import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.events.ClientEvents;
import com.moyettes.voice.utils.MinecraftAccessor;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class RenderEvents {
    private static final String MICROPHONE_ICON = "/assets/legacyvoicechat/textures/icons/microphone.png";
    private static final String MICROPHONE_MUTE_ICON = "/assets/legacyvoicechat/textures/icons/microphone_off.png";
    private static final String PLAYER_DISCONNECTED = "/assets/legacyvoicechat/textures/icons/player_disconnected.png";
    private static final String PLAYER_MUTED = "/assets/legacyvoicechat/textures/icons/player_muted.png";
    private static final String PLAYER_TALKING = "/assets/legacyvoicechat/textures/icons/player_talking.png";

    public RenderEvents() {
        ClientEvents.INSTANCE.registerRenderHUDEvent(this::onRenderHUD);
        ClientEvents.INSTANCE.registerRenderPlayerIconsEvent(this::onRenderPlayerIcons);
    }

    private void onRenderHUD() {
        Minecraft minecraft = MinecraftAccessor.getMinecraft();
        if (minecraft == null) {
            return;
        }
        VoiceClient voiceClient = mod_Voice.getVoiceClient();
        if (voiceClient == null) {
            this.renderHudIcon(minecraft, PLAYER_DISCONNECTED);
            return;
        }
        if (voiceClient.isDeafened()) {
            this.renderHudIcon(minecraft, PLAYER_MUTED);
        } else if (voiceClient.isMicMuted()) {
            this.renderHudIcon(minecraft, MICROPHONE_MUTE_ICON);
        } else if (voiceClient.isTalking()) {
            this.renderHudIcon(minecraft, MICROPHONE_ICON);
        }
    }

    private void onRenderPlayerIcons(gs gs2, double d, double d2, double d3) {
        VoiceClient voiceClient = mod_Voice.getVoiceClient();
        if (voiceClient == null) {
            return;
        }
        if (voiceClient.isPlayerVoiceSupported(gs2)) {
            if (voiceClient.isPlayerDeafened(gs2)) {
                this.renderPlayerIconWithTexture(gs2, d, d2, d3, PLAYER_MUTED);
            } else if (voiceClient.isPlayerTalking(gs2)) {
                this.renderPlayerIcon(gs2, d, d2, d3);
            }
        } else {
            this.renderPlayerIconWithTexture(gs2, d, d2, d3, PLAYER_DISCONNECTED);
        }
    }

    private void renderPlayerIconWithTexture(gs gs2, double d, double d2, double d3, String string) {
        Minecraft minecraft = MinecraftAccessor.getMinecraft();
        if (minecraft == null) {
            return;
        }
        double d4 = gs2.t() ? 2.1 : 2.3;
        double d5 = d4 + 0.2;
        GL11.glPushMatrix();
        GL11.glTranslated((double)d, (double)(d2 + d5), (double)d3);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-minecraft.h.aS), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)minecraft.h.aT, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.013333335f, (float)-0.013333335f, (float)0.013333335f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        int n = minecraft.p.b(string);
        GL11.glBindTexture((int)3553, (int)n);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n2 = 16;
        int n3 = n2 / 2;
        nw nw2 = nw.a;
        nw2.a(7);
        nw2.a((double)(-n3), (double)(-n3), 0.0, 0.0, 0.0);
        nw2.a((double)n3, (double)(-n3), 0.0, 1.0, 0.0);
        nw2.a((double)n3, (double)n3, 0.0, 1.0, 1.0);
        nw2.a((double)(-n3), (double)n3, 0.0, 0.0, 1.0);
        nw2.a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    private void renderPlayerIcon(gs gs2, double d, double d2, double d3) {
        Minecraft minecraft = MinecraftAccessor.getMinecraft();
        if (minecraft == null) {
            return;
        }
        double d4 = gs2.t() ? 2.1 : 2.3;
        double d5 = d4 + 0.2;
        GL11.glPushMatrix();
        GL11.glTranslated((double)d, (double)(d2 + d5), (double)d3);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-minecraft.h.aS), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)minecraft.h.aT, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.013333335f, (float)-0.013333335f, (float)0.013333335f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        int n = minecraft.p.b(PLAYER_TALKING);
        GL11.glBindTexture((int)3553, (int)n);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n2 = 16;
        int n3 = n2 / 2;
        nw nw2 = nw.a;
        nw2.a(7);
        nw2.a((double)(-n3), (double)(-n3), 0.0, 0.0, 0.0);
        nw2.a((double)n3, (double)(-n3), 0.0, 1.0, 0.0);
        nw2.a((double)n3, (double)n3, 0.0, 1.0, 1.0);
        nw2.a((double)(-n3), (double)n3, 0.0, 0.0, 1.0);
        nw2.a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    private void renderHudIcon(Minecraft minecraft, String string) {
        int n;
        qq qq2 = new qq(minecraft.z, minecraft.d, minecraft.e);
        int n2 = qq2.b();
        int n3 = qq2.a();
        int n4 = 16;
        int n5 = n = 8;
        int n6 = n2 - n4 - n;
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)n3, (double)n2, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        int n7 = minecraft.p.b(string);
        minecraft.p.b(n7);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)n5, (float)(n6 + n4));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(n5 + n4), (float)(n6 + n4));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(n5 + n4), (float)n6);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)n5, (float)n6);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopAttrib();
    }
}

