/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.GroupsScreen;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Mouse;

public class GroupMembersScreen
extends BaseVoiceScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int BUTTON_HEIGHT = 20;
    private final List<MemberEntry> entries = new ArrayList<MemberEntry>();
    private int scrollOffset = 0;
    private List<String> groupMembers = new ArrayList<String>();
    private String currentGroupName = "";
    private static GroupMembersScreen currentInstance = null;

    @Override
    protected void initContent() {
        currentInstance = this;
        VoiceClient voiceClient = mod_Voice.getVoiceClient();
        if (voiceClient != null) {
            this.currentGroupName = voiceClient.getCurrentGroupName();
            this.groupMembers = new ArrayList<String>();
            for (Integer n : voiceClient.getGroupMembers()) {
                String string = voiceClient.getPlayerNameFromId(n);
                if (string == null) continue;
                this.groupMembers.add(string);
            }
        }
        this.buildMemberEntries();
    }

    @Override
    protected void renderContent(int n, int n2, float f) {
        int n3 = Mouse.getDWheel();
        if (n3 != 0) {
            int n4 = (this.d - this.backgroundHeight) / 2;
            int n5 = n4 + 24;
            int n6 = n4 + this.backgroundHeight - 36;
            int n7 = n6 - n5;
            int n8 = Math.max(0, this.entries.size() * 24 - n7);
            this.scrollOffset -= (int)Math.signum(n3) * 16;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > n8) {
                this.scrollOffset = n8;
            }
        }
        this.layoutAndRenderEntries(n, n2, f);
    }

    @Override
    protected String getBackgroundTexture() {
        return "/assets/legacyvoicechat/textures/gui/group.png";
    }

    @Override
    protected String getTitle() {
        return "Group: " + (this.currentGroupName == null || this.currentGroupName.isEmpty() ? "Unknown" : this.currentGroupName);
    }

    @Override
    protected void handleCustomButtonClick(ke ke2) {
        if (ke2.f == 1106) {
            mod_Voice.leaveGroup();
            System.out.println("Leaving group: " + this.currentGroupName);
            this.b.a((da)new GroupsScreen());
        }
    }

    private void buildMemberEntries() {
        this.entries.clear();
        ArrayList arrayList = new ArrayList();
        for (Object object : this.e) {
            if (!(object instanceof ke)) continue;
            ke object2 = (ke)object;
            if (object2.f != 3000 && object2.f != 3001 && object2.f != 3002) continue;
            arrayList.add(object);
        }
        this.e.clear();
        for (Object object : arrayList) {
            this.e.add(object);
        }
        int n = (this.d - this.backgroundHeight) / 2;
        for (String string : this.groupMembers) {
            this.entries.add(new MemberEntry(string));
        }
        int n2 = n + this.backgroundHeight - 28;
        int n3 = (this.c - this.backgroundWidth) / 2;
        this.e.add(new ke(1106, n3 + 8, n2, this.backgroundWidth - 16, 20, "Leave Group"));
    }

    private void layoutAndRenderEntries(int n, int n2, float f) {
        int n3 = (this.c - this.backgroundWidth) / 2;
        int n4 = (this.d - this.backgroundHeight) / 2;
        int n5 = n4 + 24;
        int n6 = n4 + this.backgroundHeight - 36;
        if (this.entries.isEmpty()) {
            String string = "No members in group";
            int n7 = this.g.a(string);
            int n8 = n3 + (this.backgroundWidth - n7) / 2;
            int n9 = n4 + this.backgroundHeight / 2;
            this.g.b(string, n8, n9, 0xAAAAAA);
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean bl;
            MemberEntry memberEntry = this.entries.get(i);
            int n10 = n5 + i * 24 - this.scrollOffset;
            boolean bl2 = bl = n10 + 20 > n5 && n10 < n6;
            if (!bl) continue;
            this.g.b(memberEntry.memberName, n3 + 10, n10 + 6, 0xFFFFFF);
        }
    }

    public void updateMemberList(List<String> list) {
        this.groupMembers = new ArrayList<String>(list);
        this.buildMemberEntries();
    }

    public static void updateCurrentMemberList(List<String> list) {
        if (currentInstance != null) {
            currentInstance.updateMemberList(list);
        }
    }

    public void h() {
        if (currentInstance == this) {
            currentInstance = null;
        }
        super.h();
    }

    private static class MemberEntry {
        final String memberName;

        MemberEntry(String string) {
            this.memberName = string;
        }
    }
}

