/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.CreateGroupScreen;
import com.moyettes.voice.gui.GroupMembersScreen;
import com.moyettes.voice.gui.JoinGroupScreen;
import com.moyettes.voice.udp.GroupListPacket;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Mouse;

public class GroupsScreen
extends BaseVoiceScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int NAME_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 20;
    private final List<GroupEntry> entries = new ArrayList<GroupEntry>();
    private int scrollOffset = 0;
    private List<GroupListPacket.GroupInfo> availableGroups = new ArrayList<GroupListPacket.GroupInfo>();
    private static GroupsScreen currentInstance = null;

    @Override
    protected void initContent() {
        currentInstance = this;
        mod_Voice.requestGroupList();
        this.buildGroupEntries();
    }

    @Override
    protected void renderContent(int n, int n2, float f) {
        int n3 = Mouse.getDWheel();
        if (n3 != 0) {
            int n4 = (this.d - this.backgroundHeight) / 2;
            int n5 = n4 + 24;
            int n6 = n4 + this.backgroundHeight - 36;
            int n7 = n6 - n5;
            int n8 = Math.max(0, this.entries.size() * 24 - n7);
            this.scrollOffset -= (int)Math.signum(n3) * 16;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > n8) {
                this.scrollOffset = n8;
            }
        }
        this.layoutAndRenderEntries(n, n2, f);
    }

    @Override
    protected String getBackgroundTexture() {
        return "/assets/legacyvoicechat/textures/gui/group.png";
    }

    @Override
    protected String getTitle() {
        return "Join or Create Group";
    }

    @Override
    protected void handleCustomButtonClick(ke ke2) {
        if (ke2.f >= 5000 && ke2.f < 5000 + this.entries.size()) {
            int n = ke2.f - 5000;
            if (n >= 0 && n < this.entries.size()) {
                GroupEntry groupEntry = this.entries.get(n);
                if (groupEntry.group.hasPassword()) {
                    System.out.println("Opening password dialog for private group: " + groupEntry.group.getName());
                    this.b.a((da)new JoinGroupScreen(groupEntry.group.getName()));
                } else {
                    mod_Voice.joinGroup(groupEntry.group.getName(), null);
                    System.out.println("Joining public group: " + groupEntry.group.getName());
                    this.b.a((da)new GroupMembersScreen());
                }
            }
        } else if (ke2.f == 1105) {
            this.b.a((da)new CreateGroupScreen());
        }
    }

    private void buildGroupEntries() {
        this.entries.clear();
        ArrayList arrayList = new ArrayList();
        for (Object e : this.e) {
            if (!(e instanceof ke)) continue;
            ke ke2 = (ke)e;
            if (ke2.f != 3000 && ke2.f != 3001 && ke2.f != 3002) continue;
            arrayList.add(e);
        }
        this.e.clear();
        for (Object e : arrayList) {
            this.e.add(e);
        }
        int n = (this.c - this.backgroundWidth) / 2;
        int n2 = (this.d - this.backgroundHeight) / 2;
        int n3 = n2 + 24;
        int n4 = n + 10 + 100 + 4;
        int n5 = this.backgroundWidth - 120;
        for (GroupListPacket.GroupInfo groupInfo : this.availableGroups) {
            String string = groupInfo.hasPassword() ? "Join (Private)" : "Join";
            ke ke3 = new ke(5000 + this.entries.size(), n4, n3 + this.entries.size() * 24, n5, 20, string);
            this.e.add(ke3);
            this.entries.add(new GroupEntry(groupInfo, ke3));
        }
        int n6 = n2 + this.backgroundHeight - 28;
        this.e.add(new ke(1105, n + 8, n6, this.backgroundWidth - 16, 20, "Create Group"));
    }

    private void layoutAndRenderEntries(int n, int n2, float f) {
        int n3 = (this.c - this.backgroundWidth) / 2;
        int n4 = (this.d - this.backgroundHeight) / 2;
        int n5 = n4 + 24;
        int n6 = n4 + this.backgroundHeight - 36;
        if (this.entries.isEmpty()) {
            String string = "No groups to join";
            int n7 = this.g.a(string);
            int n8 = n3 + (this.backgroundWidth - n7) / 2;
            int n9 = n4 + this.backgroundHeight / 2;
            this.g.b(string, n8, n9, 0xAAAAAA);
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean bl;
            GroupEntry groupEntry = this.entries.get(i);
            int n10 = n5 + i * 24 - this.scrollOffset;
            groupEntry.joinButton.h = bl = n10 + 20 > n5 && n10 < n6;
            groupEntry.joinButton.c = n3 + 10 + 100 + 4;
            groupEntry.joinButton.d = n10;
            if (!bl) continue;
            String string = groupEntry.group.getName() + " (" + groupEntry.group.getMemberCount() + ")" + (groupEntry.group.hasPassword() ? " [Private]" : " [Public]");
            this.g.b(string, n3 + 10, n10 + 6, 0xFFFFFF);
        }
    }

    public void updateGroupList(List<GroupListPacket.GroupInfo> list) {
        this.availableGroups = new ArrayList<GroupListPacket.GroupInfo>(list);
        this.buildGroupEntries();
    }

    public static void updateCurrentGroupList(List<GroupListPacket.GroupInfo> list) {
        if (currentInstance != null) {
            currentInstance.updateGroupList(list);
        }
    }

    public void h() {
        if (currentInstance == this) {
            currentInstance = null;
        }
        super.h();
    }

    private static class GroupEntry {
        final GroupListPacket.GroupInfo group;
        final ke joinButton;

        GroupEntry(GroupListPacket.GroupInfo groupInfo, ke ke2) {
            this.group = groupInfo;
            this.joinButton = ke2;
        }
    }
}

