/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.widget.VoiceSliderWidget;
import com.moyettes.voice.utils.MinecraftAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

public class PlayersScreen
extends BaseVoiceScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int NAME_WIDTH = 70;
    private static final int SLIDER_HEIGHT = 20;
    private final Map<String, Double> playerNameToVolume = new HashMap<String, Double>();
    private final List<PlayerEntry> entries = new ArrayList<PlayerEntry>();
    private int scrollOffset = 0;

    @Override
    protected void initContent() {
        this.buildPlayerEntries();
    }

    @Override
    protected void renderContent(int n, int n2, float f) {
        int n3 = Mouse.getDWheel();
        if (n3 != 0) {
            int n4 = (this.d - this.backgroundHeight) / 2;
            int n5 = n4 + 24;
            int n6 = n4 + this.backgroundHeight - 36;
            int n7 = n6 - n5;
            int n8 = Math.max(0, this.entries.size() * 24 - n7);
            this.scrollOffset -= (int)Math.signum(n3) * 16;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > n8) {
                this.scrollOffset = n8;
            }
        }
        this.layoutAndRenderEntries(n, n2, f);
    }

    @Override
    protected String getBackgroundTexture() {
        return "/assets/legacyvoicechat/textures/gui/players.png";
    }

    @Override
    protected String getTitle() {
        return "Players";
    }

    @Override
    protected void handleCustomButtonClick(ke ke2) {
    }

    private void buildPlayerEntries() {
        this.entries.clear();
        ArrayList arrayList = new ArrayList();
        for (Object e : this.e) {
            if (!(e instanceof ke)) continue;
            ke ke2 = (ke)e;
            if (ke2.f != 3000 && ke2.f != 3001 && ke2.f != 3002) continue;
            arrayList.add(e);
        }
        this.e.clear();
        for (Object e : arrayList) {
            this.e.add(e);
        }
        Minecraft minecraft = MinecraftAccessor.getMinecraft();
        if (minecraft == null || minecraft.f == null) {
            return;
        }
        int n = (this.c - this.backgroundWidth) / 2;
        int n2 = (this.d - this.backgroundHeight) / 2;
        int n3 = n2 + 24;
        int n4 = n + 10 + 70 + 4;
        int n5 = this.backgroundWidth - 90;
        VoiceClient voiceClient = mod_Voice.getVoiceClient();
        String string = minecraft.h != null ? minecraft.h.l : null;
        for (Object e : minecraft.f.d) {
            if (!(e instanceof gs)) continue;
            gs gs2 = (gs)e;
            if (gs2.l == null || gs2.l.equals(string)) continue;
            float f = 1.0f;
            if (voiceClient != null) {
                f = voiceClient.getPlayerVolume(gs2.l);
            }
            float f2 = f / 2.0f;
            VoiceSliderWidget voiceSliderWidget = new VoiceSliderWidget(4000 + this.entries.size(), n4, n3 + this.entries.size() * 24, n5, 20, gs2.l + ": " + Math.round(f * 100.0f) + "%", f2);
            this.e.add(voiceSliderWidget);
            this.entries.add(new PlayerEntry(gs2.l, voiceSliderWidget));
        }
    }

    private void layoutAndRenderEntries(int n, int n2, float f) {
        int n3 = (this.c - this.backgroundWidth) / 2;
        int n4 = (this.d - this.backgroundHeight) / 2;
        int n5 = n4 + 24;
        int n6 = n4 + this.backgroundHeight - 36;
        int n7 = n3 + 5 + 70 + 4;
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean bl;
            PlayerEntry playerEntry = this.entries.get(i);
            int n8 = n5 + i * 24 - this.scrollOffset;
            playerEntry.slider.h = bl = n8 + 20 > n5 && n8 < n6;
            playerEntry.slider.c = n7;
            playerEntry.slider.d = n8;
            if (!bl) continue;
            double d = Math.max(0.0, Math.min(2.0, (double)playerEntry.slider.i * 2.0));
            this.playerNameToVolume.put(playerEntry.playerName, d);
            playerEntry.slider.e = (int)Math.round(d * 100.0) + "%";
            VoiceClient voiceClient = mod_Voice.getVoiceClient();
            if (voiceClient != null) {
                voiceClient.setPlayerVolume(playerEntry.playerName, (float)d);
            }
            this.g.b(playerEntry.playerName, n3 + 10, n8 + 6, 0xFFFFFF);
        }
    }

    private static class PlayerEntry {
        final String playerName;
        final VoiceSliderWidget slider;

        PlayerEntry(String string, VoiceSliderWidget voiceSliderWidget) {
            this.playerName = string;
            this.slider = voiceSliderWidget;
        }
    }
}

