/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.gui;

import com.moyettes.voice.client.VoiceClient;
import com.moyettes.voice.gui.BaseVoiceScreen;
import com.moyettes.voice.gui.widget.VoiceSliderWidget;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.lwjgl.opengl.GL11;

public class VoiceSettingsScreen
extends BaseVoiceScreen {
    private static final String MICROPHONE_ICON = "/assets/legacyvoicechat/textures/icons/microphone.png";
    private static final String MICROPHONE_MUTE_ICON = "/assets/legacyvoicechat/textures/icons/microphone_off.png";
    private static final String PLAYER_MUTED = "/assets/legacyvoicechat/textures/icons/player_muted.png";
    private static final String PLAYER_TALKING = "/assets/legacyvoicechat/textures/icons/player_talking.png";
    private boolean isMuted = false;
    private boolean isDeafened = false;
    private double threshold = -60.0;
    private float lastSliderValue = 0.5f;
    private float micGain = 1.0f;
    private float voiceVolume = 1.0f;
    private boolean pushToTalk = false;
    private boolean testingMic = false;
    private List<String> inputDevices;
    private int selectedDeviceIndex;
    private List<String> outputDevices;
    private int selectedOutputDeviceIndex;

    @Override
    protected void initContent() {
        VoiceClient voiceClient = mod_Voice.getVoiceClient();
        if (voiceClient != null) {
            this.threshold = voiceClient.getSilenceThreshold();
            this.micGain = voiceClient.getMicrophoneGain();
            this.voiceVolume = voiceClient.getMasterVolume();
            this.testingMic = voiceClient.isMicrophoneTesting();
            this.pushToTalk = voiceClient.isPushToTalk();
        }
        int n = (this.c - this.backgroundWidth) / 2;
        int n2 = (this.d - this.backgroundHeight) / 2;
        this.initVoiceControls(voiceClient, n, n2);
        this.initMuteButton(voiceClient, n, n2);
        this.initDefeanButton(voiceClient, n, n2);
    }

    private void initVoiceControls(VoiceClient voiceClient, int n, int n2) {
        int n3 = n + 8;
        int n4 = n2 + 22;
        int n5 = this.backgroundWidth - 16;
        this.e.add(new VoiceSliderWidget(1100, n3, n4, n5, 20, "Voice Chat Volume: " + Math.round(this.voiceVolume * 100.0f) + "%", Math.max(0.0f, Math.min(1.0f, this.voiceVolume / 2.0f))));
        float f = voiceClient != null ? voiceClient.getMicrophoneGain() : this.micGain;
        this.e.add(new VoiceSliderWidget(1102, n3, n4 + 24, n5, 20, "Microphone Volume: " + Math.round(f * 100.0f) + "%", Math.max(0.0f, Math.min(1.0f, f / 2.0f))));
        String string = "Activation Type: " + (this.pushToTalk ? "Push To Talk" : "Voice");
        this.e.add(new ke(1103, n3, n4 + 48, n5, 20, string));
        double d = 1.0 - Math.max(-127.0, this.threshold) / -127.0;
        this.lastSliderValue = (float)d;
        this.e.add(new VoiceSliderWidget(1104, n3, n4 + 72, n5, 20, "Activation Threshold: " + (int)Math.round(this.threshold) + " dB", (float)d));
        this.buildInputDevices();
        String string2 = voiceClient != null ? voiceClient.getInputDeviceName() : null;
        this.selectedDeviceIndex = string2 != null ? Math.max(0, this.inputDevices.indexOf(string2)) : 0;
        String string3 = "Microphone: " + this.inputDevices.get(this.selectedDeviceIndex);
        this.e.add(new ke(1004, n3, n4 + 96, n5, 20, string3));
        this.buildOutputDevices();
        String string4 = voiceClient != null ? voiceClient.getOutputDeviceName() : null;
        this.selectedOutputDeviceIndex = string4 != null ? Math.max(0, this.outputDevices.indexOf(string4)) : 0;
        String string5 = "Speakers: " + this.outputDevices.get(this.selectedOutputDeviceIndex);
        this.e.add(new ke(1005, n3, n4 + 120, n5, 20, string5));
        String string6 = this.testingMic ? "Disable Microphone Testing" : "Test Microphone";
        this.e.add(new ke(1105, n3, n4 + 144, n5, 20, string6));
    }

    private void initMuteButton(VoiceClient voiceClient, int n, int n2) {
        int n3 = n + 8;
        int n4 = n2 + this.backgroundHeight - 28;
        if (voiceClient != null) {
            this.isMuted = voiceClient.isMicMuted();
        }
        ke ke2 = new ke(2000, n3, n4, 20, 20, null);
        this.e.add(ke2);
    }

    private void initDefeanButton(VoiceClient voiceClient, int n, int n2) {
        int n3 = n + 32;
        int n4 = n2 + this.backgroundHeight - 28;
        if (voiceClient != null) {
            this.isDeafened = voiceClient.isDeafened();
        }
        ke ke2 = new ke(2001, n3, n4, 20, 20, null);
        this.e.add(ke2);
    }

    @Override
    protected void handleCustomButtonClick(ke ke2) {
        VoiceClient voiceClient = mod_Voice.getVoiceClient();
        if (ke2.f == 2000) {
            if (voiceClient != null) {
                voiceClient.toggleMute();
                this.isMuted = voiceClient.isMicMuted();
            }
        } else if (ke2.f == 2001) {
            if (voiceClient != null) {
                voiceClient.toggleDeafened();
                this.isDeafened = voiceClient.isDeafened();
                this.isMuted = voiceClient.isMicMuted();
            }
        } else if (ke2.f == 1103) {
            this.pushToTalk = !this.pushToTalk;
            ke2.e = "Activation Type: " + (this.pushToTalk ? "Push To Talk" : "Voice");
            if (voiceClient != null) {
                voiceClient.setPushToTalk(this.pushToTalk);
            }
        } else if (ke2.f == 1004) {
            this.selectedDeviceIndex = (this.selectedDeviceIndex + 1) % this.inputDevices.size();
            String string = this.inputDevices.get(this.selectedDeviceIndex);
            ke2.e = "Microphone: " + string;
            if (voiceClient != null) {
                if ("Default".equals(string)) {
                    voiceClient.setInputDeviceName(null);
                } else {
                    voiceClient.setInputDeviceName(string);
                }
            }
        } else if (ke2.f == 1005) {
            this.selectedOutputDeviceIndex = (this.selectedOutputDeviceIndex + 1) % this.outputDevices.size();
            String string = this.outputDevices.get(this.selectedOutputDeviceIndex);
            ke2.e = "Speakers: " + string;
            if (voiceClient != null) {
                if ("Default".equals(string)) {
                    voiceClient.setOutputDeviceName(null);
                } else {
                    voiceClient.setOutputDeviceName(string);
                }
            }
        } else if (ke2.f == 1105) {
            this.testingMic = !this.testingMic;
            String string = ke2.e = this.testingMic ? "Disable Microphone Testing" : "Test Microphone";
            if (voiceClient != null) {
                if (this.testingMic) {
                    if (!voiceClient.startMicrophoneTesting()) {
                        this.testingMic = false;
                        ke2.e = "Test Microphone";
                        System.err.println("Failed to start microphone testing");
                    }
                } else {
                    voiceClient.stopMicrophoneTesting();
                }
            }
        }
    }

    @Override
    protected void renderContent(int n, int n2, float f) {
        for (Object e : this.e) {
            VoiceClient voiceClient;
            if (!(e instanceof VoiceSliderWidget)) continue;
            VoiceSliderWidget voiceSliderWidget = (VoiceSliderWidget)((Object)e);
            if (voiceSliderWidget.f == 1100) {
                this.voiceVolume = Math.max(0.0f, Math.min(2.0f, voiceSliderWidget.i * 2.0f));
                voiceSliderWidget.e = "Voice Chat Volume: " + Math.round(this.voiceVolume * 100.0f) + "%";
                voiceClient = mod_Voice.getVoiceClient();
                if (voiceClient == null) continue;
                voiceClient.setMasterVolume(this.voiceVolume);
                continue;
            }
            if (voiceSliderWidget.f == 1102) {
                this.micGain = Math.max(0.0f, Math.min(2.0f, voiceSliderWidget.i * 2.0f));
                voiceSliderWidget.e = "Microphone Volume: " + (int)(this.micGain * 100.0f) + "%";
                voiceClient = mod_Voice.getVoiceClient();
                if (voiceClient == null) continue;
                voiceClient.setMicrophoneGain(this.micGain);
                continue;
            }
            if (voiceSliderWidget.f != 1104) continue;
            if (Math.abs(voiceSliderWidget.i - this.lastSliderValue) > 0.001f) {
                this.lastSliderValue = voiceSliderWidget.i;
                this.threshold = (1.0 - (double)voiceSliderWidget.i) * -127.0;
                this.threshold = Math.max(-127.0, Math.min(0.0, this.threshold));
                voiceClient = mod_Voice.getVoiceClient();
                if (voiceClient != null) {
                    voiceClient.setSilenceThreshold(this.threshold);
                }
            }
            voiceSliderWidget.e = "Activation Threshold: " + (int)Math.round(this.threshold) + " dB";
        }
    }

    @Override
    protected String getBackgroundTexture() {
        return "/assets/legacyvoicechat/textures/gui/background.png";
    }

    @Override
    protected String getTitle() {
        return "Voice Settings";
    }

    public void h() {
        VoiceClient voiceClient = mod_Voice.getVoiceClient();
        if (voiceClient != null && this.testingMic) {
            voiceClient.stopMicrophoneTesting();
        }
        super.h();
    }

    @Override
    protected void drawForeground() {
        super.drawForeground();
        this.drawMuteIcon();
        this.drawDeafenedIcon();
    }

    protected void drawMuteIcon() {
        int n = (this.c - this.backgroundWidth) / 2;
        int n2 = (this.d - this.backgroundHeight) / 2;
        int n3 = n + 8;
        int n4 = n2 + this.backgroundHeight - 28;
        int n5 = 20;
        int n6 = 12;
        int n7 = n3 + (n5 - n6) / 2;
        int n8 = n4 + (n5 - n6) / 2;
        String string = this.isMuted ? MICROPHONE_MUTE_ICON : MICROPHONE_ICON;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n9 = this.b.p.b(string);
        this.b.p.b(n9);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        nw nw2 = nw.a;
        nw2.a(7);
        nw2.a((double)n7, (double)(n8 + n6), 0.0, 0.0, 1.0);
        nw2.a((double)(n7 + n6), (double)(n8 + n6), 0.0, 1.0, 1.0);
        nw2.a((double)(n7 + n6), (double)n8, 0.0, 1.0, 0.0);
        nw2.a((double)n7, (double)n8, 0.0, 0.0, 0.0);
        nw2.a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    protected void drawDeafenedIcon() {
        int n = (this.c - this.backgroundWidth) / 2;
        int n2 = (this.d - this.backgroundHeight) / 2;
        int n3 = n + 32;
        int n4 = n2 + this.backgroundHeight - 28;
        int n5 = 20;
        int n6 = 12;
        int n7 = n3 + (n5 - n6) / 2;
        int n8 = n4 + (n5 - n6) / 2;
        String string = this.isDeafened ? PLAYER_MUTED : PLAYER_TALKING;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n9 = this.b.p.b(string);
        this.b.p.b(n9);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        nw nw2 = nw.a;
        nw2.a(7);
        nw2.a((double)n7, (double)(n8 + n6), 0.0, 0.0, 1.0);
        nw2.a((double)(n7 + n6), (double)(n8 + n6), 0.0, 1.0, 1.0);
        nw2.a((double)(n7 + n6), (double)n8, 0.0, 1.0, 0.0);
        nw2.a((double)n7, (double)n8, 0.0, 0.0, 0.0);
        nw2.a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private void buildInputDevices() {
        this.inputDevices = new ArrayList<String>();
        this.inputDevices.add("Default");
        try {
            Mixer.Info[] infoArray;
            for (Mixer.Info info : infoArray = AudioSystem.getMixerInfo()) {
                try {
                    String string;
                    Mixer mixer = AudioSystem.getMixer(info);
                    Line.Info info2 = new Line.Info(TargetDataLine.class);
                    if (!mixer.isLineSupported(info2) || this.inputDevices.contains(string = info.getName())) continue;
                    this.inputDevices.add(string);
                }
                catch (Exception exception) {
                    System.out.println("  \u2717 Error: " + exception.getMessage());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error getting mixer info: " + exception.getMessage());
        }
        if (this.inputDevices.isEmpty()) {
            this.inputDevices.add("Default");
        }
    }

    private void buildOutputDevices() {
        this.outputDevices = new ArrayList<String>();
        this.outputDevices.add("Default");
        try {
            Mixer.Info[] infoArray;
            for (Mixer.Info info : infoArray = AudioSystem.getMixerInfo()) {
                try {
                    String string;
                    Mixer mixer = AudioSystem.getMixer(info);
                    Line.Info info2 = new Line.Info(SourceDataLine.class);
                    if (!mixer.isLineSupported(info2) || this.outputDevices.contains(string = info.getName())) continue;
                    this.outputDevices.add(string);
                }
                catch (Exception exception) {
                    System.out.println("  \u2717 Error: " + exception.getMessage());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error getting mixer info: " + exception.getMessage());
        }
        if (this.outputDevices.isEmpty()) {
            this.outputDevices.add("Default");
        }
    }
}

