/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.voice.packet;

import com.moyettes.voice.api.Channels;
import com.moyettes.voice.api.CustomPayload;
import com.moyettes.voice.api.DataStreams;
import com.moyettes.voice.api.IOConsumer;
import com.moyettes.voice.api.client.ClientPlayNetworking;
import com.moyettes.voice.packet.CustomPayloadPacket;
import com.moyettes.voice.utils.MinecraftAccessor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientPlayNetworking {
    private static final Logger LOGGER = LogManager.getLogger("Client Play Networking");
    private static Minecraft minecraft = MinecraftAccessor.getMinecraft();
    public static final Map<String, Listener> LISTENERS = new LinkedHashMap<String, Listener>();

    public static <T extends CustomPayload> void registerListener(String string, Supplier<T> supplier, ClientPlayNetworking.PayloadListener<T> payloadListener) {
        ClientPlayNetworking.registerListenerImpl(string, (minecraft, nb2, byArray) -> {
            CustomPayload customPayload = (CustomPayload)supplier.get();
            customPayload.read(DataStreams.input(byArray));
            return payloadListener.handle(minecraft, nb2, customPayload);
        });
    }

    private static void registerListenerImpl(String string, Listener listener) {
        LISTENERS.compute(string, (string2, listener2) -> {
            Channels.validate(string);
            if (listener2 != null) {
                throw new IllegalStateException("there is already a listener on channel '" + string + "'");
            }
            return listener;
        });
    }

    public static boolean handle(nb nb2, CustomPayloadPacket customPayloadPacket) {
        System.out.println("handeling");
        Listener listener = LISTENERS.get(customPayloadPacket.channel);
        if (listener != null) {
            try {
                return listener.handle(minecraft, nb2, customPayloadPacket.data);
            }
            catch (IOException iOException) {
                LOGGER.warn("error handling custom payload on channel '" + customPayloadPacket.channel + "'", (Throwable)iOException);
                return true;
            }
        }
        return false;
    }

    public static void send(String string, CustomPayload customPayload) {
        Minecraft minecraft = MinecraftAccessor.getMinecraft();
        ki ki2 = ClientPlayNetworking.makePacket(string, customPayload);
        nb nb2 = minecraft.s();
        nb2.b(ki2);
    }

    private static ki makePacket(String string, CustomPayload customPayload) {
        return ClientPlayNetworking.makePacket(string, customPayload::write);
    }

    private static ki makePacket(String string, IOConsumer<DataOutputStream> iOConsumer) {
        try {
            return new CustomPayloadPacket(string, DataStreams.output(iOConsumer).toByteArray());
        }
        catch (IOException iOException) {
            LOGGER.warn("error writing custom payload to channel '" + string + "'", (Throwable)iOException);
            return null;
        }
    }

    private static interface Listener {
        public boolean handle(Minecraft var1, nb var2, byte[] var3) throws IOException;
    }
}

